DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-10
      0.00000000000000E+00  -1.22248100565334E-11   0.00000000000000E+00   1.97004158066829E-13   1.66478653341496E-22
      1.22247884334386E-08   1.22249854375968E-08  -7.89593879202804E-19  -2.50634423491830E-01  -2.50634423491825E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.48782128771907E-12   0.00000000000000E+00  -4.48782128771907E-12
      3.69848470502354E-18  -2.50634423491831E-01  -2.46784373370040E-01   0.00000000000000E+00  -1.99541775523642E-13
     -9.83531228659703E-23  -1.22202980745335E-08  -1.22204976163091E-08  -2.90889082582074E-18
      1.17500000000000E-09
      0.00000000000000E+00  -1.24273277020760E-11   0.00000000000000E+00   2.04427064105731E-13   1.68705730272507E-22
      1.24272869205074E-08   1.24274913475716E-08  -7.88042275316154E-19  -2.51349385892093E-01  -2.51349385892088E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.74581126099434E-12   0.00000000000000E+00  -4.74581126099434E-12
      3.69528128242237E-18  -2.51349385892101E-01  -2.47435620879709E-01   0.00000000000000E+00  -2.10079482041272E-13
     -9.83784494922563E-23  -1.24225354568285E-08  -1.24227455363106E-08  -2.90723900710621E-18
      2.08625000000000E-09
      0.00000000000000E+00  -1.26296616581442E-11   0.00000000000000E+00   3.87984165837476E-14   1.70156976924117E-22
      1.26295624593746E-08   1.26296012577913E-08  -7.86445318605386E-19  -2.52123214179500E-01  -2.52123214179495E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.58741381225451E-12   0.00000000000000E+00  -4.58741381225451E-12
      3.69110100158595E-18  -2.52123214179518E-01  -2.48145673396897E-01   0.00000000000000E+00  -4.56073757709140E-14
     -9.84147762127647E-23  -1.26249682366032E-08  -1.26250138439791E-08  -2.90465568298057E-18
      3.31643750000000E-09
      0.00000000000000E+00  -1.28223519168056E-11   0.00000000000000E+00   4.12064447796302E-14   1.70761867693171E-22
      1.28223332810399E-08   1.28223744874848E-08  -7.84873672108027E-19  -2.52920928691198E-01  -2.52920928691194E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.04893211444479E-12   0.00000000000000E+00  -4.04893211444479E-12
      3.68612005591041E-18  -2.52920928691217E-01  -2.48882486566450E-01   0.00000000000000E+00  -4.83429295673881E-14
     -9.84612107309042E-23  -1.28182772124407E-08  -1.28183255553704E-08  -2.90124638380238E-18
      4.97719062500000E-09
      0.00000000000000E+00  -1.29970406069743E-11   0.00000000000000E+00   4.12554658657509E-14   1.70644479832602E-22
      1.29970415740060E-08   1.29970828294721E-08  -7.83404424976725E-19  -2.53694847298376E-01  -2.53694847298373E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.23858909994313E-12   0.00000000000000E+00  -3.23858909994313E-12
      3.68074155894209E-18  -2.53694847298143E-01  -2.49601108706305E-01   0.00000000000000E+00  -4.76392293872756E-14
     -9.85141037679991E-23  -1.29937966011427E-08  -1.29938442403721E-08  -2.89733713396536E-18
      6.97719062500000E-09
      0.00000000000000E+00  -1.31351750917344E-11   0.00000000000000E+00   2.80388382108448E-14   1.70138745879722E-22
      1.31351596326639E-08   1.31351876715023E-08  -7.82213913561807E-19  -2.54337765696374E-01  -2.54337765696372E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.39854136478510E-12   0.00000000000000E+00  -2.39854136478510E-12
      3.67594447621252E-18  -2.54337765695454E-01  -2.50200248908233E-01   0.00000000000000E+00  -3.31146108331146E-14
     -9.85631196601967E-23  -1.31327560155266E-08  -1.31327891301375E-08  -2.89373056265071E-18
      8.97719062500000E-09
      0.00000000000000E+00  -1.32283975000001E-11   0.00000000000000E+00   2.31555231663186E-15   1.69614273528899E-22
      1.32283978854826E-08   1.32284002010351E-08  -7.81397129909544E-19  -2.54785260093094E-01  -2.54785260093092E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.74215349268062E-12   0.00000000000000E+00  -1.74215349268062E-12
      3.67246016922716E-18  -2.54785260091229E-01  -2.50618162197709E-01   0.00000000000000E+00  -6.12819779025431E-15
     -9.85996515408711E-23  -1.32266519193445E-08  -1.32266580475424E-08  -2.89106303931762E-18
      1.09771906250000E-08
      0.00000000000000E+00  -1.32924132818337E-11   0.00000000000000E+00   5.38151105274720E-15   1.69173897403568E-22
      1.32924171299222E-08   1.32924225114334E-08  -7.80830177503195E-19  -2.55098453557190E-01  -2.55098453557189E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25172203736527E-12   0.00000000000000E+00  -1.25172203736527E-12
      3.66995672515243E-18  -2.55098453554039E-01  -2.50911032146412E-01   0.00000000000000E+00  -8.21535513011012E-15
     -9.86263676759911E-23  -1.32911625740408E-08  -1.32911707893960E-08  -2.88912654764923E-18
      1.29771906250000E-08
      0.00000000000000E+00  -1.33367742899050E-11   0.00000000000000E+00   2.81814525109778E-14   1.68833070236214E-22
      1.33368459674188E-08   1.33368741488715E-08  -7.80433914336105E-19  -2.55318391402346E-01  -2.55318391402345E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.93691099245735E-13   0.00000000000000E+00  -8.93691099245735E-13
      3.66816934295394E-18  -2.55318391398503E-01  -2.51116860049334E-01   0.00000000000000E+00  -3.03439913820626E-14
     -9.86456760775430E-23  -1.33359501137807E-08  -1.33359804577722E-08  -2.88773542861783E-18
      1.49771906250000E-08
      0.00000000000000E+00  -1.33679096558183E-11   0.00000000000000E+00   3.13502462453258E-15   1.68579623045240E-22
      1.33678979735807E-08   1.33679011086055E-08  -7.80155892431290E-19  -2.55473131271215E-01  -2.55473131271214E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.35614098220281E-13   0.00000000000000E+00  -6.35614098220281E-13
      3.66689811475750E-18  -2.55473131267179E-01  -2.51261735835542E-01   0.00000000000000E+00  -4.62751624332493E-15
     -9.86595674882332E-23  -1.33672608669909E-08  -1.33672654945072E-08  -2.88674222232621E-18
      1.69771906250000E-08
      0.00000000000000E+00  -1.33896768585365E-11   0.00000000000000E+00   1.41782582695938E-14   1.68394768567617E-22
      1.33896664699327E-08   1.33896806481911E-08  -7.79960314259216E-19  -2.55582154074938E-01  -2.55582154074938E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.51000305752231E-13   0.00000000000000E+00  -4.51000305752231E-13
      3.66599611414599E-18  -2.55582154071525E-01  -2.51363842394800E-01   0.00000000000000E+00  -1.53092563973464E-14
     -9.86694736735814E-23  -1.33892143386289E-08  -1.33892296478854E-08  -2.88603579988678E-18
      1.89771906250000E-08
      0.00000000000000E+00  -1.34050149296502E-11   0.00000000000000E+00   9.21335865028537E-16   1.68261746663928E-22
      1.34049783211493E-08   1.34049792424853E-08  -7.79822563199812E-19  -2.55659016339182E-01  -2.55659016339182E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.19514580183320E-13   0.00000000000000E+00  -3.19514580183320E-13
      3.66535708498563E-18  -2.55659016338055E-01  -2.51435839319116E-01   0.00000000000000E+00  -1.68212095583728E-15
     -9.86765494852021E-23  -1.34046580457841E-08  -1.34046597279051E-08  -2.88553452178581E-18
      2.09771906250000E-08
      0.00000000000000E+00  -1.34157607639034E-11   0.00000000000000E+00   3.40909572425617E-15   1.68166536980617E-22
      1.34157557140668E-08   1.34157591231627E-08  -7.79725436884874E-19  -2.55713239559190E-01  -2.55713239559190E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.26146902281042E-13   0.00000000000000E+00  -2.26146902281042E-13
      3.66490479118106E-18  -2.55713239562096E-01  -2.51486637754935E-01   0.00000000000000E+00  -3.96703636904502E-15
     -9.86815674116867E-23  -1.34155290092239E-08  -1.34155329762604E-08  -2.88517935429619E-18
      2.29771906250000E-08
      0.00000000000000E+00  -1.34233838770917E-11   0.00000000000000E+00   3.19446709866385E-16   1.68098762540657E-22
      1.34233533799967E-08   1.34233536994435E-08  -7.79656923354457E-19  -2.55751502367256E-01  -2.55751502367256E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.59957432015174E-13   0.00000000000000E+00  -1.59957432015174E-13
      3.66458487631703E-18  -2.55751502376169E-01  -2.51522486108345E-01   0.00000000000000E+00  -7.03331167352790E-16
     -9.86851336455758E-23  -1.34231930386803E-08  -1.34231937420115E-08  -2.88492795296258E-18
      2.49771906250000E-08
      0.00000000000000E+00  -1.34287108718497E-11   0.00000000000000E+00   8.93599822679939E-16   1.68050607415499E-22
      1.34287107400240E-08   1.34287116336240E-08  -7.79608572223522E-19  -2.55778510400197E-01  -2.55778510400197E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13093580424760E-13   0.00000000000000E+00  -1.13093580424760E-13
      3.66435868915618E-18  -2.55778510416503E-01  -2.51547791571257E-01   0.00000000000000E+00  -1.17016257968982E-15
     -9.86876582866244E-23  -1.34285973698809E-08  -1.34285985400435E-08  -2.88475011693266E-18
      2.69771906250000E-08
      0.00000000000000E+00  -1.34325683508124E-11   0.00000000000000E+00   7.17534074757377E-16   1.68016480502426E-22
      1.34324908491417E-08   1.34324915666759E-08  -7.79574442983916E-19  -2.55797576973005E-01  -2.55797576973004E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.99357218692020E-14   0.00000000000000E+00  -7.99357218692020E-14
      3.66419881771245E-18  -2.55797576996662E-01  -2.51565656799281E-01   0.00000000000000E+00  -9.18053981069029E-16
     -9.86894477341291E-23  -1.34324107129000E-08  -1.34324116309540E-08  -2.88462437472853E-18
      2.89771906250000E-08
      0.00000000000000E+00  -1.34351400034542E-11   0.00000000000000E+00   2.53455883277874E-16   1.67992291513545E-22
      1.34351587201197E-08   1.34351589735757E-08  -7.79550348598654E-19  -2.55811038622970E-01  -2.55811038622970E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.64883619652211E-14   0.00000000000000E+00  -5.64883619652211E-14
      3.66408584098852E-18  -2.55811038651547E-01  -2.51578270566613E-01   0.00000000000000E+00  -3.92025622726634E-16
     -9.86907133781699E-23  -1.34351020931881E-08  -1.34351024852138E-08  -2.88453549238986E-18
      3.09771906250000E-08
      0.00000000000000E+00  -1.34369768981984E-11   0.00000000000000E+00   2.01162776240185E-16   1.67975182359361E-22
      1.34370418244506E-08   1.34370420256136E-08  -7.79533336503509E-19  -2.55820544006046E-01  -2.55820544006046E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.99131575411004E-14   0.00000000000000E+00  -3.99131575411004E-14
      3.66400601467343E-18  -2.55820544033794E-01  -2.51587177463177E-01   0.00000000000000E+00  -2.99657130483109E-16
     -9.86916091474635E-23  -1.34370018127988E-08  -1.34370021124560E-08  -2.88447267816992E-18
      3.29771906250000E-08
      0.00000000000000E+00  -1.34383545692565E-11   0.00000000000000E+00   9.32084549499990E-16   1.67963089768281E-22
      1.34383711087893E-08   1.34383720408740E-08  -7.79521323071172E-19  -2.55827256613474E-01  -2.55827256613473E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.81988638030989E-14   0.00000000000000E+00  -2.81988638030989E-14
      3.66394961694583E-18  -2.55827256630452E-01  -2.51593467584139E-01   0.00000000000000E+00  -1.01231775578058E-15
     -9.86922424539818E-23  -1.34383428296924E-08  -1.34383438420102E-08  -2.88442829387466E-18
      3.49771906250000E-08
      0.00000000000000E+00  -1.34393648613658E-11   0.00000000000000E+00   6.14241976718314E-17   1.67954520612545E-22
      1.34393100620830E-08   1.34393101235074E-08  -7.79512840423205E-19  -2.55831996542670E-01  -2.55831996542670E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.99210893393623E-14   0.00000000000000E+00  -1.99210893393623E-14
      3.66390977476715E-18  -2.55831996535267E-01  -2.51597909068637E-01   0.00000000000000E+00  -1.11630163844037E-16
     -9.86926902152558E-23  -1.34392900907878E-08  -1.34392902024181E-08  -2.88439693434394E-18
      3.69771906250000E-08
      0.00000000000000E+00  -1.34399159297890E-11   0.00000000000000E+00   2.39567185011306E-16   1.67948472851548E-22
      1.34399727918076E-08   1.34399730313749E-08  -7.79506849832816E-19  -2.55835344090729E-01  -2.55835344090729E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.40728153572205E-14   0.00000000000000E+00  -1.40728153572205E-14
      3.66388162913644E-18  -2.55835344043763E-01  -2.51601045944171E-01   0.00000000000000E+00  -2.76693765574146E-16
     -9.86930067133229E-23  -1.34399586818657E-08  -1.34399589585596E-08  -2.88437477930361E-18
      3.89771906250000E-08
      0.00000000000000E+00  -1.34403751534750E-11   0.00000000000000E+00   2.10948679259300E-17   1.67944194360994E-22
      1.34404408978170E-08   1.34404409189120E-08  -7.79502619264862E-19  -2.55837708165861E-01  -2.55837708165861E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.94085256377680E-15   0.00000000000000E+00  -9.94085256377680E-15
      3.66386174743131E-18  -2.55837708066259E-01  -2.51603261190363E-01   0.00000000000000E+00  -4.56989288329633E-17
     -9.86932303970757E-23  -1.34404309323604E-08  -1.34404309780594E-08  -2.88435912816644E-18
      4.09771906250000E-08
      0.00000000000000E+00  -1.34407425324239E-11   0.00000000000000E+00   6.36672671492817E-17   1.67941173534585E-22
      1.34407714064419E-08   1.34407714701094E-08  -7.79499631385615E-19  -2.55839377845131E-01  -2.55839377845131E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.02199975208743E-15   0.00000000000000E+00  -7.02199975208743E-15
      3.66384770343180E-18  -2.55839377687522E-01  -2.51604825766685E-01   0.00000000000000E+00  -8.14626318775192E-17
     -9.86933884594739E-23  -1.34407643666469E-08  -1.34407644481096E-08  -2.88434807204619E-18
      4.29771906250000E-08
      0.00000000000000E+00  -1.34410180666355E-11   0.00000000000000E+00   8.15064605097708E-18   1.67939038079241E-22
      1.34410048450359E-08   1.34410048531867E-08  -7.79497521211199E-19  -2.55840557056460E-01  -2.55840557056460E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.96001490110710E-15   0.00000000000000E+00  -4.96001490110710E-15
      3.66383778340200E-18  -2.55840556850287E-01  -2.51605930736091E-01   0.00000000000000E+00  -2.03158137590504E-17
     -9.86935001447048E-23  -1.34409998728559E-08  -1.34409998931718E-08  -2.88434026219080E-18
      4.49771906250000E-08
      0.00000000000000E+00  -1.34412017561099E-11   0.00000000000000E+00   1.78878520122599E-17   1.67937529967284E-22
      1.34411696879729E-08   1.34411697058609E-08  -7.79496030876974E-19  -2.55841389897859E-01  -2.55841389897859E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.50344577459785E-15   0.00000000000000E+00  -3.50344577459785E-15
      3.66383077651045E-18  -2.55841389674778E-01  -2.51606711168642E-01   0.00000000000000E+00  -2.65806124312437E-17
     -9.86935790534794E-23  -1.34411661758344E-08  -1.34411662024151E-08  -2.88433474563348E-18
      4.69771906250000E-08
      0.00000000000000E+00  -1.34412936008471E-11   0.00000000000000E+00   3.47624057985520E-18   1.67936464223710E-22
      1.34412861071752E-08   1.34412861106516E-08  -7.79494978366497E-19  -2.55841978077564E-01  -2.55841978077564E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.47447800248795E-15   0.00000000000000E+00  -2.47447800248795E-15
      3.66382582755444E-18  -2.55841977896917E-01  -2.51607262389276E-01   0.00000000000000E+00  -9.51863157551537E-18
     -9.86936348067072E-23  -1.34412836266549E-08  -1.34412836361736E-08  -2.88433084918795E-18
      4.89771906250000E-08
      0.00000000000000E+00  -1.34413854455843E-11   0.00000000000000E+00   5.47456651239395E-18   1.67935711434087E-22
      1.34413683132870E-08   1.34413683187617E-08  -7.79494235099179E-19  -2.55842393448667E-01  -2.55842393448667E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.74757860524905E-15   0.00000000000000E+00  -1.74757860524905E-15
      3.66382233239723E-18  -2.55842393398025E-01  -2.51607651762705E-01   0.00000000000000E+00  -9.76839168367607E-18
     -9.86936742012343E-23  -1.34413665614146E-08  -1.34413665711831E-08  -2.88432809729805E-18
      5.09771906250000E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   1.59337607189145E-18   1.67935179524047E-22
      1.34414263595743E-08   1.34414263611679E-08  -7.79493710277071E-19  -2.55842686748565E-01  -2.55842686748565E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23404625415673E-15   0.00000000000000E+00  -1.23404625415673E-15
      3.66381986430473E-18  -2.55842686935608E-01  -2.51607926851284E-01   0.00000000000000E+00  -4.59888817995005E-18
     -9.86937020432451E-23  -1.34414251225226E-08  -1.34414251271216E-08  -2.88432615402765E-18
      5.29771906250000E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   1.87222785763305E-18   1.67934803790475E-22
      1.34414673407230E-08   1.34414673425954E-08  -7.79493339738006E-19  -2.55842893830018E-01  -2.55842893830018E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.71276446999990E-16   0.00000000000000E+00  -8.71276446999990E-16
      3.66381812175183E-18  -2.55842894362321E-01  -2.51608121252783E-01   0.00000000000000E+00  -4.00803834804843E-18
     -9.86937217258080E-23  -1.34414664673108E-08  -1.34414664713190E-08  -2.88432478201383E-18
      5.49771906250000E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   7.58402678651553E-19   1.67934538396261E-22
      1.34414962766026E-08   1.34414962773611E-08  -7.79493078127675E-19  -2.55843040033746E-01  -2.55843040033746E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.15079074594635E-16   0.00000000000000E+00  -6.15079074594635E-16
      3.66381689159368E-18  -2.55843040984354E-01  -2.51608258677984E-01   0.00000000000000E+00  -2.25780643212099E-18
     -9.86937356449898E-23  -1.34414956600242E-08  -1.34414956622821E-08  -2.88432381346601E-18
      5.69771906250000E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   7.15874365929727E-19   1.67934351079982E-22
      1.34415167177109E-08   1.34415167184270E-08  -7.79492893348399E-19  -2.55843143291215E-01  -2.55843143291215E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.34292951622263E-16   0.00000000000000E+00  -4.34292951622263E-16
      3.66381602300778E-18  -2.55843144651047E-01  -2.51608355847845E-01   0.00000000000000E+00  -1.78443708634269E-18
     -9.86937454878879E-23  -1.34415162823495E-08  -1.34415162841340E-08  -2.88432312965938E-18
      5.89771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.69885125985922E-19   1.67934219043354E-22
      1.34415311805854E-08   1.34415311809555E-08  -7.79492762659386E-19  -2.55843216304449E-01  -2.55843216304449E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.06941801471365E-16   0.00000000000000E+00  -3.06941801471365E-16
      3.66381540912418E-18  -2.55843217927427E-01  -2.51608424527638E-01   0.00000000000000E+00  -1.11934284989754E-18
     -9.86937524404693E-23  -1.34415308728942E-08  -1.34415308740137E-08  -2.88432264646479E-18
      6.09771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.10483749998783E-19   1.67934126212140E-22
      1.34415414490534E-08   1.34415414493640E-08  -7.79492669930938E-19  -2.55843268082024E-01  -2.55843268082024E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.17515052562658E-16   0.00000000000000E+00  -2.17515052562658E-16
      3.66381497409407E-18  -2.55843269635318E-01  -2.51608472972320E-01   0.00000000000000E+00  -8.34382671428205E-19
     -9.86937573322932E-23  -1.34415412310145E-08  -1.34415412318490E-08  -2.88432230416313E-18
      6.29771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.85234266178612E-19   1.67934061190597E-22
      1.34415487859648E-08   1.34415487861502E-08  -7.79492603734708E-19  -2.55843305008642E-01  -2.55843305008642E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.55015572317582E-16   0.00000000000000E+00  -1.55015572317582E-16
      3.66381466406293E-18  -2.55843305947535E-01  -2.51608506953385E-01   0.00000000000000E+00  -5.52451085281368E-19
     -9.86937607425512E-23  -1.34415486305820E-08  -1.34415486311346E-08  -2.88432206032822E-18
      6.49771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.44737817025804E-19   1.67934015843298E-22
      1.34415540780086E-08   1.34415540781535E-08  -7.79492556025397E-19  -2.55843331584731E-01  -2.55843331584731E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11563178123010E-16   0.00000000000000E+00  -1.11563178123010E-16
      3.66381444093657E-18  -2.55843331177409E-01  -2.51608530502332E-01   0.00000000000000E+00  -3.91376060999002E-19
     -9.86937630762104E-23  -1.34415539661988E-08  -1.34415539665903E-08  -2.88432188491118E-18
      6.69771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   9.65327225593941E-20   1.67933984256782E-22
      1.34415579345129E-08   1.34415579346096E-08  -7.79492521247410E-19  -2.55843350928714E-01  -2.55843350928714E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.13896254183946E-17   0.00000000000000E+00  -8.13896254183946E-17
      3.66381427815732E-18  -2.55843348358213E-01  -2.51608546458652E-01   0.00000000000000E+00  -2.57841840934319E-19
     -9.86937646224082E-23  -1.34415578529621E-08  -1.34415578532200E-08  -2.88432175690991E-18
      6.89771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   7.38438841820408E-20   1.67933962018667E-22
      1.34415607541098E-08   1.34415607541838E-08  -7.79492495732567E-19  -2.55843365115705E-01  -2.55843365115705E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.01330049958684E-17   0.00000000000000E+00  -6.01330049958684E-17
      3.66381415789131E-18  -2.55843359680746E-01  -2.51608556886182E-01   0.00000000000000E+00  -1.72933353158615E-19
     -9.86937655988146E-23  -1.34415606938778E-08  -1.34415606940508E-08  -2.88432166215874E-18
      7.09771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   5.01564881911105E-20   1.67933945727007E-22
      1.34415627716602E-08   1.34415627717105E-08  -7.79492477284698E-19  -2.55843375409695E-01  -2.55843375409695E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.43692082563155E-17   0.00000000000000E+00  -4.43692082563155E-17
      3.66381406915289E-18  -2.55843366829862E-01  -2.51608563394708E-01   0.00000000000000E+00  -1.08016135115528E-19
     -9.86937661866965E-23  -1.34415627272332E-08  -1.34415627273413E-08  -2.88432159186820E-18
      7.29771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.36491969454236E-20   1.67933932703934E-22
      1.34415640957285E-08   1.34415640957623E-08  -7.79492464857394E-19  -2.55843382439971E-01  -2.55843382439971E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.13526416792712E-17   0.00000000000000E+00  -3.13526416792712E-17
      3.66381400644761E-18  -2.55843371241259E-01  -2.51608567384861E-01   0.00000000000000E+00  -7.01495867838259E-20
     -9.86937665562951E-23  -1.34415640643394E-08  -1.34415640644097E-08  -2.88432154159022E-18
      7.49771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.49527601622796E-20   1.67933920886177E-22
      1.34415647458890E-08   1.34415647459041E-08  -7.79492458243153E-19  -2.55843386366160E-01  -2.55843386366160E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.89480027339246E-17   0.00000000000000E+00  -1.89480027339246E-17
      3.66381396855161E-18  -2.55843374280355E-01  -2.51608570215222E-01   0.00000000000000E+00  -5.10270255978185E-20
     -9.86937668819798E-23  -1.34415647269050E-08  -1.34415647269561E-08  -2.88432151030845E-18
      7.69771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -1.06805429730569E-21   1.67933908876299E-22
      1.34415646974410E-08   1.34415646974401E-08  -7.79492457702739E-19  -2.55843387070800E-01  -2.55843387070800E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.73736785869883E-18   0.00000000000000E+00  -5.73736785869883E-18
      3.66381395707687E-18  -2.55843377330977E-01  -2.51608573276955E-01   0.00000000000000E+00  -5.74902171845965E-20
     -9.86937673438117E-23  -1.34415646916451E-08  -1.34415646917027E-08  -2.88432149937413E-18
      7.89771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -1.98358166242765E-20   1.67933896122063E-22
      1.34415639383627E-08   1.34415639383430E-08  -7.79492463486224E-19  -2.55843384407161E-01  -2.55843384407161E-01
      0.00000000000000E+00   0.00000000000000E+00   8.73199343803362E-18   0.00000000000000E+00   8.73199343803362E-18
      3.66381397454086E-18  -2.55843381771934E-01  -2.51608577952517E-01   0.00000000000000E+00  -8.25254830678457E-20
     -9.86937681126140E-23  -1.34415639469924E-08  -1.34415639470750E-08  -2.88432151105463E-18
      8.09771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -3.43734255442815E-20   1.67933883168514E-22
      1.34415625387146E-08   1.34415625386803E-08  -7.79492475233293E-19  -2.55843378511807E-01  -2.55843378511807E-01
      0.00000000000000E+00   0.00000000000000E+00   2.36248395227264E-17   0.00000000000000E+00   2.36248395227264E-17
      3.66381402179053E-18  -2.55843388819740E-01  -2.51608585436611E-01   0.00000000000000E+00  -1.26357773039636E-19
     -9.86937693160693E-23  -1.34415625621787E-08  -1.34415625623052E-08  -2.88432154655724E-18
      8.29771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -4.36713502831550E-20   1.67933871889186E-22
      1.34415607260365E-08   1.34415607259930E-08  -7.79492491297157E-19  -2.55843370162431E-01  -2.55843370162431E-01
      0.00000000000000E+00   0.00000000000000E+00   3.65325246914163E-17   0.00000000000000E+00   3.65325246914163E-17
      3.66381409485558E-18  -2.55843399228402E-01  -2.51608596412316E-01   0.00000000000000E+00  -1.75159075898035E-19
     -9.86937709868107E-23  -1.34415607623503E-08  -1.34415607625255E-08  -2.88432160355843E-18
      8.49771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -4.25429436026112E-20   1.67933865563926E-22
      1.34415589517736E-08   1.34415589517313E-08  -7.79492508109532E-19  -2.55843361123511E-01  -2.55843361123511E-01
      0.00000000000000E+00   0.00000000000000E+00   4.33845507598701E-17   0.00000000000000E+00   4.33845507598701E-17
      3.66381418162469E-18  -2.55843412866247E-01  -2.51608610607009E-01   0.00000000000000E+00  -2.18228731208906E-19
     -9.86937729987365E-23  -1.34415589948975E-08  -1.34415589951158E-08  -2.88432167351515E-18
      8.69771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -2.44372286311620E-20   1.67933868638417E-22
      1.34415579246502E-08   1.34415579246260E-08  -7.79492519787385E-19  -2.55843354378148E-01  -2.55843354378148E-01
      0.00000000000000E+00   0.00000000000000E+00   3.87554010542958E-17   0.00000000000000E+00   3.87554010542958E-17
      3.66381425913549E-18  -2.55843428235831E-01  -2.51608626301663E-01   0.00000000000000E+00  -2.30999661274122E-19
     -9.86937750050961E-23  -1.34415579631503E-08  -1.34415579633814E-08  -2.88432173934810E-18
      8.89771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.65822745097101E-20   1.67933885996381E-22
      1.34415585795786E-08   1.34415585795953E-08  -7.79492518254622E-19  -2.55843354104529E-01  -2.55843354104529E-01
      0.00000000000000E+00   0.00000000000000E+00   1.67672818610337E-17   0.00000000000000E+00   1.67672818610337E-17
      3.66381429267005E-18  -2.55843442062329E-01  -2.51608639928752E-01   0.00000000000000E+00  -1.85168427215079E-19
     -9.86937764007874E-23  -1.34415585961773E-08  -1.34415585963626E-08  -2.88432177441543E-18
      9.09771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   8.50054173609048E-20   1.67933921617863E-22
      1.34415619483478E-08   1.34415619484330E-08  -7.79492494186828E-19  -2.55843365233462E-01  -2.55843365233462E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.72639478572189E-17   0.00000000000000E+00  -2.72639478572189E-17
      3.66381423814215E-18  -2.55843449138762E-01  -2.51608645957693E-01   0.00000000000000E+00  -5.19396267867835E-20
     -9.86937763384307E-23  -1.34415619211170E-08  -1.34415619211691E-08  -2.88432174395533E-18
      9.29771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.83315791935678E-19   1.67933976608810E-22
      1.34415689055126E-08   1.34415689056961E-08  -7.79492439045473E-19  -2.55843392439665E-01  -2.55843392439665E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.44319274251199E-17   0.00000000000000E+00  -9.44319274251199E-17
      3.66381404927830E-18  -2.55843442664176E-01  -2.51608637312338E-01   0.00000000000000E+00   1.77653641071879E-19
     -9.86937738317997E-23  -1.34415688114417E-08  -1.34415688112641E-08  -2.88432161023283E-18
      9.49771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   2.72095976539115E-19   1.67934046781047E-22
      1.34415797836835E-08   1.34415797839558E-08  -7.79492348310584E-19  -2.55843438494923E-01  -2.55843438494923E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.79321715453875E-16   0.00000000000000E+00  -1.79321715453875E-16
      3.66381369063487E-18  -2.55843415317910E-01  -2.51608606565526E-01   0.00000000000000E+00   5.30938203947109E-19
     -9.86937679753213E-23  -1.34415796051649E-08  -1.34415796046341E-08  -2.88432134232429E-18
      9.69771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.70111904638089E-19   1.67934120232645E-22
      1.34415938895912E-08   1.34415938899615E-08  -7.79492225718583E-19  -2.55843502062525E-01  -2.55843502062525E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.67127581793825E-16   0.00000000000000E+00  -2.67127581793825E-16
      3.66381315637971E-18  -2.55843361248232E-01  -2.51608548079280E-01   0.00000000000000E+00   9.30761769739357E-19
     -9.86937582913068E-23  -1.34415936237646E-08  -1.34415936228339E-08  -2.88432093066113E-18
      9.89771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.75177847109899E-19   1.67934175697471E-22
      1.34416090063078E-08   1.34416090066832E-08  -7.79492087854760E-19  -2.55843575246564E-01  -2.55843575246564E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.31752131545217E-16   0.00000000000000E+00  -3.31752131545217E-16
      3.66381249287544E-18  -2.55843278985372E-01  -2.51608461074074E-01   0.00000000000000E+00   1.35950875798347E-18
     -9.86937451849577E-23  -1.34416086762905E-08  -1.34416086749311E-08  -2.88432040502068E-18
      1.00977190625000E-07
      0.00000000000000E+00  -1.34416609797960E-11   0.00000000000000E+00   2.99982435315343E-19   1.67934182729462E-22
      1.34416210305676E-08   1.34416210308677E-08  -7.79491967883138E-19  -2.55843641506545E-01  -2.55843641506545E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.36174389026363E-16   0.00000000000000E+00  -3.36174389026363E-16
      3.66381182052667E-18  -2.55843175002317E-01  -2.51608353304010E-01   0.00000000000000E+00   1.61582350073585E-18
     -9.86937304363559E-23  -1.34416206963091E-08  -1.34416206946933E-08  -2.88431985264353E-18
      1.02977190625000E-07
      0.00000000000000E+00  -1.34416609797960E-11   0.00000000000000E+00   8.29662383514942E-20   1.67934104949969E-22
      1.34416239567634E-08   1.34416239568466E-08  -7.79491916612744E-19  -2.55843674861765E-01  -2.55843674861765E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.36572366088033E-16   0.00000000000000E+00  -2.36572366088033E-16
      3.66381134738193E-18  -2.55843067241919E-01  -2.51608244590271E-01   0.00000000000000E+00   1.53323949414487E-18
     -9.86937176008373E-23  -1.34416237218074E-08  -1.34416237202742E-08  -2.88431943076919E-18
      1.04977190625000E-07
      0.00000000000000E+00  -1.34416609797960E-11   0.00000000000000E+00  -2.11621059674377E-19   1.67933907477277E-22
      1.34416104562462E-08   1.34416104560347E-08  -7.79491998686477E-19  -2.55843641546731E-01  -2.55843641546731E-01
      0.00000000000000E+00   0.00000000000000E+00   8.48491536928369E-18   0.00000000000000E+00   8.48491536928369E-18
      3.66381136435177E-18  -2.55842987463590E-01  -2.51608168988194E-01   0.00000000000000E+00   8.01485135983111E-19
     -9.86937121227137E-23  -1.34416104653210E-08  -1.34416104645196E-08  -2.88431936566529E-18
      1.06977190625000E-07
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -8.26352146737333E-19   1.67933569103879E-22
      1.34415732861936E-08   1.34415732853674E-08  -7.79492281677919E-19  -2.55843505313497E-01  -2.55843505313497E-01
      0.00000000000000E+00   0.00000000000000E+00   4.23139659735746E-16   0.00000000000000E+00   4.23139659735746E-16
      3.66381221063109E-18  -2.55842980829275E-01  -2.51608173934060E-01   0.00000000000000E+00  -5.25073049612419E-19
     -9.86937209274718E-23  -1.34415737079819E-08  -1.34415737085071E-08  -2.88431992895316E-18
      1.08977190625000E-07
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00  -8.50502244333089E-19   1.67933098684297E-22
      1.34415076618236E-08   1.34415076609733E-08  -7.79492816579861E-19  -2.55843237257510E-01  -2.55843237257510E-01
      0.00000000000000E+00   0.00000000000000E+00   9.94377788008881E-16   0.00000000000000E+00   9.94377788008881E-16
      3.66381419938666E-18  -2.55843100920476E-01  -2.51608314520986E-01   0.00000000000000E+00  -3.38697026074547E-18
     -9.86937512534926E-23  -1.34415086519640E-08  -1.34415086553511E-08  -2.88432138280680E-18
      1.10977190625000E-07
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00  -2.13805633061588E-18   1.67932553439760E-22
      1.34414145135127E-08   1.34414145113748E-08  -7.79493609870028E-19  -2.55842830206622E-01  -2.55842830206622E-01
      0.00000000000000E+00   0.00000000000000E+00   1.65005600660676E-15   0.00000000000000E+00   1.65005600660676E-15
      3.66381749949867E-18  -2.55843398561167E-01  -2.51608641302558E-01   0.00000000000000E+00  -5.63786908827583E-18
     -9.86938085613943E-23  -1.34414161557928E-08  -1.34414161614308E-08  -2.88432388962864E-18
      1.12977190625000E-07
      0.00000000000000E+00  -1.34412936008471E-11   0.00000000000000E+00  -1.71654248405986E-18   1.67932054743911E-22
      1.34413042082476E-08   1.34413042065313E-08  -7.79494590120094E-19  -2.55842316302387E-01  -2.55842316302387E-01
      0.00000000000000E+00   0.00000000000000E+00   2.24032652860244E-15   0.00000000000000E+00   2.24032652860244E-15
      3.66382198015173E-18  -2.55843903661082E-01  -2.51609180969505E-01   0.00000000000000E+00  -9.64745282310718E-18
     -9.86938935430910E-23  -1.34413064372102E-08  -1.34413064468578E-08  -2.88432739003164E-18
      1.14977190625000E-07
      0.00000000000000E+00  -1.34412017561099E-11   0.00000000000000E+00  -2.58928549604626E-18   1.67931794474960E-22
      1.34411998823192E-08   1.34411998797301E-08  -7.79495575994855E-19  -2.55841784394478E-01  -2.55841784394478E-01
      0.00000000000000E+00   0.00000000000000E+00   2.53080377255980E-15   0.00000000000000E+00   2.53080377255980E-15
      3.66382704175927E-18  -2.55844600957258E-01  -2.51609911043367E-01   0.00000000000000E+00  -1.12006634695236E-17
     -9.86939985426239E-23  -1.34412023993331E-08  -1.34412024105338E-08  -2.88433146576442E-18
      1.16977190625000E-07
      0.00000000000000E+00  -1.34411099113727E-11   0.00000000000000E+00  -1.46459323036170E-18   1.67932023424407E-22
      1.34411390354347E-08   1.34411390339703E-08  -7.79496256807974E-19  -2.55841391577676E-01  -2.55841391577676E-01
      0.00000000000000E+00   0.00000000000000E+00   2.21791111762841E-15   0.00000000000000E+00   2.21791111762841E-15
      3.66383147758151E-18  -2.55845403113477E-01  -2.51610732468859E-01   0.00000000000000E+00  -1.21124599600454E-17
     -9.86941041333249E-23  -1.34411412397688E-08  -1.34411412518814E-08  -2.88433522077354E-18
      1.18977190625000E-07
      0.00000000000000E+00  -1.34411099113727E-11   0.00000000000000E+00   1.91856934365947E-18   1.67933012656416E-22
      1.34411716702843E-08   1.34411716722031E-08  -7.79496200692550E-19  -2.55841361058155E-01  -2.55841361058155E-01
      0.00000000000000E+00   0.00000000000000E+00   9.77090105335996E-16   0.00000000000000E+00   9.77090105335996E-16
      3.66383343176172E-18  -2.55846127895533E-01  -2.51611447360093E-01   0.00000000000000E+00  -1.07527866046531E-17
     -9.86941770317032E-23  -1.34411726385403E-08  -1.34411726492932E-08  -2.88433723106917E-18
      1.20977190625000E-07
      0.00000000000000E+00  -1.34413854455843E-11   0.00000000000000E+00   1.68976193698497E-17   1.67934981284816E-22
      1.34413531285055E-08   1.34413531454033E-08  -7.79494907172905E-19  -2.55841957430235E-01  -2.55841957430235E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.44839449806448E-15   0.00000000000000E+00  -1.44839449806448E-15
      3.66383053497272E-18  -2.55846489574601E-01  -2.51611752633072E-01   0.00000000000000E+00  -1.48881739679143E-17
     -9.86941709776268E-23  -1.34413516821205E-08  -1.34413516970088E-08  -2.88433562779982E-18
      1.22977190625000E-07
      0.00000000000000E+00  -1.34417528245332E-11   0.00000000000000E+00   1.60703436487628E-17   1.67937989875028E-22
      1.34417301947024E-08   1.34417302107729E-08  -7.79491918704646E-19  -2.55843431309320E-01  -2.55843431309320E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.11773830383469E-15   0.00000000000000E+00  -5.11773830383469E-15
      3.66382029949612E-18  -2.55846117296341E-01  -2.51611262712019E-01   0.00000000000000E+00   3.72906585754036E-18
     -9.86940323683967E-23  -1.34417250967636E-08  -1.34417250930346E-08  -2.88432838079147E-18
      1.24977190625000E-07
      0.00000000000000E+00  -1.34423038929564E-11   0.00000000000000E+00   6.76088465502243E-17   1.67941809907115E-22
      1.34423201152026E-08   1.34423201828116E-08  -7.79486996740857E-19  -2.55845929588755E-01  -2.55845929588755E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.73488463825958E-15   0.00000000000000E+00  -9.73488463825958E-15
      3.66380082972684E-18  -2.55844613598466E-01  -2.51609574607593E-01   0.00000000000000E+00  -2.42448435219997E-17
     -9.86937121942028E-23  -1.34423104236821E-08  -1.34423104479270E-08  -2.88431383298598E-18
      1.26977190625000E-07
      0.00000000000000E+00  -1.34430386508541E-11   0.00000000000000E+00   2.69888487534874E-17   1.67945792514144E-22
      1.34430844047015E-08   1.34430844316905E-08  -7.79480352095581E-19  -2.55849375511753E-01  -2.55849375511753E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.44931353634066E-14   0.00000000000000E+00  -1.44931353634066E-14
      3.66377184345611E-18  -2.55841662403542E-01  -2.51606384113384E-01   0.00000000000000E+00   4.35838503006203E-17
     -9.86931849170086E-23  -1.34430699821389E-08  -1.34430699385552E-08  -2.88429149136053E-18
      1.28977190625000E-07
      0.00000000000000E+00  -1.34439570982261E-11   0.00000000000000E+00   6.05163204284999E-17   1.67948781620537E-22
      1.34439017384818E-08   1.34439017989983E-08  -7.79472893502998E-19  -2.55853335972784E-01  -2.55853335972783E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.79730233472081E-14   0.00000000000000E+00  -1.79730233472081E-14
      3.66373589740942E-18  -2.55837187387546E-01  -2.51601652682667E-01   0.00000000000000E+00   3.20533500835396E-17
     -9.86924731212811E-23  -1.34438838580282E-08  -1.34438838259750E-08  -2.88426300390642E-18
      1.30977190625000E-07
      0.00000000000000E+00  -1.34445081666494E-11   0.00000000000000E+00   1.70978868660349E-17   1.67949123977276E-22
      1.34445486295184E-08   1.34445486466165E-08  -7.79466428566357E-19  -2.55856909048216E-01  -2.55856909048216E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.81652058027533E-14   0.00000000000000E+00  -1.81652058027533E-14
      3.66369956699781E-18  -2.55831544755398E-01  -2.51595806299532E-01   0.00000000000000E+00   8.64925933557582E-17
     -9.86916741688730E-23  -1.34445305679032E-08  -1.34445304814107E-08  -2.88423313843145E-18
      1.32977190625000E-07
      0.00000000000000E+00  -1.34446918561238E-11   0.00000000000000E+00   4.70760111076297E-17   1.67944849631649E-22
      1.34446986454751E-08   1.34446986925513E-08  -7.79463719260522E-19  -2.55858682043789E-01  -2.55858682043789E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.26953587783563E-14   0.00000000000000E+00  -1.26953587783563E-14
      3.66367417628026E-18  -2.55825714093459E-01  -2.51589926648422E-01   0.00000000000000E+00   3.96604991482757E-17
     -9.86909817264102E-23  -1.34446860368529E-08  -1.34446859971925E-08  -2.88421045701973E-18
      1.34977190625000E-07
      0.00000000000000E+00  -1.34439570982261E-11   0.00000000000000E+00   9.46789771619128E-17   1.67934075276442E-22
      1.34439543423818E-08   1.34439544370609E-08  -7.79468272687117E-19  -2.55856822600114E-01  -2.55856822600114E-01
      0.00000000000000E+00   0.00000000000000E+00   6.74778523847938E-16   0.00000000000000E+00   6.74778523847938E-16
      3.66367552583730E-18  -2.55821424152115E-01  -2.51585866994156E-01   0.00000000000000E+00  -6.40949625429693E-17
     -9.86906917638654E-23  -1.34439550477444E-08  -1.34439551118394E-08  -2.88420725315019E-18
      1.36977190625000E-07
      0.00000000000000E+00  -1.34419365140076E-11   0.00000000000000E+00   1.07604032583037E-15   1.67915668662806E-22
      1.34419241089620E-08   1.34419251850025E-08  -7.79483743855970E-19  -2.55849369258520E-01  -2.55849369258521E-01
      0.00000000000000E+00   0.00000000000000E+00   2.32344096179093E-14   0.00000000000000E+00   2.32344096179093E-14
      3.66372199465654E-18  -2.55821128149489E-01  -2.51586203530488E-01   0.00000000000000E+00  -1.15486550186572E-15
     -9.86911799469373E-23  -1.34419472645465E-08  -1.34419484194121E-08  -2.88423825080057E-18
      1.38977190625000E-07
      0.00000000000000E+00  -1.34383545692565E-11   0.00000000000000E+00   3.58979115653388E-16   1.67890125596526E-22
      1.34383522368237E-08   1.34383525958030E-08  -7.79512880012354E-19  -2.55834763441652E-01  -2.55834763441652E-01
      0.00000000000000E+00   0.00000000000000E+00   5.42511251584627E-14   0.00000000000000E+00   5.42511251584627E-14
      3.66383049690686E-18  -2.55827728531734E-01  -2.51593919499903E-01   0.00000000000000E+00  -5.97103644611209E-16
     -9.86928379093846E-23  -1.34384062498244E-08  -1.34384068469281E-08  -2.88431761689450E-18
      1.40977190625000E-07
      0.00000000000000E+00  -1.34333031087101E-11   0.00000000000000E+00   6.85531272538090E-17   1.67860574502531E-22
      1.34332938822974E-08   1.34332939508507E-08  -7.79555994354617E-19  -2.55812635463911E-01  -2.55812635463911E-01
      0.00000000000000E+00   0.00000000000000E+00   8.97707746916971E-14   0.00000000000000E+00   8.97707746916971E-14
      3.66401003845624E-18  -2.55843969178928E-01  -2.51611742649380E-01   0.00000000000000E+00  -4.95385688522385E-16
     -9.86959588686364E-23  -1.34333832262396E-08  -1.34333837216254E-08  -2.88445404410162E-18
      1.42977190625000E-07
      0.00000000000000E+00  -1.34273332007916E-11   0.00000000000000E+00   1.50365166510795E-16   1.67833632630920E-22
      1.34273184598972E-08   1.34273186102625E-08  -7.79609159849284E-19  -2.55784755816319E-01  -2.55784755816319E-01
      0.00000000000000E+00   0.00000000000000E+00   1.21626425900702E-13   0.00000000000000E+00   1.21626425900702E-13
      3.66425329130804E-18  -2.55871446090512E-01  -2.51641092153151E-01   0.00000000000000E+00  -7.79811951403532E-16
     -9.87005768724536E-23  -1.34274394568764E-08  -1.34274402366884E-08  -2.88464413145876E-18
      1.44977190625000E-07
      0.00000000000000E+00  -1.34217306718219E-11   0.00000000000000E+00  -7.03559864479201E-17   1.67819728779162E-22
      1.34216876854812E-08   1.34216876151254E-08  -7.79662474356736E-19  -2.55755978410953E-01  -2.55755978410953E-01
      0.00000000000000E+00   0.00000000000000E+00   1.37065816761801E-13   0.00000000000000E+00   1.37065816761801E-13
      3.66452742294157E-18  -2.55909292449378E-01  -2.51680707694597E-01   0.00000000000000E+00  -6.81441988909042E-16
     -9.87062687066212E-23  -1.34218239995001E-08  -1.34218246809422E-08  -2.88486494858483E-18
      1.46977190625000E-07
      0.00000000000000E+00  -1.34184242612825E-11   0.00000000000000E+00  -5.37865359052181E-17   1.67832497903172E-22
      1.34184390850178E-08   1.34184390312314E-08  -7.79699020418881E-19  -2.55734859601045E-01  -2.55734859601045E-01
      0.00000000000000E+00   0.00000000000000E+00   1.19618232110384E-13   0.00000000000000E+00   1.19618232110384E-13
      3.66476665940579E-18  -2.55952726118203E-01  -2.51725170378962E-01   0.00000000000000E+00  -6.79361142980016E-16
     -9.87119753309248E-23  -1.34185579701022E-08  -1.34185586494635E-08  -2.88506763898691E-18
      1.48977190625000E-07
      0.00000000000000E+00  -1.34202611560266E-11   0.00000000000000E+00   5.17171671706236E-16   1.67886642647246E-22
      1.34202824201044E-08   1.34202829372763E-08  -7.79695338211152E-19  -2.55733527600033E-01  -2.55733527600033E-01
      0.00000000000000E+00   0.00000000000000E+00   5.17272749453154E-14   0.00000000000000E+00   5.17272749453154E-14
      3.66487011395568E-18  -2.55991823146267E-01  -2.51763708045201E-01   0.00000000000000E+00  -9.96263083634003E-16
     -9.87158852788593E-23  -1.34203336682880E-08  -1.34203346645512E-08  -2.88517477574453E-18
      1.50977190625000E-07
      0.00000000000000E+00  -1.34301803876450E-11   0.00000000000000E+00   2.78953790413566E-16   1.67993966025278E-22
      1.34302111548329E-08   1.34302114337868E-08  -7.79624338311677E-19  -2.55766311321827E-01  -2.55766311321827E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.03880954289104E-14   0.00000000000000E+00  -8.03880954289104E-14
      3.66470933776482E-18  -2.56011062731914E-01  -2.51779861106256E-01   0.00000000000000E+00  -1.60119735669850E-16
     -9.87154947876868E-23  -1.34301308855716E-08  -1.34301310456914E-08  -2.88508499945314E-18
      1.51477190625000E-07
      0.00000000000000E+00  -1.34332112639729E-11   0.00000000000000E+00   3.01251291135982E-16   1.68024284833294E-22
      1.34332468756934E-08   1.34332471769449E-08  -7.79601949074291E-19  -2.55776869321490E-01  -2.55776869321490E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17622465808946E-13   0.00000000000000E+00  -1.17622465808946E-13
      3.66465052653191E-18  -2.56014366558035E-01  -2.51782220228026E-01   0.00000000000000E+00  -1.23880947808744E-17
     -9.87150792294007E-23  -1.34331295420909E-08  -1.34331295544791E-08  -2.88504857745762E-18
      1.52152190625000E-07
      0.00000000000000E+00  -1.34384464139937E-11   0.00000000000000E+00   3.83997665755340E-16   1.68071914458063E-22
      1.34384693705865E-08   1.34384697545844E-08  -7.79562186434976E-19  -2.55796008182982E-01  -2.55796008182981E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.75942094415828E-13   0.00000000000000E+00  -1.75942094415828E-13
      3.66453176561818E-18  -2.56015357891334E-01  -2.51781584532628E-01   0.00000000000000E+00   1.78262737440980E-16
     -9.87138485419694E-23  -1.34382939907526E-08  -1.34382938124900E-08  -2.88496957918321E-18
      1.53063440625000E-07
      0.00000000000000E+00  -1.34478145771889E-11   0.00000000000000E+00   1.00701056471551E-15   1.68148885023509E-22
      1.34478395656226E-08   1.34478405726334E-08  -7.79488529967540E-19  -2.55832163406362E-01  -2.55832163406362E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.69853922233847E-13   0.00000000000000E+00  -2.69853922233847E-13
      3.66428586123155E-18  -2.56008367180600E-01  -2.51771671227124E-01   0.00000000000000E+00   3.77213368399113E-18
     -9.87106584433993E-23  -1.34475707224832E-08  -1.34475707187111E-08  -2.88479733126401E-18
      1.54293628125000E-07
      0.00000000000000E+00  -1.34652650772583E-11   0.00000000000000E+00   2.82438835491706E-15   1.68275173897535E-22
      1.34652409457983E-08   1.34652437701868E-08  -7.79347268265403E-19  -2.55902832520294E-01  -2.55902832520293E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.23258015331583E-13   0.00000000000000E+00  -4.23258015331583E-13
      3.66376517451181E-18  -2.55978241005200E-01  -2.51736110882823E-01   0.00000000000000E+00  -1.06744314895556E-15
     -9.87028160845729E-23  -1.34648194447282E-08  -1.34648205121715E-08  -2.88441790624641E-18
      1.55954381250000E-07
      0.00000000000000E+00  -1.34976862694925E-11   0.00000000000000E+00   1.42990499947101E-15   1.68475248841948E-22
      1.34976656245758E-08   1.34976670544810E-08  -7.79074819081894E-19  -2.56041832377945E-01  -2.56041832377945E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.64892732970611E-13   0.00000000000000E+00  -6.64892732970611E-13
      3.66266095182774E-18  -2.55886074832851E-01  -2.51633805070635E-01   0.00000000000000E+00   1.62271234122187E-15
     -9.86841763323394E-23  -1.34970037844603E-08  -1.34970021617480E-08  -2.88358613274585E-18
      1.57954381250000E-07
      0.00000000000000E+00  -1.35463639802125E-11   0.00000000000000E+00   1.20907034928346E-15   1.68712224748686E-22
      1.35463445812245E-08   1.35463457902950E-08  -7.78649496694628E-19  -2.56263488965769E-01  -2.56263488965768E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.48449030163304E-13   0.00000000000000E+00  -9.48449030163304E-13
      3.66076405376742E-18  -2.55683158240174E-01  -2.51415640926128E-01   0.00000000000000E+00   3.50085593580220E-15
     -9.86489871975781E-23  -1.35454008421207E-08  -1.35453973412649E-08  -2.88211455707279E-18
      1.59954381250000E-07
      0.00000000000000E+00  -1.35958682935674E-11   0.00000000000000E+00   1.23131359138449E-15   1.68866902619185E-22
      1.35959016276711E-08   1.35959028589848E-08  -7.78194084999652E-19  -2.56506933653622E-01  -2.56506933653621E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12913077889909E-12   0.00000000000000E+00  -1.12913077889909E-12
      3.65850579220962E-18  -2.55388273866185E-01  -2.51105199908841E-01   0.00000000000000E+00   4.77918552973678E-15
     -9.86032885157895E-23  -1.35947785073914E-08  -1.35947737282059E-08  -2.88031170720997E-18
      1.61954381250000E-07
      0.00000000000000E+00  -1.36310448279179E-11   0.00000000000000E+00   1.73863224090601E-15   1.68833013113068E-22
      1.36310419682628E-08   1.36310437068952E-08  -7.77832247087468E-19  -2.56710050090672E-01  -2.56710050090671E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07703876916792E-12   0.00000000000000E+00  -1.07703876916792E-12
      3.65635171467128E-18  -2.55030888597138E-01  -2.50736726778352E-01   0.00000000000000E+00   4.55210973169583E-15
     -9.85542552231497E-23  -1.36299712202356E-08  -1.36299666681260E-08  -2.87851946758381E-18
      1.63954381250000E-07
      0.00000000000000E+00  -1.36302182252830E-11   0.00000000000000E+00   1.88552271533279E-14   1.68490256003591E-22
      1.36302276894749E-08   1.36302465447022E-08  -7.77744953764361E-19  -2.56779838291764E-01  -2.56779838291763E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.44550703427629E-13   0.00000000000000E+00  -6.44550703427629E-13
      3.65506261326443E-18  -2.54681497670567E-01  -2.50387456033780E-01   0.00000000000000E+00  -1.42741761147573E-14
     -9.85152390263231E-23  -1.36295877198226E-08  -1.36296019939988E-08  -2.87731765950006E-18
      1.65954381250000E-07
      0.00000000000000E+00  -1.35683148724051E-11   0.00000000000000E+00   3.00001778546788E-14   1.67730433719761E-22
      1.35683336632185E-08   1.35683636633965E-08  -7.78154500697280E-19  -2.56599675106478E-01  -2.56599675106479E-01
      0.00000000000000E+00   0.00000000000000E+00   2.99718345189628E-13   0.00000000000000E+00   2.99718345189628E-13
      3.65566204995480E-18  -2.54457805921266E-01  -2.50182967085015E-01   0.00000000000000E+00  -2.95337020074932E-14
     -9.85058131984091E-23  -1.35686338480396E-08  -1.35686633817417E-08  -2.87750754925752E-18
      1.67954381250000E-07
      0.00000000000000E+00  -1.34225572744568E-11   0.00000000000000E+00   2.99208837417230E-13   1.66497602484459E-22
      1.34224978395245E-08   1.34227970483620E-08  -7.79283368618238E-19  -2.56049441183231E-01  -2.56049441183232E-01
      0.00000000000000E+00   0.00000000000000E+00   1.81662785028998E-12   0.00000000000000E+00   1.81662785028998E-12
      3.65929530565539E-18  -2.54519500245412E-01  -2.50290130449162E-01   0.00000000000000E+00  -3.08279434913575E-13
     -9.85498723131543E-23  -1.34243053967773E-08  -1.34246136762123E-08  -2.88001193703715E-18
      1.69954381250000E-07
      0.00000000000000E+00  -1.31817403734987E-11   0.00000000000000E+00   1.02360407897875E-13   1.64837961571240E-22
      1.31817148117145E-08   1.31818171721226E-08  -7.81285525365579E-19  -2.55040444065708E-01  -2.55040444065712E-01
      0.00000000000000E+00   0.00000000000000E+00   3.82640268181418E-12   0.00000000000000E+00   3.82640268181418E-12
      3.66694811101901E-18  -2.55044592308144E-01  -2.50890450877519E-01   0.00000000000000E+00  -1.20341787874076E-13
     -9.86714759766360E-23  -1.31855232330164E-08  -1.31856435748044E-08  -2.88566258565344E-18
      1.71954381250000E-07
      0.00000000000000E+00  -1.28576202958933E-11   0.00000000000000E+00   7.54488601078162E-13   1.62961635558515E-22
      1.28575916501926E-08   1.28583461387938E-08  -7.84140954587555E-19  -2.53569164323212E-01  -2.53569164323218E-01
      0.00000000000000E+00   0.00000000000000E+00   6.02933405091882E-12   0.00000000000000E+00   6.02933405091882E-12
      3.67900677912085E-18  -2.56185450662429E-01  -2.52132733282703E-01   0.00000000000000E+00  -7.93091236286390E-13
     -9.88840313146897E-23  -1.28635823816083E-08  -1.28643754728447E-08  -2.89486582453330E-18
      1.73954381250000E-07
      0.00000000000000E+00  -1.24969460128793E-11   0.00000000000000E+00   4.60533822733642E-14   1.61312916568980E-22
      1.24969926824677E-08   1.24970387358501E-08  -7.87536586681896E-19  -2.51780616351280E-01  -2.51780616351288E-01
      0.00000000000000E+00   0.00000000000000E+00   7.84779425944660E-12   0.00000000000000E+00   7.84779425944660E-12
      3.69470236763975E-18  -2.58001247518793E-01  -2.54061568781609E-01   0.00000000000000E+00  -8.85151599985951E-14
     -9.91866418712089E-23  -1.25047980149495E-08  -1.25048865301096E-08  -2.90716578095785E-18
      1.75954381250000E-07
      0.00000000000000E+00  -1.21855005090086E-11   0.00000000000000E+00  -7.74505008514774E-15   1.60601649350997E-22
      1.21855465479737E-08   1.21855388029237E-08  -7.90747530560772E-19  -2.50032055078161E-01  -2.50032055078170E-01
      0.00000000000000E+00   0.00000000000000E+00   8.42000867040894E-12   0.00000000000000E+00   8.42000867040894E-12
      3.71154238498056E-18  -2.60384980995633E-01  -2.56543246828498E-01   0.00000000000000E+00  -3.96215836974696E-14
     -9.95397013618675E-23  -1.21939191900104E-08  -1.21939588115942E-08  -2.92079485441979E-18
      1.77954381250000E-07
      0.00000000000000E+00  -1.20490192295182E-11   0.00000000000000E+00   1.71955415993853E-13   1.61787174575933E-22
      1.20490588870438E-08   1.20492308424600E-08  -7.92593637297291E-19  -2.48922611602399E-01  -2.48922611602405E-01
      0.00000000000000E+00   0.00000000000000E+00   6.69801907778451E-12   0.00000000000000E+00   6.69801907778451E-12
      3.72493842313613E-18  -2.62989089175044E-01  -2.59190899903529E-01   0.00000000000000E+00  -2.18220815620757E-13
     -9.98680512288940E-23  -1.20557106407221E-08  -1.20559288615378E-08  -2.93234478583884E-18
      1.79954381250000E-07
      0.00000000000000E+00  -1.22439137618726E-11   0.00000000000000E+00   4.87058711461959E-15   1.65869511833633E-22
      1.22439921558731E-08   1.22439970264604E-08  -7.91551357606547E-19  -2.49245925076145E-01  -2.49245925076146E-01
      0.00000000000000E+00   0.00000000000000E+00   1.68959587456108E-12   0.00000000000000E+00   1.68959587456108E-12
      3.72831761488525E-18  -2.65170666702629E-01  -2.61312640276893E-01   0.00000000000000E+00  -2.79319896163582E-14
     -1.00054653901279E-22  -1.22456586903452E-08  -1.22456866223349E-08  -2.93676625727871E-18
      1.81954381250000E-07
      0.00000000000000E+00  -1.29434951251823E-11   0.00000000000000E+00   1.73491098080625E-14   1.73436388381716E-22
      1.29434366544191E-08   1.29434540035291E-08  -7.86085704797121E-19  -2.51830283345533E-01  -2.51830283345526E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.17311506334306E-12   0.00000000000000E+00  -7.17311506334306E-12
      3.71397138475857E-18  -2.65964306944953E-01  -2.61888706193186E-01   0.00000000000000E+00   1.12757614030749E-15
     -9.99527524154260E-23  -1.29362820160418E-08  -1.29362808884658E-08  -2.92788567996144E-18
      1.83954381250000E-07
      0.00000000000000E+00  -1.43124409332605E-11   0.00000000000000E+00   3.38296889115288E-14   1.83963252198915E-22
      1.43123901213513E-08   1.43124239510404E-08  -7.75193289194384E-19  -2.57263332764351E-01  -2.57263332764331E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.95845199050945E-11   0.00000000000000E+00  -1.95845199050945E-11
      3.67480234494838E-18  -2.64102506636752E-01  -2.59599512893312E-01   0.00000000000000E+00   4.70943959084810E-14
     -9.94031195968621E-23  -1.42928865255311E-08  -1.42928394311353E-08  -2.89960905575399E-18
      1.85954381250000E-07
      0.00000000000000E+00  -1.64550868075749E-11   0.00000000000000E+00   5.30761650200789E-14   1.95241661917883E-22
      1.64549768149290E-08   1.64550298910942E-08  -7.58938791234586E-19  -2.65597614091954E-01  -2.65597614091920E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.40429565494536E-11   0.00000000000000E+00  -3.40429565494536E-11
      3.60671643184947E-18  -2.58137245134931E-01  -2.52963758654094E-01   0.00000000000000E+00   1.04405739188998E-13
     -9.82595324217292E-23  -1.64210913402839E-08  -1.64209869345448E-08  -2.84777764061489E-18
      1.87954381250000E-07
      0.00000000000000E+00  -1.93134787189476E-11   0.00000000000000E+00   7.09204404005490E-14   2.03545610113808E-22
      1.93133594001837E-08   1.93134303206243E-08  -7.38721853379293E-19  -2.76175623745910E-01  -2.76175623745862E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.78928445866238E-11   0.00000000000000E+00  -4.78928445866238E-11
      3.51093074267622E-18  -2.46755330961728E-01  -2.40685633474227E-01   0.00000000000000E+00   1.62748726036848E-13
     -9.64218148846489E-23  -1.92657002247637E-08  -1.92655374760377E-08  -2.77220888929693E-18
      1.89954381250000E-07
      0.00000000000000E+00  -2.25120635369369E-11   0.00000000000000E+00   7.94975806828208E-14   2.04695036014206E-22
      2.25119918893421E-08   2.25120713869230E-08  -7.17251989997908E-19  -2.87624391414014E-01  -2.87624391413956E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.77204717744048E-11   0.00000000000000E+00  -5.77204717744048E-11
      3.39548979912742E-18  -2.29391490637797E-01  -2.22317104939388E-01   0.00000000000000E+00   2.08017888409110E-13
     -9.39099801016343E-23  -2.24545589330369E-08  -2.24543509151486E-08  -2.67823780912951E-18
      1.91954381250000E-07
      0.00000000000000E+00  -2.51801531528155E-11   0.00000000000000E+00   7.51914809450773E-14   1.95423682782404E-22
      2.51801701053661E-08   2.51802452968473E-08  -6.98622757371617E-19  -2.97854854568902E-01  -2.97854854568843E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.93462385999403E-11   0.00000000000000E+00  -5.93462385999403E-11
      3.27679732192753E-18  -2.07177082801625E-01  -1.99262543520293E-01   0.00000000000000E+00   2.18209996395323E-13
     -9.10127671756400E-23  -2.51211172682436E-08  -2.51208990582473E-08  -2.57817456455592E-18
      1.93954381250000E-07
      0.00000000000000E+00  -2.59208809583942E-11   0.00000000000000E+00   1.83311662625616E-14   1.75524103030099E-22
      2.59208570514497E-08   2.59208753826161E-08  -6.88775769391901E-19  -3.03879884373292E-01  -3.03879884373245E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.68559063283080E-11   0.00000000000000E+00  -4.68559063283080E-11
      3.18308550927092E-18  -1.83933139641138E-01  -1.75781284631869E-01   0.00000000000000E+00   2.17417640226667E-13
     -8.84038225626658E-23  -2.58742368939279E-08  -2.58740194762878E-08  -2.49430973987901E-18
      1.95954381250000E-07
      0.00000000000000E+00  -2.33310430586164E-11   0.00000000000000E+00  -6.40938556692876E-14   1.49532791401596E-22
      2.33310983775906E-08   2.33310342837351E-08  -6.95585304577733E-19  -3.01752067793951E-01  -3.01752067793937E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.36733475284431E-11   0.00000000000000E+00  -1.36733475284431E-11
      3.15573881421403E-18  -1.66132536345730E-01  -1.58786165021368E-01   0.00000000000000E+00   1.78817366369443E-13
     -8.69380090971771E-23  -2.33175397535729E-08  -2.33173609362066E-08  -2.46015350963630E-18
      1.97954381250000E-07
      0.00000000000000E+00  -1.72552381581269E-11   0.00000000000000E+00   1.09321607524462E-13   1.20630680218234E-22
      1.72554300847762E-08   1.72555394063839E-08  -7.27205347737416E-19  -2.87235148386317E-01  -2.87235148386358E-01
      0.00000000000000E+00   0.00000000000000E+00   4.11542852922630E-11   0.00000000000000E+00   4.11542852922630E-11
      3.23804738479856E-18  -1.60424215994622E-01  -1.54974805793964E-01   0.00000000000000E+00  -1.72910488607017E-13
     -8.73217776359378E-23  -1.72965207811874E-08  -1.72966936916761E-08  -2.51084203706114E-18
      1.99954381250000E-07
      0.00000000000000E+00  -9.65875994369234E-12   0.00000000000000E+00  -1.88549595896325E-13   8.23265983337118E-23
      9.65896815438365E-09   9.65877960478784E-09  -7.89810526963169E-19  -2.56786378883116E-01  -2.56786378883224E-01
      0.00000000000000E+00   0.00000000000000E+00   1.08397878183387E-10   0.00000000000000E+00   1.08397878183387E-10
      3.45484314116533E-18  -1.69504823663609E-01  -1.66427595755322E-01   0.00000000000000E+00  -1.12256293548557E-13
     -9.02047018473481E-23  -9.76706522667758E-09  -9.76717748297122E-09  -2.66503261420216E-18
      2.01954381250000E-07
      0.00000000000000E+00  -3.63962324605987E-12   0.00000000000000E+00  -1.50476123273720E-13   2.83111980214091E-23
      3.63974987065955E-09   3.63959939453630E-09  -8.87110009348454E-19  -2.08450235120018E-01  -2.08450235120188E-01
      0.00000000000000E+00   0.00000000000000E+00   1.69387360948753E-10   0.00000000000000E+00   1.69387360948753E-10
      3.79361786306284E-18  -1.90001939021705E-01  -1.88801900202212E-01   0.00000000000000E+00  -4.80720078178361E-13
     -9.60252280402985E-23  -3.80850603540678E-09  -3.80898675548505E-09  -2.90650785371438E-18
      2.03954381250000E-07
      0.00000000000000E+00  -7.95283579479974E-13   0.00000000000000E+00  -7.35493097034098E-14  -2.27641435741572E-23
      7.95410972567302E-10   7.95337423257576E-10  -1.02003661869746E-18  -1.43294316079933E-01  -1.43294316080139E-01
      0.00000000000000E+00   0.00000000000000E+00   2.06040653688198E-10   0.00000000000000E+00   2.06040653688198E-10
      4.20569917043923E-18  -2.15532133272291E-01  -2.15216649216975E-01   0.00000000000000E+00  -1.00724373820653E-12
     -1.04237319741370E-22  -1.00037083320746E-09  -1.00137807694577E-09  -3.18566255174177E-18
      2.05954381250000E-07
      0.00000000000000E+00  -7.71495792543225E-14   0.00000000000000E+00  -2.26761433008753E-14  -4.20064732612093E-23
      7.71965615390342E-11   7.71738853956913E-11  -1.16421057574260E-18  -7.34546545083062E-02  -7.34546545085103E-02
      0.00000000000000E+00   0.00000000000000E+00   2.04162136348547E-10   0.00000000000000E+00   2.04162136348547E-10
      4.61402344313633E-18  -2.41926337483391E-01  -2.41837702988031E-01   0.00000000000000E+00  -1.43281258523459E-12
     -1.12432854308261E-22  -2.79903209158890E-10  -2.81336021744237E-10  -3.44981286739373E-18
      2.07954381250000E-07
      0.00000000000000E+00  -1.11132132021107E-14   0.00000000000000E+00  -4.52957489060060E-15  -4.47449299973523E-23
      1.11197567790531E-11   1.11152272041178E-11  -1.24984091894763E-18  -3.25121030023280E-02  -3.25121030024669E-02
      0.00000000000000E+00   0.00000000000000E+00   1.38983746576347E-10   0.00000000000000E+00   1.38983746576347E-10
      4.89199093628902E-18  -2.68028893333178E-01  -2.67981605176326E-01   0.00000000000000E+00  -1.12826356202902E-12
     -1.18283187576781E-22  -1.48970710218319E-10  -1.50098973780466E-10  -3.64215001734139E-18
      2.09954381250000E-07
      0.00000000000000E+00  -2.88392474831634E-14   0.00000000000000E+00  -2.88594431329330E-16  -4.44469759288450E-23
      2.87992348598860E-11   2.87989462654103E-11  -1.28465246272453E-18  -1.69608181884769E-02  -1.69608181885599E-02
      0.00000000000000E+00   0.00000000000000E+00   8.29413324629471E-11   0.00000000000000E+00   8.29413324629471E-11
      5.05787360121492E-18  -2.93672253909879E-01  -2.93637051043433E-01   0.00000000000000E+00  -6.85802002003866E-13
     -1.21633792338360E-22  -1.11054476726232E-10  -1.11740278728358E-10  -3.77322113849039E-18
      2.11954381250000E-07
      0.00000000000000E+00  -4.72081949246687E-14   0.00000000000000E+00   5.50198899522135E-16  -4.25844191736531E-23
      4.72131089328560E-11   4.72136591317129E-11  -1.29702073459693E-18  -1.17049511780277E-02  -1.17049511780827E-02
      0.00000000000000E+00   0.00000000000000E+00   5.50363642721107E-11   0.00000000000000E+00   5.50363642721107E-11
      5.16794632975914E-18  -3.18809643326794E-01  -3.18777430716089E-01   0.00000000000000E+00  -5.17636981071174E-13
     -1.24087526008320E-22  -1.01732386422628E-10  -1.02250023403823E-10  -3.87092559516221E-18
      2.13954381250000E-07
      0.00000000000000E+00  -6.18115081406655E-14   0.00000000000000E+00   6.09318478687255E-16  -3.88374953919823E-23
      6.18247847285062E-11   6.18253940469461E-11  -1.30059016191259E-18  -9.80801287993937E-03  -9.80801287998076E-03
      0.00000000000000E+00   0.00000000000000E+00   4.13835114999472E-11   0.00000000000000E+00   4.13835114999472E-11
      5.25071335275903E-18  -3.43419080153010E-01  -3.43386565803246E-01   0.00000000000000E+00  -4.93703324973742E-13
     -1.26378383742065E-22  -1.02715202221793E-10  -1.03208905546893E-10  -3.95012319084644E-18
      2.15954381250000E-07
      0.00000000000000E+00  -7.39350134520590E-14   0.00000000000000E+00   5.22174939513970E-16  -3.26588824258330E-23
      7.39315092923229E-11   7.39320314672298E-11  -1.30060286121011E-18  -8.98808795456595E-03  -8.98808795459972E-03
      0.00000000000000E+00   0.00000000000000E+00   3.37694104085182E-11   0.00000000000000E+00   3.37694104085182E-11
      5.31825217357607E-18  -3.67498241661392E-01  -3.67464312337245E-01   0.00000000000000E+00  -5.13174999924243E-13
     -1.28710563691026E-22  -1.07188266875695E-10  -1.07701441875748E-10  -4.01764931236596E-18
      2.17954381250000E-07
      0.00000000000000E+00  -8.44971582309246E-14   0.00000000000000E+00   4.35674738457403E-16  -2.35305423193041E-23
      8.44847660618366E-11   8.44852017365515E-11  -1.29908939333125E-18  -8.56744392104531E-03  -8.56744392107426E-03
      0.00000000000000E+00   0.00000000000000E+00   2.89510693325181E-11   0.00000000000000E+00   2.89510693325181E-11
      5.37615431224110E-18  -3.91130683374007E-01  -3.91094947741975E-01   0.00000000000000E+00  -5.45223958421738E-13
     -1.31134308205459E-22  -1.12891047110517E-10  -1.13436271069070E-10  -4.07706491890986E-18
      2.19954381250000E-07
      0.00000000000000E+00  -9.40490109005074E-14   0.00000000000000E+00   3.74770730993041E-16  -1.11326576543742E-23
      9.40702409922261E-11   9.40706157629459E-11  -1.29690105929964E-18  -8.34363865341993E-03  -8.34363865344552E-03
      0.00000000000000E+00   0.00000000000000E+00   2.55887016779758E-11   0.00000000000000E+00   2.55887016779758E-11
      5.42733171559705E-18  -4.14373364610717E-01  -4.14335668913401E-01   0.00000000000000E+00  -5.81623985144187E-13
     -1.33658257318655E-22  -1.19077693455644E-10  -1.19659317440922E-10  -4.13043065629742E-18
      2.21954381250000E-07
      0.00000000000000E+00  -1.03049795146845E-13   0.00000000000000E+00   3.37174616061169E-16   4.40736398011096E-24
      1.03078549205382E-10   1.03078886380003E-10  -1.29440805787705E-18  -8.25700584764392E-03  -8.25700584766692E-03
      0.00000000000000E+00   0.00000000000000E+00   2.29983962857552E-11   0.00000000000000E+00   2.29983962857552E-11
      5.47332850816857E-18  -4.37178775645395E-01  -4.37139058534098E-01   0.00000000000000E+00  -6.17723547712585E-13
     -1.36267605797286E-22  -1.25459559117910E-10  -1.26077282665758E-10  -4.17892045029152E-18
      2.23954381250000E-07
      0.00000000000000E+00  -1.11866889918768E-13   0.00000000000000E+00   3.20912901148985E-16   2.17661512741712E-23
      1.11881651408562E-10   1.11881972321485E-10  -1.29172168395486E-18  -8.30984623553795E-03  -8.30984623555880E-03
      0.00000000000000E+00   0.00000000000000E+00   2.08533859856988E-11   0.00000000000000E+00   2.08533859856988E-11
      5.51503528013997E-18  -4.59527405574388E-01  -4.59485591470580E-01   0.00000000000000E+00  -6.53572251428867E-13
     -1.38945508990041E-22  -1.32081786055615E-10  -1.32735358307182E-10  -4.22331359618510E-18
      2.25954381250000E-07
      0.00000000000000E+00  -1.21051363639520E-13   0.00000000000000E+00   3.34404712384696E-16   3.99781679935538E-23
      1.21056009498658E-10   1.21056343903410E-10  -1.28871805432787E-18  -8.57853438973898E-03  -8.57853438975786E-03
      0.00000000000000E+00   0.00000000000000E+00   1.88843552913777E-11   0.00000000000000E+00   1.88843552913777E-11
      5.55280399072272E-18  -4.81419598670505E-01  -4.81375515246713E-01   0.00000000000000E+00  -6.87012924325567E-13
     -1.41665065868910E-22  -1.39253686270322E-10  -1.39940699194789E-10  -4.26408593639485E-18
      2.27954381250000E-07
      0.00000000000000E+00  -1.32164576841631E-13   0.00000000000000E+00   4.15433124824478E-16   5.88966200615737E-23
      1.32179412985725E-10   1.32179828418908E-10  -1.28475358814462E-18  -9.35836592719698E-03  -9.35836592721358E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66029981032159E-11   0.00000000000000E+00   1.66029981032159E-11
      5.58600998692915E-18  -5.02859972144255E-01  -5.02813103879326E-01   0.00000000000000E+00  -7.08018707878480E-13
     -1.44362700816628E-22  -1.48074807814101E-10  -1.48782826522123E-10  -4.30125639878453E-18
      2.29954381250000E-07
      0.00000000000000E+00  -1.52370419027287E-13   0.00000000000000E+00   7.97915001840122E-16   8.14795058498819E-23
      1.52412898221454E-10   1.52413696136537E-10  -1.27688247353393E-18  -1.19823959471897E-02  -1.19823959472017E-02
      0.00000000000000E+00   0.00000000000000E+00   1.20530950364837E-11   0.00000000000000E+00   1.20530950364837E-11
      5.61011617700212E-18  -5.23844743428861E-01  -5.23792935235357E-01   0.00000000000000E+00  -6.68392506557359E-13
     -1.46810510518660E-22  -1.63798398666317E-10  -1.64466791173021E-10  -4.33323370346819E-18
      2.31954381250000E-07
      0.00000000000000E+00  -2.27591258800251E-13   0.00000000000000E+00   2.87888283936575E-15   1.28958207601458E-22
      2.27613034152827E-10   2.27615913035796E-10  -1.25000364658929E-18  -2.31812642156389E-02  -2.31812642156339E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.94060614676783E-12   0.00000000000000E+00  -4.94060614676783E-12
      5.60023496470858E-18  -5.44301398490208E-01  -5.44231255298541E-01   0.00000000000000E+00  -3.19129099909662E-13
     -1.47945115487260E-22  -2.22356177788971E-10  -2.22675306889029E-10  -4.35023131811929E-18
      2.33954381250000E-07
      0.00000000000000E+00  -4.85307591404571E-13   0.00000000000000E+00   8.42088572571521E-15   2.25087844629844E-22
      4.85336644736658E-10   4.85345065622609E-10  -1.18759655902416E-18  -4.91930425009877E-02  -4.91930425009512E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.64291991641236E-11   0.00000000000000E+00  -3.64291991641236E-11
      5.52737656638034E-18  -5.63915445583585E-01  -5.63774036654247E-01   0.00000000000000E+00   3.07916438553720E-13
     -1.46843617574245E-22  -4.49223782896892E-10  -4.48915866458485E-10  -4.33978000735617E-18
      2.35954381250000E-07
      0.00000000000000E+00  -1.03554941201486E-12   0.00000000000000E+00   1.55275200104039E-14   3.06539437993344E-22
      1.03550253032796E-09   1.03551805784828E-09  -1.11369005681958E-18  -7.87127571467323E-02  -7.87127571466807E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.16677678750360E-11   0.00000000000000E+00  -5.16677678750360E-11
      5.42404103063026E-18  -5.82105869684108E-01  -5.81795953534925E-01   0.00000000000000E+00   4.03794098776974E-13
     -1.45352450986341E-22  -9.84254084071872E-10  -9.83850289973240E-10  -4.31035097381068E-18
      2.37954381250000E-07
      0.00000000000000E+00  -2.08505922408527E-12   0.00000000000000E+00   2.75475076263851E-14   3.57939815863461E-22
      2.08506525055229E-09   2.08509279806027E-09  -1.04146105153117E-18  -1.08087662016426E-01  -1.08087662016364E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.19132030811678E-11   0.00000000000000E+00  -6.19132030811678E-11
      5.30021462446793E-18  -5.97923679808822E-01  -5.97286367068008E-01   0.00000000000000E+00   3.39363592929717E-13
     -1.44043760466871E-22  -2.02351895857189E-09  -2.02317959497911E-09  -4.25875357293676E-18
      2.39954381250000E-07
      0.00000000000000E+00  -3.90854463660351E-12   0.00000000000000E+00   4.64011153757614E-14   3.95111258155002E-22
      3.90847194230201E-09   3.90851834341779E-09  -9.75534853290552E-19  -1.36989230971426E-01  -1.36989230971352E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.41690489323411E-11   0.00000000000000E+00  -7.41690489323411E-11
      5.15187652660325E-18  -6.09919991618698E-01  -6.08712144035526E-01   0.00000000000000E+00   2.65166542342880E-13
     -1.42958874781114E-22  -3.83461446102764E-09  -3.83434929448544E-09  -4.17634167331269E-18
      2.41954381250000E-07
      0.00000000000000E+00  -6.75646624793450E-12   0.00000000000000E+00   7.14331944917788E-14   4.23159026883104E-22
      6.75640809730560E-09   6.75647953050051E-09  -9.16850390957387E-19  -1.65336360682458E-01  -1.65336360682368E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.91699718342235E-11   0.00000000000000E+00  -8.91699718342235E-11
      4.97353658293480E-18  -6.16189530038755E-01  -6.14089270015793E-01   0.00000000000000E+00   2.14918272046482E-13
     -1.42009221343199E-22  -6.66752447693821E-09  -6.66730955866630E-09  -4.05668619197741E-18
      2.43954381250000E-07
      0.00000000000000E+00  -1.08078294508957E-11   0.00000000000000E+00   1.01027415733075E-13   4.40565350842738E-22
      1.08077413310762E-08   1.08078423584924E-08  -8.64069062237655E-19  -1.93106037154927E-01  -1.93106037154822E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05057031045589E-10   0.00000000000000E+00  -1.05057031045589E-10
      4.76342252084362E-18  -6.14512926065261E-01  -6.11141437662833E-01   0.00000000000000E+00   2.54875617035332E-13
     -1.40840107338456E-22  -1.07030402030637E-08  -1.07027853274468E-08  -3.89935345860597E-18
      2.45954381250000E-07
      0.00000000000000E+00  -1.62263015671910E-11   0.00000000000000E+00   1.34542377271643E-13   4.45604054390859E-22
      1.62261447346028E-08   1.62262792769805E-08  -8.15160594059708E-19  -2.20301539375990E-01  -2.20301539375870E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19189523163674E-10   0.00000000000000E+00  -1.19189523163674E-10
      4.52504347451627E-18  -6.02389514636682E-01  -5.97315566930873E-01   0.00000000000000E+00   4.62647437585356E-13
     -1.38750572671737E-22  -1.61075524012543E-08  -1.61070897538169E-08  -3.70988288045656E-18
      2.47954381250000E-07
      0.00000000000000E+00  -2.32459029872250E-11   0.00000000000000E+00   1.74221094659166E-13   4.37705230972810E-22
      2.32457587350288E-08   2.32459329561239E-08  -7.68366960111764E-19  -2.46935673433361E-01  -2.46935673433230E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.30236092686665E-10   0.00000000000000E+00  -1.30236092686665E-10
      4.26457128914294E-18  -5.76905441293740E-01  -5.69623570948285E-01   0.00000000000000E+00   8.56195447306420E-13
     -1.34834908294926E-22  -2.31165530588844E-08  -2.31156968634373E-08  -3.49620432903118E-18
      2.49954381250000E-07
      0.00000000000000E+00  -3.21369327725996E-11   0.00000000000000E+00   2.20584686706484E-13   4.15627021761026E-22
      3.21367155820184E-08   3.21369361667055E-08  -7.22519643903586E-19  -2.73021686022731E-01  -2.73021686022592E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.39064579619754E-10   0.00000000000000E+00  -1.39064579619754E-10
      3.98644212990343E-18  -5.34668777133128E-01  -5.24588609189689E-01   0.00000000000000E+00   1.32472868288352E-12
     -1.28412298984081E-22  -3.19991963157686E-08  -3.19978715870858E-08  -3.26392248599985E-18
      2.51954381250000E-07
      0.00000000000000E+00  -4.29464154287651E-11   0.00000000000000E+00   2.68322969150131E-13   3.73169749758340E-22
      4.29461756263989E-08   4.29464439493684E-08  -6.77092946098821E-19  -2.98568505207792E-01  -2.98568505207644E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.48244532716603E-10   0.00000000000000E+00  -1.48244532716603E-10
      3.68995306447023E-18  -4.72236786965382E-01  -4.58753816297629E-01   0.00000000000000E+00   1.64211133796218E-12
     -1.19703708356576E-22  -4.27998415279896E-08  -4.27981994166518E-08  -3.01286011837141E-18
      2.53954381250000E-07
      0.00000000000000E+00  -5.51636023721103E-11   0.00000000000000E+00   3.03649219561705E-13   3.06298273006174E-22
      5.51632618001241E-08   5.51635654493439E-08  -6.31984268843194E-19  -3.23583012026381E-01  -3.23583012026222E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.58972197570490E-10   0.00000000000000E+00  -1.58972197570490E-10
      3.37200866932925E-18  -3.87177599582581E-01  -3.69848610091018E-01   0.00000000000000E+00   1.69558331656563E-12
     -1.09471083234685E-22  -5.50062888350899E-08  -5.50045932517734E-08  -2.74002440048605E-18
      2.55954381250000E-07
      0.00000000000000E+00  -6.72562478518021E-11   0.00000000000000E+00   3.01108313955258E-13   2.44022669651409E-22
      6.72559909035465E-08   6.72562920118607E-08  -5.87244785951271E-19  -3.48072796050618E-01  -3.48072796050447E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.70947116627503E-10   0.00000000000000E+00  -1.70947116627503E-10
      3.03011443607424E-18  -2.80151596876415E-01  -2.59015949776428E-01   0.00000000000000E+00   1.51321958478499E-12
     -9.69801968762317E-23  -6.70868581148180E-08  -6.70853448952333E-08  -2.44286965012297E-18
      2.57954381250000E-07
      0.00000000000000E+00  -7.47013659393186E-11   0.00000000000000E+00   1.85855349891696E-13   1.65743211428715E-22
      7.47011977626257E-08   7.47013836179757E-08  -5.43635092650189E-19  -3.72026436030738E-01  -3.72026436030544E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.93889430056225E-10   0.00000000000000E+00  -1.93889430056225E-10
      2.64233557596179E-18  -1.60673845165668E-01  -1.37199281939320E-01   0.00000000000000E+00   9.96368856284490E-13
     -8.34875265365870E-23  -7.45084905567757E-08  -7.45074941879195E-08  -2.09870048331160E-18
      2.59954381250000E-07
      0.00000000000000E+00  -6.41708157500525E-11   0.00000000000000E+00   4.10794901324935E-14   5.65239804520092E-23
      6.41710359931971E-08   6.41710770726873E-08  -4.97821148801961E-19  -3.95490847622105E-01  -3.95490847621907E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.98130975590703E-10   0.00000000000000E+00  -1.98130975590703E-10
      2.24607362478039E-18  -6.40263982562679E-02  -4.38707719010075E-02   0.00000000000000E+00   4.68143833419431E-13
     -4.85099822513242E-23  -6.39734142409300E-08  -6.39729460970966E-08  -1.74825247597842E-18
      2.61954381250000E-07
      0.00000000000000E+00  -3.53658263538675E-11   0.00000000000000E+00  -7.13929335928570E-13   1.66199372709170E-23
      3.53665326123950E-08   3.53658186830591E-08  -4.41206115344355E-19  -4.18605811679489E-01  -4.18605811679353E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.35768563250521E-10   0.00000000000000E+00  -1.35768563250521E-10
      1.97453649827934E-18  -2.53727089408690E-02  -1.42728657783665E-02   0.00000000000000E+00   8.62334714744264E-13
     -1.67220139743597E-23  -3.52309124545233E-08  -3.52300501198086E-08  -1.53333038293499E-18
      2.63954381250000E-07
      0.00000000000000E+00  -2.19237979951227E-11   0.00000000000000E+00  -3.31827351080379E-13   7.20695094178476E-24
      2.19241028104734E-08   2.19237709831223E-08  -3.84131441995873E-19  -4.41315869314941E-01  -4.41315869314836E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05188849885684E-10   0.00000000000000E+00  -1.05188849885684E-10
      1.76415879850798E-18  -1.36458276366245E-02  -6.77149160065400E-03   0.00000000000000E+00   3.96929901325102E-13
     -8.17396977613899E-24  -2.18189790631379E-08  -2.18185821332366E-08  -1.38002735651210E-18
      2.65954381250000E-07
      0.00000000000000E+00  -1.78010714313512E-11   0.00000000000000E+00  -1.01380997836857E-13   4.81052820014189E-24
      1.78011810116253E-08   1.78010796306274E-08  -3.29536030836354E-19  -4.63580190647955E-01  -4.63580190647855E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.95121030063707E-11   0.00000000000000E+00  -9.95121030063707E-11
      1.56513459249523E-18  -1.01659273780322E-02  -4.58872515042128E-03   0.00000000000000E+00   1.46193171315823E-13
     -5.36121628134300E-24  -1.77017137207924E-08  -1.77015675276210E-08  -1.23559856165888E-18
      2.67954381250000E-07
      0.00000000000000E+00  -1.66599924162849E-11   0.00000000000000E+00  -2.78043023424971E-14   3.84790820483888E-24
      1.66600715153260E-08   1.66600437110237E-08  -2.77501092310975E-19  -4.85394188237861E-01  -4.85394188237761E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00637299323486E-10   0.00000000000000E+00  -1.00637299323486E-10
      1.36385999384826E-18  -8.96585180597482E-03  -3.74850423127322E-03   0.00000000000000E+00   6.45329223444611E-14
     -4.25646358121031E-24  -1.65594709446225E-08  -1.65594064117002E-08  -1.08635890153729E-18
      2.69954381250000E-07
      0.00000000000000E+00  -1.63329333070889E-11   0.00000000000000E+00  -7.75564919080949E-15   3.33471877030404E-24
      1.63329268219349E-08   1.63329190662857E-08  -2.27954961787014E-19  -5.06764148984967E-01  -5.06764148984864E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03030869158409E-10   0.00000000000000E+00  -1.03030869158409E-10
      1.15779825553145E-18  -8.41880142849962E-03  -3.30527132155465E-03   0.00000000000000E+00   3.95900000279211E-14
     -3.63285671593070E-24  -1.62299277871273E-08  -1.62298881971273E-08  -9.29843293744431E-19
      2.71954381250000E-07
      0.00000000000000E+00  -1.62210664171701E-11   0.00000000000000E+00  -2.48092590831974E-15   2.99125903451648E-24
      1.62210947289872E-08   1.62210922480613E-08  -1.80803154012276E-19  -5.27698652980416E-01  -5.27698652980311E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05244358371523E-10   0.00000000000000E+00  -1.05244358371523E-10
      9.47309538788399E-19  -8.09510411063604E-03  -3.01750166753889E-03   0.00000000000000E+00   3.07046284947306E-14
     -3.18842131926690E-24  -1.61158785943183E-08  -1.61158478896898E-08  -7.66506384776124E-19
      2.73954381249999E-07
      0.00000000000000E+00  -1.61710110353920E-11   0.00000000000000E+00  -9.78028304176569E-16   2.75482577547067E-24
      1.61710021603649E-08   1.61710011823366E-08  -1.35912404475409E-19  -5.48205846596362E-01  -5.48205846596255E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06941865093130E-10   0.00000000000000E+00  -1.06941865093130E-10
      7.33425808602139E-19  -7.87160492821925E-03  -2.81031743042202E-03   0.00000000000000E+00   2.63414762847824E-14
     -2.88834532940612E-24  -1.60640856587198E-08  -1.60640593172435E-08  -5.97513404126731E-19
      2.75954381249999E-07
      0.00000000000000E+00  -1.61426310115949E-11   0.00000000000000E+00  -4.64713767913965E-16   2.56567479101219E-24
      1.61426086902935E-08   1.61426082255797E-08  -9.31295797449403E-20  -5.68289853476767E-01  -5.68289853476659E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08069089010488E-10   0.00000000000000E+00  -1.08069089010488E-10
      5.17287630581164E-19  -7.70473898035193E-03  -2.65275050656166E-03   0.00000000000000E+00   2.35005914270654E-14
     -2.64194365237612E-24  -1.60345626371607E-08  -1.60345391365693E-08  -4.24158050836224E-19
      2.77954381249999E-07
      0.00000000000000E+00  -1.61238946852046E-11   0.00000000000000E+00  -2.45098905230626E-16   2.41485177178686E-24
      1.61238845655848E-08   1.61238843204859E-08  -5.23634197847091E-20  -5.87919708648147E-01  -5.87919708648039E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08477408148131E-10   0.00000000000000E+00  -1.08477408148131E-10
      3.00332814284902E-19  -7.57436049352563E-03  -2.52839829871994E-03   0.00000000000000E+00   2.13240266310253E-14
     -2.44534411875393E-24  -1.60154282363644E-08  -1.60154069123377E-08  -2.47969394500193E-19
      2.79954381249999E-07
      0.00000000000000E+00  -1.61088321483025E-11   0.00000000000000E+00  -1.74083839667124E-16   2.29271661384164E-24
      1.61087897755632E-08   1.61087896014793E-08  -1.40120455694987E-20  -6.06819513281286E-01  -6.06819513281179E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06821503408289E-10   0.00000000000000E+00  -1.06821503408289E-10
      8.66898074683236E-20  -7.46945323390914E-03  -2.42772380130703E-03   0.00000000000000E+00   1.92903531671883E-14
     -2.28685593166952E-24  -1.60019873884242E-08  -1.60019680980711E-08  -7.26777618988252E-20
      2.81954381249999E-07
      0.00000000000000E+00  -1.60844932929425E-11   0.00000000000000E+00  -4.23479201798714E-16   2.20262206150586E-24
      1.60844577030006E-08   1.60844572795214E-08   2.10775823135018E-20  -6.24463064110492E-01  -6.24463064110390E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01549073948739E-10   0.00000000000000E+00  -1.01549073948739E-10
     -1.16408340429154E-19  -7.40100656709840E-03  -2.36528119135024E-03   0.00000000000000E+00   1.72797074843705E-14
     -2.17182783684342E-24  -1.59829254852801E-08  -1.59829082055727E-08   9.53307581156522E-20
      2.83954381249999E-07
      0.00000000000000E+00  -1.60599707481081E-11   0.00000000000000E+00  -4.53521928694415E-16   2.13615931666132E-24
      1.60599957250417E-08   1.60599952715198E-08   5.14608386801533E-20  -6.40003200950127E-01  -6.40003200950036E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.07720056415729E-11   0.00000000000000E+00  -9.07720056415729E-11
     -2.97952351712300E-19  -7.35829421222534E-03  -2.32687961080033E-03   0.00000000000000E+00   1.45407388787273E-14
     -2.08843406698680E-24  -1.59692378066171E-08  -1.59692232658782E-08   2.46491513032147E-19
      2.85954381249999E-07
      0.00000000000000E+00  -1.60339786874784E-11   0.00000000000000E+00  -5.28527649290733E-16   2.08734397092672E-24
      1.60339764612718E-08   1.60339759327442E-08   7.48108307948057E-20  -6.52107782391319E-01  -6.52107782391248E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.15162094567835E-11   0.00000000000000E+00  -7.15162094567835E-11
     -4.40984770625867E-19  -7.32761531291254E-03  -2.29833099279609E-03   0.00000000000000E+00   1.08948926243298E-14
     -2.02872794390210E-24  -1.59624706181800E-08  -1.59624597232874E-08   3.66173939831061E-19
      2.86454381249999E-07
      0.00000000000000E+00  -1.60257126611297E-11   0.00000000000000E+00  -7.14536492586704E-16   2.07640953035458E-24
      1.60257142263143E-08   1.60257135117778E-08   8.00446724571931E-20  -6.54839650804178E-01  -6.54839650804113E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.49341348629898E-11   0.00000000000000E+00  -6.49341348629898E-11
     -4.73451838057362E-19  -7.32066048977077E-03  -2.29190544012631E-03   0.00000000000000E+00   9.69982431325981E-15
     -2.01587088936199E-24  -1.59607890767391E-08  -1.59607793769148E-08   3.93407165600169E-19
      2.87129381249999E-07
      0.00000000000000E+00  -1.60130380873951E-11   0.00000000000000E+00  -8.40610165012117E-16   2.06395667728910E-24
      1.60130672312946E-08   1.60130663906844E-08   8.59399669984773E-20  -6.57924684242393E-01  -6.57924684242339E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.44385507984386E-11   0.00000000000000E+00  -5.44385507984386E-11
     -5.10197859846308E-19  -7.31253177451682E-03  -2.28445443289118E-03   0.00000000000000E+00   8.08552811005164E-15
     -2.00135211229894E-24  -1.59586359254141E-08  -1.59586278398860E-08   4.24257892847830E-19
      2.88040631249999E-07
      0.00000000000000E+00  -1.59935670031071E-11   0.00000000000000E+00  -9.98820298239368E-16   2.05150883708683E-24
      1.59935507916208E-08   1.59935497928005E-08   9.14624913044616E-20  -6.60821929652503E-01  -6.60821929652465E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.79601439518012E-11   0.00000000000000E+00  -3.79601439518012E-11
     -5.44789041022387E-19  -7.30396690527474E-03  -2.27684664021533E-03   0.00000000000000E+00   5.64770702053588E-15
     -1.98774055101785E-24  -1.59555952965557E-08  -1.59555896488487E-08   4.53326549717925E-19
      2.89270818749999E-07
      0.00000000000000E+00  -1.59625234819309E-11   0.00000000000000E+00  -2.22304701614292E-14   2.04365765324766E-24
      1.59624832285278E-08   1.59624609980576E-08   9.37002769474415E-20  -6.61996728437382E-01  -6.61996728437371E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14364008885878E-11   0.00000000000000E+00  -1.14364008885878E-11
     -5.58857958440516E-19  -7.29731140803516E-03  -2.27162276503065E-03   0.00000000000000E+00   2.28270823328086E-14
     -1.98165604147113E-24  -1.59510474242514E-08  -1.59510245971690E-08   4.65157681493076E-19
      2.90931571874999E-07
      0.00000000000000E+00  -1.59113659633063E-11   0.00000000000000E+00  -1.56743082557576E-15   2.05274151937049E-24
      1.59113957882065E-08   1.59113942207757E-08   8.51294483443002E-20  -6.57494200515818E-01  -6.57494200515850E-01
      0.00000000000000E+00   0.00000000000000E+00   3.23304832327071E-11   0.00000000000000E+00   3.23304832327071E-11
     -5.05165007379038E-19  -7.29913026161176E-03  -2.27574845393238E-03   0.00000000000000E+00  -4.44660783480222E-15
     -2.00060724342605E-24  -1.59437202574006E-08  -1.59437247040084E-08   4.20035559034737E-19
      2.92931571874999E-07
      0.00000000000000E+00  -1.58338490051032E-11   0.00000000000000E+00  -2.07670758805398E-15   2.10260523117785E-24
      1.58338298518730E-08   1.58338277751655E-08   5.32775336438719E-20  -6.40927370117526E-01  -6.40927370117624E-01
      0.00000000000000E+00   0.00000000000000E+00   9.80625801481775E-11   0.00000000000000E+00   9.80625801481775E-11
     -3.09039847082683E-19  -7.32267528428226E-03  -2.30302305356937E-03   0.00000000000000E+00  -1.42743944916262E-14
     -2.07841335118813E-24  -1.59318760809191E-08  -1.59318903553136E-08   2.55762313438810E-19
      2.94931571874999E-07
      0.00000000000000E+00  -1.57317176573284E-11   0.00000000000000E+00  -2.94267996975567E-15   2.21751792090167E-24
      1.57317154344464E-08   1.57317124917664E-08  -7.40897264837256E-21  -6.10094161970864E-01  -6.10094161971043E-01
      0.00000000000000E+00   0.00000000000000E+00   1.78957997547264E-10   0.00000000000000E+00   1.78957997547264E-10
      4.88761480118448E-20  -7.38557076836981E-03  -2.37260609490493E-03   0.00000000000000E+00  -2.79939158214961E-14
     -2.25341916298379E-24  -1.59106424953978E-08  -1.59106704893137E-08  -4.14671753634721E-20
      2.96931571874999E-07
      0.00000000000000E+00  -1.55526204197738E-11   0.00000000000000E+00  -1.22751920778854E-14   2.51047916069519E-24
      1.55525744747701E-08   1.55525621995780E-08  -1.07743172107908E-19  -5.61337508079343E-01  -5.61337508079615E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71670291493017E-10   0.00000000000000E+00   2.71670291493017E-10
      5.92216730997878E-19  -7.61457291377806E-03  -2.62884381576545E-03   0.00000000000000E+00  -4.11950244828649E-14
     -2.71367763895706E-24  -1.58241912960466E-08  -1.58242324910711E-08  -4.84473558889971E-19
      2.98931571874999E-07
      0.00000000000000E+00  -1.52398890895821E-11   0.00000000000000E+00  -8.79822127991457E-15   3.24580665340258E-24
      1.52399001948986E-08   1.52398913966773E-08  -2.63976710713827E-19  -4.91103465543175E-01  -4.91103465543533E-01
      0.00000000000000E+00   0.00000000000000E+00   3.58020438815248E-10   0.00000000000000E+00   3.58020438815248E-10
      1.30825760862837E-18  -8.27988196686319E-03  -3.36546990265725E-03   0.00000000000000E+00  -8.46765205121025E-14
     -4.09692079892035E-24  -1.55978271589720E-08  -1.55979118354926E-08  -1.04428089791455E-18
      3.00931571874999E-07
      0.00000000000000E+00  -1.39184270106402E-11   0.00000000000000E+00  -3.44010128966465E-14   7.31609106252241E-24
      1.39184509396158E-08   1.39184165386029E-08  -4.92206032489899E-19  -3.97422329857963E-01  -3.97422329858359E-01
      0.00000000000000E+00   0.00000000000000E+00   3.96592448768932E-10   0.00000000000000E+00   3.96592448768932E-10
      2.10144250616624E-18  -1.14375082725509E-02  -6.92731674821983E-03   0.00000000000000E+00  -1.53271369896985E-13
     -9.21799414029908E-24  -1.43148557160019E-08  -1.43150089873718E-08  -1.60923647367634E-18
      3.02931571874999E-07
      0.00000000000000E+00  -5.77088037296053E-12   0.00000000000000E+00  -2.12712533575004E-13  -6.96547291171515E-24
      5.77115583076779E-09   5.77094311823421E-09  -7.59557721002960E-19  -2.81956681153976E-01  -2.81956681154380E-01
      0.00000000000000E+00   0.00000000000000E+00   4.04511482496418E-10   0.00000000000000E+00   4.04511482496418E-10
      2.91046547115907E-18  -3.04340711152243E-02  -2.84884036912486E-02   0.00000000000000E+00  -2.57149418992435E-13
     -6.56476441454450E-23  -6.17519745131157E-09  -6.17545460073062E-09  -2.15090775015611E-18
      3.04931571874999E-07
      0.00000000000000E+00  -2.81412274803862E-13   0.00000000000000E+00  -1.42834403849499E-13  -4.12018067611648E-23
      2.81568303820754E-10   2.81425469416863E-10  -1.02187860395522E-18  -1.56020009910118E-01  -1.56020009910509E-01
      0.00000000000000E+00   0.00000000000000E+00   3.90845705494435E-10   0.00000000000000E+00   3.90845705494435E-10
      3.69215688214794E-18  -5.97986835554381E-02  -5.95868771664475E-02   0.00000000000000E+00  -8.13019733946071E-13
     -8.92975254139257E-23  -6.71458155177263E-10  -6.72271174911298E-10  -2.67027827819272E-18
      3.06931571874999E-07
      0.00000000000000E+00   8.20173503263214E-14   0.00000000000000E+00  -1.57885835347385E-14  -4.57176059936807E-23
     -8.19947910372496E-11  -8.20105796208300E-11  -1.21404376618585E-18  -6.02029251863970E-02  -6.02029251866844E-02
      0.00000000000000E+00   0.00000000000000E+00   2.87352109825123E-10   0.00000000000000E+00   2.87352109825123E-10
      4.26686110179819E-18  -8.94830780793946E-02  -8.94183831294488E-02   0.00000000000000E+00  -1.23062736622717E-12
     -1.00250877856311E-22  -2.04110902837966E-10  -2.05341530204293E-10  -3.05281733561233E-18
      3.08931571874999E-07
      0.00000000000000E+00   3.72889633062559E-14   0.00000000000000E+00  -1.28123625337532E-15  -4.63638045543207E-23
     -3.73028446789477E-11  -3.73041259152475E-11  -1.28863252085460E-18  -2.39140973947567E-02  -2.39140973949095E-02
      0.00000000000000E+00   0.00000000000000E+00   1.52774003257874E-10   0.00000000000000E+00   1.52774003257874E-10
      4.57240910831394E-18  -1.18740552763413E-01  -1.18704173108045E-01   0.00000000000000E+00  -7.75109945074414E-13
     -1.05552338188139E-22  -1.14694767397446E-10  -1.15469877342626E-10  -3.28377658745934E-18
      3.09931571874999E-07
      0.00000000000000E+00   1.52462263764494E-14   0.00000000000000E+00   5.83421720137431E-16  -4.64137492206890E-23
     -1.52879879557656E-11  -1.52874045340919E-11  -1.30684112528437E-18  -1.57034135611779E-02  -1.57034135612856E-02
      0.00000000000000E+00   0.00000000000000E+00   1.07713039770579E-10   0.00000000000000E+00   1.07713039770579E-10
      4.68012214808452E-18  -1.33239942730665E-01  -1.33210823534756E-01   0.00000000000000E+00  -5.49943882119914E-13
     -1.07230669052977E-22  -9.18756913542595E-11  -9.24256352364866E-11  -3.37328102280015E-18
      3.11281571874999E-07
      0.00000000000000E+00  -2.66349737901828E-15   0.00000000000000E+00   1.01430751087547E-15  -4.62640545138293E-23
      2.72599810682424E-12   2.72701241428885E-12  -1.31686718998354E-18  -1.15291921973280E-02  -1.15291921974061E-02
      0.00000000000000E+00   0.00000000000000E+00   7.81216159790427E-11   0.00000000000000E+00   7.81216159790427E-11
      4.78558632965622E-18  -1.52554838428412E-01  -1.52529366813700E-01   0.00000000000000E+00  -4.29617093753635E-13
     -1.08922812822974E-22  -8.04190112994682E-11  -8.08486283933307E-11  -3.46871913967268E-18
      3.13104071874999E-07
      0.00000000000000E+00  -1.82771027042978E-14   0.00000000000000E+00   9.19147653406347E-16  -4.57475567959207E-23
      1.83170619555561E-11   1.83179811031638E-11  -1.32068706397790E-18  -9.61107597201354E-03  -9.61107597207230E-03
      0.00000000000000E+00   0.00000000000000E+00   5.87624388956501E-11   0.00000000000000E+00   5.87624388956501E-11
      4.89268087454355E-18  -1.78144174773551E-01  -1.78119890514464E-01   0.00000000000000E+00  -4.06572904057530E-13
     -1.11000871122655E-22  -7.66738470946450E-11  -7.70804199988136E-11  -3.57199381056565E-18
      3.15104071874999E-07
      0.00000000000000E+00  -3.10435211761440E-14   0.00000000000000E+00   7.18069045283505E-16  -4.45002766858872E-23
      3.10657593524222E-11   3.10664774214230E-11  -1.32035830107746E-18  -8.76542757697372E-03  -8.76542757702059E-03
      0.00000000000000E+00   0.00000000000000E+00   4.68735177769714E-11   0.00000000000000E+00   4.68735177769714E-11
      4.98642791009749E-18  -2.05644803274102E-01  -2.05620248385922E-01   0.00000000000000E+00  -4.21766032053097E-13
     -1.13279572515031E-22  -7.75182291662288E-11  -7.79399951983952E-11  -3.66606960902003E-18
      3.17104071874999E-07
      0.00000000000000E+00  -4.16056659550096E-14   0.00000000000000E+00   5.56283241589404E-16  -4.20347542100960E-23
      4.16173408601400E-11   4.16178971433395E-11  -1.31815299159244E-18  -8.31911721875534E-03  -8.31911721879465E-03
      0.00000000000000E+00   0.00000000000000E+00   3.93043801672077E-11   0.00000000000000E+00   3.93043801672077E-11
      5.06503667043191E-18  -2.32577357021238E-01  -2.32551862768046E-01   0.00000000000000E+00  -4.42902484070369E-13
     -1.15594784898821E-22  -8.04793748263607E-11  -8.09222773105467E-11  -3.74688367883946E-18
      3.19104071874999E-07
      0.00000000000000E+00  -5.08819844129698E-14   0.00000000000000E+00   4.45476288639143E-16  -3.77501313949677E-23
      5.08765282884377E-11   5.08769737646886E-11  -1.31520575803242E-18  -8.03181124019609E-03  -8.03181124023024E-03
      0.00000000000000E+00   0.00000000000000E+00   3.41452821040393E-11   0.00000000000000E+00   3.41452821040393E-11
      5.13332723463998E-18  -2.58956665641974E-01  -2.58929879929652E-01   0.00000000000000E+00  -4.62231247280389E-13
     -1.17941934881981E-22  -8.45600246213302E-11  -8.50222558687285E-11  -3.81812147660757E-18
      3.21104071874999E-07
      0.00000000000000E+00  -5.93317002360623E-14   0.00000000000000E+00   3.72583992356921E-16  -3.10339429030614E-23
      5.93041802605320E-11   5.93045528444933E-11  -1.31204641953847E-18  -7.82598326100436E-03  -7.82598326103483E-03
      0.00000000000000E+00   0.00000000000000E+00   3.04768365692842E-11   0.00000000000000E+00   3.04768365692842E-11
      5.19428090777855E-18  -2.84794121793936E-01  -2.84765836994756E-01   0.00000000000000E+00  -4.79659993712309E-13
     -1.20314054860920E-22  -8.93017294199449E-11  -8.97813894137776E-11  -3.88223448824009E-18
      3.23104071874999E-07
      0.00000000000000E+00  -6.71385028987021E-14   0.00000000000000E+00   3.24656872759268E-16  -2.13822921811525E-23
      6.71710248313852E-11   6.71713494882366E-11  -1.30892398934318E-18  -7.66969060563763E-03  -7.66969060566539E-03
      0.00000000000000E+00   0.00000000000000E+00   2.77659936598755E-11   0.00000000000000E+00   2.77659936598755E-11
      5.24981289509830E-18  -3.10094591629148E-01  -3.10064682762750E-01   0.00000000000000E+00  -4.96458566946194E-13
     -1.22708714784298E-22  -9.44408845810425E-11  -9.49373431481114E-11  -3.94088890575512E-18
      3.25104071874999E-07
      0.00000000000000E+00  -7.46697713497193E-14   0.00000000000000E+00   2.92862967055324E-16  -8.58478573509107E-24
      7.46596173600606E-11   7.46599102230191E-11  -1.30594683508268E-18  -7.54626775816422E-03  -7.54626775818990E-03
      0.00000000000000E+00   0.00000000000000E+00   2.56788109968955E-11   0.00000000000000E+00   2.56788109968955E-11
      5.30117051709209E-18  -3.34863243770678E-01  -3.34831633553194E-01   0.00000000000000E+00  -5.14104149261660E-13
     -1.25129390919405E-22  -9.98246170705286E-11  -1.00338721219915E-10  -3.99522368200941E-18
      3.27104071874999E-07
      0.00000000000000E+00  -8.19255055891139E-14   0.00000000000000E+00   2.71239116777018E-16   6.97483304850346E-24
      8.18942386946551E-11   8.18945099337788E-11  -1.30315243871090E-18  -7.44587426104400E-03  -7.44587426106800E-03
      0.00000000000000E+00   0.00000000000000E+00   2.39970306630809E-11   0.00000000000000E+00   2.39970306630809E-11
      5.34916457841826E-18  -3.59105904324303E-01  -3.59072545081875E-01   0.00000000000000E+00  -5.33788725780510E-13
     -1.27583549957602E-22  -1.05357751870951E-10  -1.05891540596859E-10  -4.04601213970735E-18
      3.29104071874999E-07
      0.00000000000000E+00  -8.89975503540934E-14   0.00000000000000E+00   2.60772941597183E-16   2.37925076677763E-23
      8.90386808684899E-11   8.90389416414552E-11  -1.30049183565199E-18  -7.38786285370045E-03  -7.38786285372297E-03
      0.00000000000000E+00   0.00000000000000E+00   2.25168065694182E-11   0.00000000000000E+00   2.25168065694182E-11
      5.39419819155709E-18  -3.82811204161084E-01  -3.82776060842475E-01   0.00000000000000E+00  -5.55062742300577E-13
     -1.30074856115183E-22  -1.11000685468442E-10  -1.11555748210873E-10  -4.09370635590510E-18
      3.31104071874999E-07
      0.00000000000000E+00  -9.60695951190730E-14   0.00000000000000E+00   2.50900136218434E-16   4.07444672287128E-23
      9.60810960520357E-11   9.60813469522127E-11  -1.29798585604207E-18  -7.34786713370740E-03  -7.34786713372872E-03
      0.00000000000000E+00   0.00000000000000E+00   2.13211119494447E-11   0.00000000000000E+00   2.13211119494447E-11
      5.43684041545598E-18  -4.06095426268000E-01  -4.06058441419220E-01   0.00000000000000E+00  -5.83821174585118E-13
     -1.32630732743196E-22  -1.16818637726940E-10  -1.17402458901658E-10  -4.13885455941391E-18
      3.33104071874999E-07
      0.00000000000000E+00  -1.03049795146845E-13   0.00000000000000E+00   2.43590197037104E-16   5.69219258426975E-23
      1.03064469921202E-10   1.03064713511456E-10  -1.29562581794688E-18  -7.31841339133731E-03  -7.31841339135760E-03
      0.00000000000000E+00   0.00000000000000E+00   2.02907574522058E-11   0.00000000000000E+00   2.02907574522058E-11
      5.47742193036039E-18  -4.29027735264473E-01  -4.28988875445707E-01   0.00000000000000E+00  -6.18778293585130E-13
     -1.35268065732787E-22  -1.22736692669942E-10  -1.23355470963662E-10  -4.18179611241352E-18
      3.35104071874999E-07
      0.00000000000000E+00  -1.10029995174617E-13   0.00000000000000E+00   2.37378901581354E-16   7.15973036168511E-23
      1.09988169877255E-10   1.09988407256229E-10  -1.29339836130583E-18  -7.29965374676514E-03  -7.29965374678441E-03
      0.00000000000000E+00   0.00000000000000E+00   1.92741281093106E-11   0.00000000000000E+00   1.92741281093106E-11
      5.51597018657901E-18  -4.51534728306065E-01  -4.51494008048553E-01   0.00000000000000E+00  -6.54747808591445E-13
     -1.37977134376797E-22  -1.28607787556810E-10  -1.29262535365539E-10  -4.22257182527318E-18
      3.36104071874999E-07
      0.00000000000000E+00  -1.13428250451296E-13   0.00000000000000E+00   2.35738417845358E-16   7.86094790721958E-23
      1.13463830478337E-10   1.13464066216834E-10  -1.29231740155769E-18  -7.29323188166823E-03  -7.29323188168696E-03
      0.00000000000000E+00   0.00000000000000E+00   1.87240279206403E-11   0.00000000000000E+00   1.87240279206403E-11
      5.53469421449965E-18  -4.62675206443833E-01  -4.62633564796226E-01   0.00000000000000E+00  -6.82663162349550E-13
     -1.39354727001365E-22  -1.31505430974986E-10  -1.32188094137475E-10  -4.24237681294197E-18
      3.37454071874999E-07
      0.00000000000000E+00  -1.18112332048879E-13   0.00000000000000E+00   2.31974315357593E-16   8.70026752574266E-23
      1.18115385539992E-10   1.18115617514394E-10  -1.29090773140500E-18  -7.29111320202864E-03  -7.29111320204670E-03
      0.00000000000000E+00   0.00000000000000E+00   1.80577602269256E-11   0.00000000000000E+00   1.80577602269256E-11
      5.55907219080600E-18  -4.77509336460359E-01  -4.77466439697794E-01   0.00000000000000E+00  -7.06605864101688E-13
     -1.41240582188988E-22  -1.35466771877078E-10  -1.36173377741321E-10  -4.26816445940100E-18
      3.39276571874999E-07
      0.00000000000000E+00  -1.24357774178991E-13   0.00000000000000E+00   2.28385660434117E-16   9.65113819179965E-23
      1.24343603260999E-10   1.24343831646756E-10  -1.28907526239257E-18  -7.30364504534571E-03  -7.30364504536292E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72059944441189E-11   0.00000000000000E+00   1.72059944441189E-11
      5.59043011568041E-18  -4.97164547263882E-01  -4.97119957303737E-01   0.00000000000000E+00  -7.39113804029140E-13
     -1.43823004977232E-22  -1.40810712286702E-10  -1.41549826090875E-10  -4.30135485328784E-18
      3.41276571874999E-07
      0.00000000000000E+00  -1.31154284732348E-13   0.00000000000000E+00   2.27252444808810E-16   1.05071728722294E-22
      1.31182353742471E-10   1.31182580995021E-10  -1.28711761761629E-18  -7.34452667918775E-03  -7.34452667920405E-03
      0.00000000000000E+00   0.00000000000000E+00   1.62989706366730E-11   0.00000000000000E+00   1.62989706366730E-11
      5.62302805695376E-18  -5.18295122832775E-01  -5.18248664863111E-01   0.00000000000000E+00  -7.77831739633841E-13
     -1.46685693861155E-22  -1.46703719891912E-10  -1.47481551631693E-10  -4.33591043933746E-18
      3.43276571874999E-07
      0.00000000000000E+00  -1.38410018971743E-13   0.00000000000000E+00   2.42161646210006E-16   1.12265876084166E-22
      1.38396110247522E-10   1.38396352409280E-10  -1.28504730920428E-18  -7.48402798958948E-03  -7.48402798960480E-03
      0.00000000000000E+00   0.00000000000000E+00   1.53127937038015E-11   0.00000000000000E+00   1.53127937038015E-11
      5.65365364436136E-18  -5.38995308965894E-01  -5.38946889859707E-01   0.00000000000000E+00  -8.14431543333337E-13
     -1.49546352435836E-22  -1.52894714569599E-10  -1.53709146113082E-10  -4.36860633515708E-18
      3.45276571874999E-07
      0.00000000000000E+00  -1.46859734794835E-13   0.00000000000000E+00   2.93288301019137E-16   1.18873544122071E-22
      1.46834208242624E-10   1.46834501531044E-10  -1.28248381650776E-18  -7.88857463574164E-03  -7.88857463575572E-03
      0.00000000000000E+00   0.00000000000000E+00   1.40828513537900E-11   0.00000000000000E+00   1.40828513537900E-11
      5.68181934706894E-18  -5.59272734697043E-01  -5.59222045643803E-01   0.00000000000000E+00  -8.40887926762292E-13
     -1.52358219098674E-22  -1.60076464957920E-10  -1.60917352884834E-10  -4.39933553056117E-18
      3.47276571874999E-07
      0.00000000000000E+00  -1.61095669062002E-13   0.00000000000000E+00   5.34062870691256E-16   1.27803638691367E-22
      1.61134610755925E-10   1.61135144818924E-10  -1.27757937184406E-18  -9.39605333800329E-03  -9.39605333801469E-03
      0.00000000000000E+00   0.00000000000000E+00   1.14025018770161E-11   0.00000000000000E+00   1.14025018770161E-11
      5.70462435082297E-18  -5.79128155047313E-01  -5.79073806376612E-01   0.00000000000000E+00  -8.21370094448254E-13
     -1.54974045581680E-22  -1.71716276601337E-10  -1.72537646695940E-10  -4.42704497897891E-18
      3.49276571874999E-07
      0.00000000000000E+00  -2.30346600916477E-13   0.00000000000000E+00   2.57710611083694E-15   1.64638810257051E-22
      2.30334658830702E-10   2.30337235936977E-10  -1.25416676604841E-18  -1.93246081562046E-02  -1.93246081562000E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.57320137842842E-12   0.00000000000000E+00  -4.57320137842842E-12
      5.69547794806611E-18  -5.98490058016971E-01  -5.98418944492956E-01   0.00000000000000E+00  -4.21683110014350E-13
     -1.56267011659015E-22  -2.25342351448378E-10  -2.25764034558549E-10  -4.44131118201771E-18
      3.51276571874999E-07
      0.00000000000000E+00  -5.13503925727282E-13   0.00000000000000E+00   9.19947459235123E-15   2.61732885358257E-22
      5.13450820897792E-10   5.13460020372646E-10  -1.18885232243975E-18  -4.69459217544898E-02  -4.69459217544491E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.06784616374766E-11   0.00000000000000E+00  -4.06784616374766E-11
      5.61412102479116E-18  -6.16993208034681E-01  -6.16844286998725E-01   0.00000000000000E+00   4.43688172316637E-13
     -1.54894134168034E-22  -4.73225246907332E-10  -4.72781558735171E-10  -4.42526870235141E-18
      3.53276571874999E-07
      0.00000000000000E+00  -1.09166654644866E-12   0.00000000000000E+00   1.62307445940763E-14   3.31632268423941E-22
      1.09163071088272E-09   1.09164694162765E-09  -1.11446433665975E-18  -7.67349417025584E-02  -7.67349417025048E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.36080594932446E-11   0.00000000000000E+00  -5.36080594932446E-11
      5.50690490580467E-18  -6.34038415124758E-01  -6.33711441199234E-01   0.00000000000000E+00   4.90903965046143E-13
     -1.53329384189152E-22  -1.03852978609929E-09  -1.03803888213440E-09  -4.39244056914491E-18
      3.55276571874999E-07
      0.00000000000000E+00  -2.18535367711589E-12   0.00000000000000E+00   2.86358132637304E-14   3.75612960864807E-22
      2.18534618397894E-09   2.18537481979258E-09  -1.04214781445391E-18  -1.06201327826150E-01  -1.06201327826086E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.35202986692281E-11   0.00000000000000E+00  -6.35202986692281E-11
      5.37986430846622E-18  -6.48649717336652E-01  -6.47981345144594E-01   0.00000000000000E+00   4.11346600699794E-13
     -1.51959931368027E-22  -2.12226586772390E-09  -2.12185452112335E-09  -4.33771649401231E-18
      3.57276571874999E-07
      0.00000000000000E+00  -4.06991583987713E-12   0.00000000000000E+00   4.79107375165138E-14   4.09763262235297E-22
      4.06989490615703E-09   4.06994281689496E-09  -9.76242835123250E-19  -1.35158558913276E-01  -1.35158558913200E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.58984929438119E-11   0.00000000000000E+00  -7.58984929438119E-11
      5.22806732257859E-18  -6.59347497313462E-01  -6.58089388521198E-01   0.00000000000000E+00   3.13736957232149E-13
     -1.50852446387967E-22  -3.99435806090823E-09  -3.99404432395115E-09  -4.25182448745535E-18
      3.59276571874999E-07
      0.00000000000000E+00  -6.99122139623694E-12   0.00000000000000E+00   7.32891464043965E-14   4.36201701041169E-22
      6.99115400734127E-09   6.99122729648811E-09  -9.17632767540538E-19  -1.63545665280679E-01  -1.63545665280588E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.11096917661407E-11   0.00000000000000E+00  -9.11096917661407E-11
      5.04584793904631E-18  -6.64205058313774E-01  -6.62031536433290E-01   0.00000000000000E+00   2.40652521419299E-13
     -1.49933658768817E-22  -6.90035825724324E-09  -6.90011760472197E-09  -4.12821517150578E-18
      3.61276571874999E-07
      0.00000000000000E+00  -1.11247856389989E-11   0.00000000000000E+00   1.02968278521045E-13   4.52173626917108E-22
      1.11246398498971E-08   1.11247428181761E-08  -8.64940810461695E-19  -1.91349664469031E-01  -1.91349664468924E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07013495470636E-10   0.00000000000000E+00  -1.07013495470636E-10
      4.83182094810504E-18  -6.60988253465316E-01  -6.57517671311357E-01   0.00000000000000E+00   2.87699070849918E-13
     -1.48794579095974E-22  -1.10180170217761E-08  -1.10177293227054E-08  -3.96688013764335E-18
      3.63276571874999E-07
      0.00000000000000E+00  -1.66420826925294E-11   0.00000000000000E+00   1.31689736680444E-13   4.56021511521407E-22
      1.66419043987467E-08   1.66420360884839E-08  -8.16109112798997E-19  -2.18577974034281E-01  -2.18577974034160E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20819797570775E-10   0.00000000000000E+00  -1.20819797570775E-10
      4.59018135296349E-18  -6.47166696376487E-01  -6.41962459184518E-01   0.00000000000000E+00   5.63440508858581E-13
     -1.46623667148971E-22  -1.65217797314218E-08  -1.65212162909131E-08  -3.77407224016449E-18
      3.65276571874999E-07
      0.00000000000000E+00  -2.38013799578561E-11   0.00000000000000E+00   1.77658187530298E-13   4.47947380325179E-22
      2.38011678352352E-08   2.38013454934232E-08  -7.69362369022864E-19  -2.45245043654419E-01  -2.45245043654287E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.31253023941916E-10   0.00000000000000E+00  -1.31253023941916E-10
      4.32767530507966E-18  -6.19751909356020E-01  -6.12295610822701E-01   0.00000000000000E+00   1.06657018341519E-12
     -1.42363850569216E-22  -2.36711590396645E-08  -2.36700924694812E-08  -3.55831293605679E-18
      3.67276571874999E-07
      0.00000000000000E+00  -3.29175211941264E-11   0.00000000000000E+00   2.25719050356949E-13   4.28340793955602E-22
      3.29172808031353E-08   3.29175065221861E-08  -7.23521660941584E-19  -2.71364765112516E-01  -2.71364765112376E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.39291242737673E-10   0.00000000000000E+00  -1.39291242737673E-10
      4.04909281960431E-18  -5.75194822106317E-01  -5.64869069268699E-01   0.00000000000000E+00   1.67974957738692E-12
     -1.35078901860595E-22  -3.27798950290257E-08  -3.27782152794484E-08  -3.32557115866273E-18
      3.69276571874999E-07
      0.00000000000000E+00  -4.40817082253873E-11   0.00000000000000E+00   2.75926031890334E-13   3.92756440538453E-22
      4.40814060134289E-08   4.40816819394612E-08  -6.78089056992086E-19  -2.96945615342293E-01  -2.96945615342145E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.47947046938685E-10   0.00000000000000E+00  -1.47947046938685E-10
      3.75319872572694E-18  -5.09816563031304E-01  -4.95976083448062E-01   0.00000000000000E+00   2.08917241475980E-12
     -1.24820712343438E-22  -4.39358240649371E-08  -4.39337348925225E-08  -3.07510966873486E-18
      3.71276571874999E-07
      0.00000000000000E+00  -5.66616818807023E-11   0.00000000000000E+00   3.12645320971265E-13   3.28008286696137E-22
      5.66614063287604E-08   5.66617189740817E-08  -6.33136038822746E-19  -3.21990888031542E-01  -3.21990888031382E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.59994067548107E-10   0.00000000000000E+00  -1.59994067548107E-10
      3.43321059063073E-18  -4.21181321693509E-01  -4.03380851706426E-01   0.00000000000000E+00   2.05564214048837E-12
     -1.13233456295727E-22  -5.65037805486740E-08  -5.65017249065336E-08  -2.80007455180798E-18
      3.73276571874999E-07
      0.00000000000000E+00  -6.91746088778557E-11   0.00000000000000E+00   3.11641124462610E-13   2.55380221691707E-22
      6.91743186974096E-08   6.91746303385343E-08  -5.88677861101687E-19  -3.46509037317870E-01  -3.46509037317697E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.72885638533140E-10   0.00000000000000E+00  -1.72885638533140E-10
      3.08743931356445E-18  -3.09784689891626E-01  -2.88045413755637E-01   0.00000000000000E+00   1.77024753728341E-12
     -1.00351458283894E-22  -6.90035149475385E-08  -6.90017447000014E-08  -2.49876145246276E-18
      3.75276571874999E-07
      0.00000000000000E+00  -7.74345734738774E-11   0.00000000000000E+00   2.20746791572861E-13   1.83441343476344E-22
      7.74343994265492E-08   7.74346201733409E-08  -5.45203010826236E-19  -3.70494799273655E-01  -3.70494799273462E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.93608185132423E-10   0.00000000000000E+00  -1.93608185132423E-10
      2.70022294329960E-18  -1.84415370150521E-01  -1.60079652514375E-01   0.00000000000000E+00   1.18190819212882E-12
     -8.56676087144709E-23  -7.72421938964006E-08  -7.72410119882085E-08  -2.15501993247337E-18
      3.77276571874999E-07
      0.00000000000000E+00  -7.03543545272864E-11   0.00000000000000E+00  -1.75881749965809E-13   6.87265305289021E-23
      7.03545629217597E-08   7.03543870400098E-08  -5.00924198025010E-19  -3.93971942021545E-01  -3.93971942021338E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.07411538905107E-10   0.00000000000000E+00  -2.07411538905107E-10
      2.28539986548939E-18  -7.52596766698866E-02  -5.31587373260549E-02   0.00000000000000E+00   8.12397088106534E-13
     -5.70728134696380E-23  -7.01477878981928E-08  -7.01469755011047E-08  -1.78447566746438E-18
      3.79276571874999E-07
      0.00000000000000E+00  -3.93085372327122E-11   0.00000000000000E+00  -7.70170844015368E-13   1.97147936064022E-23
      3.93092883974317E-08   3.93085182265877E-08  -4.45194369751078E-19  -4.17098286281478E-01  -4.17098286281332E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.45611668965490E-10   0.00000000000000E+00  -1.45611668965490E-10
      1.99417652755841E-18  -2.87115901948991E-02  -1.63726344557309E-02   0.00000000000000E+00   9.47219934708377E-13
     -1.85575048246143E-23  -3.91638537775569E-08  -3.91629065576222E-08  -1.54898215780733E-18
      3.81276571874999E-07
      0.00000000000000E+00  -2.31553440763384E-11   0.00000000000000E+00  -3.98997639510215E-13   7.90304080700184E-24
      2.31557109131458E-08   2.31553119155062E-08  -3.87890125260073E-19  -4.39833562614311E-01  -4.39833562614204E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07858474374353E-10   0.00000000000000E+00  -1.07858474374353E-10
      1.77845957880970E-18  -1.45255272729365E-02  -7.26401394907919E-03   0.00000000000000E+00   4.68986985807883E-13
     -8.62507984431880E-24  -2.30479224281177E-08  -2.30474534411319E-08  -1.39056945354963E-18
      3.82276571874999E-07
      0.00000000000000E+00  -1.91589040262273E-11   0.00000000000000E+00  -1.96945377091396E-13   5.74022694294820E-24
      1.91591331453935E-08   1.91589362000165E-08  -3.59944074038067E-19  -4.51091741397631E-01  -4.51091741397529E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01801607201968E-10   0.00000000000000E+00  -1.01801607201968E-10
      1.67665797160773E-18  -1.14312997241385E-02  -5.42700444494862E-03   0.00000000000000E+00   2.47123704882381E-13
     -6.47858174433689E-24  -1.90573817165194E-08  -1.90571345928145E-08  -1.31671389756967E-18
      3.83626571874999E-07
      0.00000000000000E+00  -1.72796688582241E-11   0.00000000000000E+00  -6.83303989671275E-14   4.56051263161358E-24
      1.72797287927222E-08   1.72796604623233E-08  -3.23454052802923E-19  -4.66085304789288E-01  -4.66085304789188E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.97099565175915E-11   0.00000000000000E+00  -9.97099565175915E-11
      1.54204953030898E-18  -9.78879077320923E-03  -4.37593296163042E-03   0.00000000000000E+00   1.10246080831908E-13
     -5.12001629523327E-24  -1.71800607518865E-08  -1.71799505058057E-08  -1.21859547750606E-18
      3.85449071874999E-07
      0.00000000000000E+00  -1.65511564026940E-11   0.00000000000000E+00  -1.93764742916252E-14   3.80693674488909E-24
      1.65511702394703E-08   1.65511508629960E-08  -2.76177218671576E-19  -4.85952883806771E-01  -4.85952883806671E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00726521107040E-10   0.00000000000000E+00  -1.00726521107040E-10
      1.35847544559141E-18  -8.89521516386980E-03  -3.71220430452977E-03   0.00000000000000E+00   5.55818717376610E-14
     -4.21469641264661E-24  -1.64504799237607E-08  -1.64504243418890E-08  -1.08229822691983E-18
      3.87449071874999E-07
      0.00000000000000E+00  -1.63084107622545E-11   0.00000000000000E+00  -5.67405387721368E-15   3.32172501352223E-24
      1.63084304126681E-08   1.63084247386142E-08  -2.26701786663950E-19  -5.07311810687051E-01  -5.07311810686948E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03049809438877E-10   0.00000000000000E+00  -1.03049809438877E-10
      1.15237582671365E-18  -8.39807021208067E-03  -3.29226338701993E-03   0.00000000000000E+00   3.73707167670882E-14
     -3.61460339965625E-24  -1.62054122998921E-08  -1.62053749291754E-08  -9.25674040049701E-19
      3.89449071874999E-07
      0.00000000000000E+00  -1.62154638882005E-11   0.00000000000000E+00  -2.01057712616812E-15   2.99212545279916E-24
      1.62154514866742E-08   1.62154494760970E-08  -1.79610732473793E-19  -5.28235799765621E-01  -5.28235799765515E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05289416227156E-10   0.00000000000000E+00  -1.05289416227156E-10
      9.41796994259340E-19  -8.08638381026348E-03  -3.01057335215077E-03   0.00000000000000E+00   3.01489731825472E-14
     -3.19545889544658E-24  -1.61101902088431E-08  -1.61101600598699E-08  -7.62186261785547E-19
      3.91449071874999E-07
      0.00000000000000E+00  -1.61695415195967E-11   0.00000000000000E+00  -8.75595742950723E-16   2.74921750096697E-24
      1.61695383555271E-08   1.61695374799313E-08  -1.34774110425628E-19  -5.48733321253060E-01  -5.48733321252953E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06983533044252E-10   0.00000000000000E+00  -1.06983533044252E-10
      7.27829928170836E-19  -7.86640407222104E-03  -2.80559082090149E-03   0.00000000000000E+00   2.61734517311205E-14
     -2.88105815278851E-24  -1.60625801203388E-08  -1.60625539468871E-08  -5.93055817745207E-19
      3.93449071874999E-07
      0.00000000000000E+00  -1.61421717879089E-11   0.00000000000000E+00  -6.14067960679977E-16   2.56131265795642E-24
      1.61421515596398E-08   1.61421509455718E-08  -9.20357302118109E-20  -5.68810312027676E-01  -5.68810312027567E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08112258630316E-10   0.00000000000000E+00  -1.08112258630316E-10
      5.11605410910202E-19  -7.70097247607505E-03  -2.64914157728499E-03   0.00000000000000E+00   2.35998440779130E-14
     -2.63624070142260E-24  -1.60340622867856E-08  -1.60340386869415E-08  -4.19569680698392E-19
      3.95449071874999E-07
      0.00000000000000E+00  -1.61238946852046E-11   0.00000000000000E+00  -3.10813392887170E-16   2.41119611463379E-24
      1.61238689768359E-08   1.61238686660225E-08  -5.12684796021376E-20  -5.88453551760023E-01  -5.88453551759914E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08622593885741E-10   0.00000000000000E+00  -1.08622593885741E-10
      2.94360223138720E-19  -7.57130248744882E-03  -2.52539090017214E-03   0.00000000000000E+00   2.13721255638208E-14
     -2.44052327762418E-24  -1.60152674442623E-08  -1.60152460721367E-08  -2.43091743536583E-19
      3.97449071874999E-07
      0.00000000000000E+00  -1.61096587509374E-11   0.00000000000000E+00  -2.94782280847916E-15   2.28909870368042E-24
      1.61096197146900E-08   1.61096167668672E-08  -1.27236981653320E-20  -6.07461657079255E-01  -6.07461657079148E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07501915664644E-10   0.00000000000000E+00  -1.07501915664644E-10
      7.93563918094313E-20  -7.46646860950517E-03  -2.42469201348009E-03   0.00000000000000E+00   2.21531764454072E-14
     -2.28194905643169E-24  -1.60021370043790E-08  -1.60021148512025E-08  -6.66326936440996E-20
      3.99449071874999E-07
      0.00000000000000E+00  -1.60856872745262E-11   0.00000000000000E+00  -4.10905878238241E-16   2.19903315223320E-24
      1.60857069092323E-08   1.60857064983264E-08   2.28396875394290E-20  -6.25357802954209E-01  -6.25357802954106E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03073909876491E-10   0.00000000000000E+00  -1.03073909876491E-10
     -1.26791427943552E-19  -7.39892044852355E-03  -2.36328185713091E-03   0.00000000000000E+00   1.74949183586657E-14
     -2.16686568681539E-24  -1.59826500833683E-08  -1.59826325884499E-08   1.03951740404122E-19
      4.01449071874999E-07
      0.00000000000000E+00  -1.60633690033848E-11   0.00000000000000E+00  -3.97375620091165E-16   2.13127384387711E-24
      1.60633453890334E-08   1.60633449916578E-08   5.41410687042908E-20  -6.41385933081508E-01  -6.41385933081414E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.37122923173834E-11   0.00000000000000E+00  -9.37122923173834E-11
     -3.14216012578319E-19  -7.35569647032268E-03  -2.32415278825598E-03   0.00000000000000E+00   1.49315742847887E-14
     -2.08154009722721E-24  -1.59696476309147E-08  -1.59696326993404E-08   2.60074943874029E-19
      4.03449071874999E-07
      0.00000000000000E+00  -1.60398567506597E-11   0.00000000000000E+00  -4.59423228620085E-16   2.08011245647848E-24
      1.60398255792685E-08   1.60398251198453E-08   7.90720373824786E-20  -6.54332167170449E-01  -6.54332167170373E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.65937560008234E-11   0.00000000000000E+00  -7.65937560008234E-11
     -4.67403524579965E-19  -7.32382402782008E-03  -2.29429646267161E-03   0.00000000000000E+00   1.15874381660661E-14
     -2.01845880206465E-24  -1.59632429512826E-08  -1.59632313638444E-08   3.88331487197486E-19
      4.05449071874999E-07
      0.00000000000000E+00  -1.60058741978929E-11   0.00000000000000E+00  -7.63755616823121E-16   2.04738659579491E-24
      1.60058492401267E-08   1.60058484763711E-08   9.46236960059178E-20  -6.62485029032146E-01  -6.62485029032097E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.86256533012774E-11   0.00000000000000E+00  -4.86256533012774E-11
     -5.64654831182521E-19  -7.30235968642644E-03  -2.27472476713269E-03   0.00000000000000E+00   7.19075045391815E-15
     -1.98060323270045E-24  -1.59572300138202E-08  -1.59572228230698E-08   4.70031135176603E-19
      4.07449071874999E-07
      0.00000000000000E+00  -1.59578394003334E-11   0.00000000000000E+00  -1.17409495809560E-15   2.03714696287819E-24
      1.59578096662504E-08   1.59578084921554E-08   9.70425547412232E-20  -6.63755971782463E-01  -6.63755971782455E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.62621732579649E-12   0.00000000000000E+00  -7.62621732579649E-12
     -5.79907265834113E-19  -7.29316495029910E-03  -2.26774821612737E-03   0.00000000000000E+00   1.26489482788867E-15
     -1.97371097102311E-24  -1.59501835397245E-08  -1.59501822748296E-08   4.82864711092891E-19
      4.09449071874999E-07
      0.00000000000000E+00  -1.58935480842881E-11   0.00000000000000E+00  -1.65865916254147E-15   2.05647354403256E-24
      1.58935315787117E-08   1.58935299200525E-08   8.18574064936674E-20  -6.55780120670085E-01  -6.55780120670133E-01
      0.00000000000000E+00   0.00000000000000E+00   4.75693200193057E-11   0.00000000000000E+00   4.75693200193057E-11
     -4.84768625795502E-19  -7.30006855432995E-03  -2.27751404430855E-03   0.00000000000000E+00  -6.63854394026884E-15
     -2.00799572307916E-24  -1.59410926015279E-08  -1.59410992400718E-08   4.02911219301833E-19
      4.11449071874999E-07
      0.00000000000000E+00  -1.58103367523781E-11   0.00000000000000E+00  -2.52934239340946E-15   2.11890701852718E-24
      1.58103538130985E-08   1.58103512837561E-08   4.33790807712556E-20  -6.35831566406700E-01  -6.35831566406817E-01
      0.00000000000000E+00   0.00000000000000E+00   1.17770653945076E-10   0.00000000000000E+00   1.17770653945076E-10
     -2.49227317905350E-19  -7.33045620945823E-03  -2.31199149968907E-03   0.00000000000000E+00  -1.70701836444096E-14
     -2.10406919414373E-24  -1.59281048675175E-08  -1.59281219377011E-08   2.05848237134095E-19
      4.13449071874999E-07
      0.00000000000000E+00  -1.56927754887524E-11   0.00000000000000E+00  -3.25490149896197E-15   2.26498970078238E-24
      1.56927815488512E-08   1.56927782939497E-08  -2.63990067318466E-20  -6.00646426664605E-01  -6.00646426664808E-01
      0.00000000000000E+00   0.00000000000000E+00   2.02886389420790E-10   0.00000000000000E+00   2.02886389420790E-10
      1.56545460936230E-19  -7.42203738713852E-03  -2.41380128208561E-03   0.00000000000000E+00  -3.25056457469073E-14
     -2.32652668947112E-24  -1.58956321777247E-08  -1.58956646833705E-08  -1.30146454204384E-19
      4.15449071874999E-07
      0.00000000000000E+00  -1.54956766827051E-11   0.00000000000000E+00  -2.47305364659787E-13   2.62707495834377E-24
      1.54955934242199E-08   1.54953461188553E-08  -1.39515915236289E-19  -5.46502022806617E-01  -5.46502022806914E-01
      0.00000000000000E+00   0.00000000000000E+00   2.97121428543554E-10   0.00000000000000E+00   2.97121428543554E-10
      7.50788318023337E-19  -7.71147729484654E-03  -2.73568381027290E-03   0.00000000000000E+00   1.85927868949623E-13
     -2.90899826665716E-24  -1.57926534752678E-08  -1.57924675473988E-08  -6.11272402787048E-19
      4.17449071874999E-07
      0.00000000000000E+00  -1.50879778942409E-11   0.00000000000000E+00  -1.11570698531100E-14   3.72103351791057E-24
      1.50880015904288E-08   1.50879904333589E-08  -3.13566623136614E-19  -4.70109543879599E-01  -4.70109543879976E-01
      0.00000000000000E+00   0.00000000000000E+00   3.76157293439319E-10   0.00000000000000E+00   3.76157293439319E-10
      1.50310290490198E-18  -8.63583062360224E-03  -3.76356684580868E-03   0.00000000000000E+00  -9.83661641367810E-14
     -4.25361461768375E-24  -1.54640493606341E-08  -1.54641477267982E-08  -1.18953628176536E-18
      4.19449071874999E-07
      0.00000000000000E+00  -1.28814080828300E-11   0.00000000000000E+00  -5.66066463003252E-14   5.79158713683062E-24
      1.28813936935571E-08   1.28813370869108E-08  -5.59207669981708E-19  -3.70163929884110E-01  -3.70163929884509E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98391562970744E-10   0.00000000000000E+00   3.98391562970744E-10
      2.29988603084346E-18  -1.38088894567617E-02  -9.62488827916090E-03   0.00000000000000E+00  -1.76922732334734E-13
     -1.98434542823832E-23  -1.32795517271491E-08  -1.32797286498815E-08  -1.74067836086176E-18
      4.21449071874999E-07
      0.00000000000000E+00  -3.24753806292094E-12   0.00000000000000E+00  -2.42132177356319E-13  -1.93295921010385E-23
      3.24775942777027E-09   3.24751729559290E-09  -8.26748270109670E-19  -2.50220955484543E-01  -2.50220955484952E-01
      0.00000000000000E+00   0.00000000000000E+00   4.08614579930875E-10   0.00000000000000E+00   4.08614579930875E-10
      3.11711519070521E-18  -3.76793382171906E-02  -3.65274257691447E-02   0.00000000000000E+00  -3.39481452372570E-13
     -7.68844170393801E-23  -3.65579239407132E-09  -3.65613187552377E-09  -2.29036692059555E-18
      4.23449071874999E-07
      0.00000000000000E+00  -5.03309159897247E-14   0.00000000000000E+00  -8.58012308940822E-14  -4.35114581663395E-23
      5.04626187188404E-11   5.03768174879028E-11  -1.08461731206631E-18  -1.25182099998119E-01  -1.25182099998496E-01
      0.00000000000000E+00   0.00000000000000E+00   3.76711673671132E-10   0.00000000000000E+00   3.76711673671132E-10
      3.87053853804748E-18  -6.73767553513670E-02  -6.72421967787014E-02   0.00000000000000E+00  -1.01345450748015E-12
     -9.24225743838826E-23  -4.26075036651462E-10  -4.27088491159034E-10  -2.78592122598117E-18
      4.25449071874999E-07
      0.00000000000000E+00   7.38431687148515E-14   0.00000000000000E+00  -8.86668653312680E-15  -4.60021245607326E-23
     -7.38711815131975E-11  -7.38800481997767E-11  -1.24141976073034E-18  -4.66688925797216E-02  -4.66688925799684E-02
      0.00000000000000E+00   0.00000000000000E+00   2.46774609322374E-10   0.00000000000000E+00   2.46774609322374E-10
      4.36408775669222E-18  -9.69711452108352E-02  -9.69166730772448E-02   0.00000000000000E+00  -1.14733008731462E-12
     -1.02036163235535E-22  -1.71747231035181E-10  -1.72894561122598E-10  -3.12266799596189E-18
      4.26449071874999E-07
      0.00000000000000E+00   4.37180949107827E-14   0.00000000000000E+00  -1.28787981177428E-15  -4.63650526163371E-23
     -4.36875628843905E-11  -4.36888507642487E-11  -1.28295346112404E-18  -2.64225895194154E-02  -2.64225895195799E-02
      0.00000000000000E+00   0.00000000000000E+00   1.64478472302022E-10   0.00000000000000E+00   1.64478472302022E-10
      4.52856622899424E-18  -1.11667338925423E-01  -1.11629283160808E-01   0.00000000000000E+00  -8.38106059071718E-13
     -1.04845113610028E-22  -1.19951515478597E-10  -1.20789621537773E-10  -3.24561276787021E-18
      4.27799071874999E-07
      0.00000000000000E+00   1.56136053252795E-14   0.00000000000000E+00   6.03608539991280E-16  -4.64272351901112E-23
     -1.56227252134633E-11  -1.56221216049697E-11  -1.30705434471338E-18  -1.56580283177374E-02  -1.56580283178450E-02
      0.00000000000000E+00   0.00000000000000E+00   1.07625376497549E-10   0.00000000000000E+00   1.07625376497549E-10
      4.67386048726594E-18  -1.31269533271625E-01  -1.31240547151399E-01   0.00000000000000E+00  -5.34362498588782E-13
     -1.07072420488668E-22  -9.14688923938838E-11  -9.20032548925797E-11  -3.36680614255256E-18
      4.29621571874999E-07
      0.00000000000000E+00  -6.06175265569677E-15   0.00000000000000E+00   9.94325190236639E-16  -4.61944817301419E-23
      6.10380243633454E-12   6.10479676147858E-12  -1.31808700994770E-18  -1.10302673295150E-02  -1.10302673295885E-02
      0.00000000000000E+00   0.00000000000000E+00   7.35171049702374E-11   0.00000000000000E+00   7.35171049702374E-11
      4.80784541107420E-18  -1.57256956980163E-01  -1.57231871882201E-01   0.00000000000000E+00  -4.19501516104809E-13
     -1.09297862102669E-22  -7.92024002155013E-11  -7.96219017317154E-11  -3.48975840112649E-18
      4.31621571874999E-07
      0.00000000000000E+00  -2.17672027181838E-14   0.00000000000000E+00   8.62723867630755E-16  -4.55138742665772E-23
      2.18114293975280E-11   2.18122921213501E-11  -1.32083709942366E-18  -9.34355458798297E-03  -9.34355458803821E-03
      0.00000000000000E+00   0.00000000000000E+00   5.52339437661487E-11   0.00000000000000E+00   5.52339437661487E-11
      4.91831329860649E-18  -1.85190594006495E-01  -1.85166320561489E-01   0.00000000000000E+00  -4.09604146262545E-13
     -1.11575497239530E-22  -7.66366317411249E-11  -7.70462358874990E-11  -3.59747619918284E-18
      4.33621571874999E-07
      0.00000000000000E+00  -3.38907080295774E-14   0.00000000000000E+00   6.71262489457033E-16  -4.40108602961467E-23
      3.39014798293393E-11   3.39021510917847E-11  -1.31989693753182E-18  -8.62986492217836E-03  -8.62986492222302E-03
      0.00000000000000E+00   0.00000000000000E+00   4.46593953714362E-11   0.00000000000000E+00   4.46593953714362E-11
      5.00763208934937E-18  -2.12545755752448E-01  -2.12521005092962E-01   0.00000000000000E+00  -4.27460369935506E-13
     -1.13864738439016E-22  -7.81340860931719E-11  -7.85615464632213E-11  -3.68773515181754E-18
      4.35621571874999E-07
      0.00000000000000E+00  -4.40854738596128E-14   0.00000000000000E+00   5.23695998485526E-16  -4.11412767638333E-23
      4.40692728577132E-11   4.40697965536705E-11  -1.31743786202780E-18  -8.23448886654866E-03  -8.23448886658647E-03
      0.00000000000000E+00   0.00000000000000E+00   3.78121068243199E-11   0.00000000000000E+00   3.78121068243199E-11
      5.08325630299800E-18  -2.39336483626501E-01  -2.39310687100261E-01   0.00000000000000E+00  -4.48089288804471E-13
     -1.16189133579096E-22  -8.14338140890700E-11  -8.18819033779907E-11  -3.76581844097020E-18
      4.37621571874999E-07
      0.00000000000000E+00  -5.30862581059505E-14   0.00000000000000E+00   4.24008379267601E-16  -3.62937555096399E-23
      5.30854503820510E-11   5.30858743903940E-11  -1.31440511657757E-18  -7.97236770781202E-03  -7.97236770784512E-03
      0.00000000000000E+00   0.00000000000000E+00   3.30954657348812E-11   0.00000000000000E+00   3.30954657348812E-11
      5.14944723446777E-18  -2.65577258970766E-01  -2.65550108156015E-01   0.00000000000000E+00  -4.66797220691888E-13
     -1.18543121163822E-22  -8.57145429044638E-11  -8.61813401252743E-11  -3.83504211789020E-18
      4.39621571874999E-07
      0.00000000000000E+00  -6.13522844546279E-14   0.00000000000000E+00   3.58498894897603E-16  -2.88692531019774E-23
      6.13496961795095E-11   6.13500546783755E-11  -1.31124080313107E-18  -7.78147777862536E-03  -7.78147777865507E-03
      0.00000000000000E+00   0.00000000000000E+00   2.97110986425997E-11   0.00000000000000E+00   2.97110986425997E-11
      5.20886943175297E-18  -2.91278000973458E-01  -2.91249313061503E-01   0.00000000000000E+00  -4.83926311098443E-13
     -1.20920945800422E-22  -9.05772270097566E-11  -9.10611533209760E-11  -3.89762862862189E-18
      4.41621571874999E-07
      0.00000000000000E+00  -6.90672423800601E-14   0.00000000000000E+00   3.15341269658591E-16  -1.84192048947103E-23
      6.91055915035536E-11   6.91059068448049E-11  -1.30814985638382E-18  -7.63494947968597E-03  -7.63494947971315E-03
      0.00000000000000E+00   0.00000000000000E+00   2.71846960410962E-11   0.00000000000000E+00   2.71846960410962E-11
      5.26323882383516E-18  -3.16442377871624E-01  -3.16412042747033E-01   0.00000000000000E+00  -5.00794280735213E-13
     -1.23321611625478E-22  -9.57898086050417E-11  -9.62906028859002E-11  -3.95508896745134E-18
      4.43621571874999E-07
      0.00000000000000E+00  -7.65066660938698E-14   0.00000000000000E+00   2.86624891858340E-16  -4.84129569408330E-24
      7.65199178673844E-11   7.65202044922714E-11  -1.30521800181331E-18  -7.51827550132554E-03  -7.51827550135076E-03
      0.00000000000000E+00   0.00000000000000E+00   2.52188930389030E-11   0.00000000000000E+00   2.52188930389030E-11
      5.31367660991297E-18  -3.41077444426207E-01  -3.41045393115905E-01   0.00000000000000E+00  -5.18890487311731E-13
     -1.25750033406078E-22  -1.01220207043738E-10  -1.01739097531175E-10  -4.00845860809966E-18
      4.45621571874999E-07
      0.00000000000000E+00  -8.36705555960569E-14   0.00000000000000E+00   2.67676666946930E-16   1.11928126512746E-23
      8.37153674905865E-11   8.37156351672646E-11  -1.30246442298640E-18  -7.42638431262399E-03  -7.42638431264760E-03
      0.00000000000000E+00   0.00000000000000E+00   2.36052883762192E-11   0.00000000000000E+00   2.36052883762192E-11
      5.36088718666540E-18  -3.65183841011603E-01  -3.65150031547994E-01   0.00000000000000E+00  -5.39019481562400E-13
     -1.28213237697441E-22  -1.06781904061793E-10  -1.07320923543484E-10  -4.05842276367900E-18
      4.47621571874999E-07
      0.00000000000000E+00  -9.08344450982440E-14   0.00000000000000E+00   2.58320176106767E-16   2.81382578299788E-23
      9.08363194260395E-11   9.08365777462437E-11  -1.29984093808298E-18  -7.37595931324431E-03  -7.37595931326649E-03
      0.00000000000000E+00   0.00000000000000E+00   2.21797015001658E-11   0.00000000000000E+00   2.21797015001658E-11
      5.40524658966574E-18  -3.88761355713840E-01  -3.88725752371621E-01   0.00000000000000E+00  -5.61292654033444E-13
     -1.30716869801183E-22  -1.12454986592245E-10  -1.13016279246409E-10  -4.10540565158276E-18
      4.49621571874999E-07
      0.00000000000000E+00  -9.79064898632235E-14   0.00000000000000E+00   2.48888142871470E-16   4.49762276047990E-23
      9.78621575542739E-11   9.78624064424617E-11  -1.29737289425798E-18  -7.33903248247930E-03  -7.33903248250035E-03
      0.00000000000000E+00   0.00000000000000E+00   2.10545948870132E-11   0.00000000000000E+00   2.10545948870132E-11
      5.44735577943976E-18  -4.11962518361761E-01  -4.11925056485134E-01   0.00000000000000E+00  -5.92554617517295E-13
     -1.33293948486161E-22  -1.18324446711824E-10  -1.18917001329474E-10  -4.14998288518178E-18
      4.50621571874999E-07
      0.00000000000000E+00  -1.01396589877110E-13   0.00000000000000E+00   2.46594378835185E-16   5.35404342529041E-23
      1.01395035503965E-10   1.01395282098398E-10  -1.29617779323748E-18  -7.32327489942954E-03  -7.32327489945004E-03
      0.00000000000000E+00   0.00000000000000E+00   2.04935797587876E-11   0.00000000000000E+00   2.04935797587876E-11
      5.46784935919855E-18  -4.23482072366596E-01  -4.23443674463389E-01   0.00000000000000E+00  -6.19284343344011E-13
     -1.34613311904367E-22  -1.21269577513707E-10  -1.21888861857186E-10  -4.17167156596107E-18
      4.51971571874999E-07
      0.00000000000000E+00  -1.06080671474693E-13   0.00000000000000E+00   2.41140462253630E-16   6.42786260335012E-23
      1.06112579293060E-10   1.06112820433586E-10  -1.29462960638925E-18  -7.30654207412961E-03  -7.30654207414940E-03
      0.00000000000000E+00   0.00000000000000E+00   1.97954164819415E-11   0.00000000000000E+00   1.97954164819415E-11
      5.49457317144917E-18  -4.38846492781654E-01  -4.38806828954355E-01   0.00000000000000E+00  -6.40829091806573E-13
     -1.36425776990769E-22  -1.25267407823585E-10  -1.25908236915528E-10  -4.19994356505992E-18
      4.53794071874999E-07
      0.00000000000000E+00  -1.12417958342013E-13   0.00000000000000E+00   2.35167186867264E-16   7.70222068819879E-23
      1.12401947206140E-10   1.12402182373404E-10  -1.29264359738763E-18  -7.29329537763432E-03  -7.29329537765322E-03
      0.00000000000000E+00   0.00000000000000E+00   1.88910993532749E-11   0.00000000000000E+00   1.88910993532749E-11
      5.52900220002051E-18  -4.59217471426982E-01  -4.59176111595233E-01   0.00000000000000E+00  -6.70150431213861E-13
     -1.38921606981396E-22  -1.30623131295326E-10  -1.31293281726678E-10  -4.23635860263288E-18
      4.55794071874999E-07
      0.00000000000000E+00  -1.19214468895370E-13   0.00000000000000E+00   2.30513315037197E-16   8.89299457672989E-23
      1.19247871124268E-10   1.19248101637672E-10  -1.29056902972949E-18  -7.29288249208432E-03  -7.29288249210225E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79264294279236E-11   0.00000000000000E+00   1.79264294279236E-11
      5.56485505887636E-18  -4.81120692781556E-01  -4.81077480725270E-01   0.00000000000000E+00  -7.07046873074207E-13
     -1.41716307855987E-22  -1.36467484192379E-10  -1.37174531065595E-10  -4.27428602914687E-18
      4.57794071874999E-07
      0.00000000000000E+00  -1.26102824185934E-13   0.00000000000000E+00   2.27709566332869E-16   9.88461825267592E-23
      1.26072446249972E-10   1.26072673959637E-10  -1.28857437148554E-18  -7.31210100942204E-03  -7.31210100943903E-03
      0.00000000000000E+00   0.00000000000000E+00   1.69886163917411E-11   0.00000000000000E+00   1.69886163917411E-11
      5.59883229165984E-18  -5.02578000951354E-01  -5.02532934998346E-01   0.00000000000000E+00  -7.47136293754735E-13
     -1.44555632895147E-22  -1.42314154057480E-10  -1.43061290351379E-10  -4.31025792017431E-18
      4.59794071874999E-07
      0.00000000000000E+00  -1.32899334739291E-13   0.00000000000000E+00   2.27482077968679E-16   1.06982512290206E-22
      1.32925369985468E-10   1.32925597467653E-10  -1.28662435142493E-18  -7.36128103247754E-03  -7.36128103249363E-03
      0.00000000000000E+00   0.00000000000000E+00   1.60809102487974E-11   0.00000000000000E+00   1.60809102487974E-11
      5.63099411215744E-18  -5.23598347688102E-01  -5.23551409492195E-01   0.00000000000000E+00  -7.87484909254438E-13
     -1.47420171277119E-22  -1.48219022807048E-10  -1.49006507716450E-10  -4.34436976073251E-18
      4.61794071874999E-07
      0.00000000000000E+00  -1.40338758453101E-13   0.00000000000000E+00   2.51267146033434E-16   1.13953609172872E-22
      1.40360657350810E-10   1.40360908618070E-10  -1.28447245384634E-18  -7.54928362272598E-03  -7.54928362274102E-03
      0.00000000000000E+00   0.00000000000000E+00   1.50351152497024E-11   0.00000000000000E+00   1.50351152497024E-11
      5.66106434265685E-18  -5.44190437004008E-01  -5.44141486686020E-01   0.00000000000000E+00  -8.22005142608732E-13
     -1.50271752913850E-22  -1.54574018725014E-10  -1.55396023867773E-10  -4.37659188881049E-18
      4.63794071874999E-07
      0.00000000000000E+00  -1.49431387436646E-13   0.00000000000000E+00   3.19738906301319E-16   1.20643000303481E-22
      1.49436725754813E-10   1.49437045493840E-10  -1.28164516507890E-18  -8.08276493246650E-03  -8.08276493248017E-03
      0.00000000000000E+00   0.00000000000000E+00   1.36718839862704E-11   0.00000000000000E+00   1.36718839862704E-11
      5.68840811062939E-18  -5.64361178397534E-01  -5.64309799176743E-01   0.00000000000000E+00  -8.43752712901302E-13
     -1.53057622514113E-22  -1.62265176767056E-10  -1.63108929480110E-10  -4.40676294555048E-18
      4.65794071874999E-07
      0.00000000000000E+00  -1.68075869089774E-13   0.00000000000000E+00   7.10131047082844E-16   1.31811788195891E-22
      1.68100910523162E-10   1.68101620654341E-10  -1.27507568720309E-18  -1.03590681607845E-02  -1.03590681607943E-02
      0.00000000000000E+00   0.00000000000000E+00   9.85254178037051E-12   0.00000000000000E+00   9.85254178037051E-12
      5.70811319419013E-18  -5.84105992829110E-01  -5.84049938205112E-01   0.00000000000000E+00  -7.90456236021125E-13
     -1.55545913046924E-22  -1.77163706198535E-10  -1.77954162434712E-10  -4.43303750698703E-18
      4.67794071874999E-07
      0.00000000000000E+00  -2.79024311636466E-13   0.00000000000000E+00   4.07507800875765E-15   1.87058724590713E-22
      2.78991199959615E-10   2.78995275037810E-10  -1.24014194436057E-18  -2.54119082493824E-02  -2.54119082493681E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.42974843756479E-11   0.00000000000000E+00  -1.42974843756479E-11
      5.67951822543883E-18  -6.03294674898540E-01  -6.03211297940687E-01   0.00000000000000E+00  -1.66848083055092E-13
     -1.56051828022692E-22  -2.64530942578952E-10  -2.64697790662163E-10  -4.43937628107826E-18
      4.69794071874999E-07
      0.00000000000000E+00  -6.22064405106579E-13   0.00000000000000E+00   1.06695137936832E-14   2.82306055956139E-22
      6.22079966893469E-10   6.22090636407545E-10  -1.17062865540920E-18  -5.43072300131230E-02  -5.43072300130780E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.49990979277007E-11   0.00000000000000E+00  -4.49990979277007E-11
      5.58952002958343E-18  -6.21501505883636E-01  -6.21319727958658E-01   0.00000000000000E+00   4.93831830923795E-13
     -1.54516438930456E-22  -5.77585370310612E-10  -5.77091538479843E-10  -4.41889137417422E-18
      4.71794071874999E-07
      0.00000000000000E+00  -1.30355235518643E-12   0.00000000000000E+00   1.86918440079289E-14   3.43882615254164E-22
      1.30352080847779E-09   1.30353950032214E-09  -1.09617155641526E-18  -8.40496577836834E-02  -8.40496577836275E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.59308379724832E-11   0.00000000000000E+00  -5.59308379724832E-11
      5.47765835363846E-18  -6.38052307034555E-01  -6.37659319544826E-01   0.00000000000000E+00   4.74018793895764E-13
     -1.52991253731615E-22  -1.24808268114340E-09  -1.24760866234966E-09  -4.38148679722320E-18
      4.73794071874999E-07
      0.00000000000000E+00  -2.56678487073875E-12   0.00000000000000E+00   3.27548020308454E-14   3.84669405109566E-22
      2.56678158034838E-09   2.56681433515080E-09  -1.02518729758569E-18  -1.13399630458717E-01  -1.13399630458651E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.62797966928109E-11   0.00000000000000E+00  -6.62797966928109E-11
      5.34509876025284E-18  -6.51851307623246E-01  -6.51063652202052E-01   0.00000000000000E+00   3.88430040004067E-13
     -1.51682229813360E-22  -2.50092296849784E-09  -2.50053453845799E-09  -4.31991146266715E-18
      4.75794071874999E-07
      0.00000000000000E+00  -4.68747985286054E-12   0.00000000000000E+00   5.36808405953959E-14   4.17106899858848E-22
      4.68746084256004E-09   4.68751452340106E-09  -9.61119474865544E-19  -1.42219007930288E-01  -1.42219007930209E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.94392096590929E-11   0.00000000000000E+00  -7.94392096590929E-11
      5.18622034093466E-18  -6.61296711263830E-01  -6.59845183329515E-01   0.00000000000000E+00   2.90668965741139E-13
     -1.50637934039519E-22  -4.60836598270756E-09  -4.60807531374196E-09  -4.22510086606911E-18
      4.75919071874999E-07
      0.00000000000000E+00  -4.86336252461296E-12   0.00000000000000E+00   7.06872929186602E-14   4.20371680035180E-22
      4.86329527952279E-09   4.86336596681612E-09  -9.57137823981030E-19  -1.44018054804102E-01  -1.44018054804021E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.10464743806371E-11   0.00000000000000E+00  -8.10464743806371E-11
      5.17608953163708E-18  -6.61864798575780E-01  -6.60358383801091E-01   0.00000000000000E+00   2.66059604982256E-13
     -1.50575447298967E-22  -4.78258555204032E-09  -4.78231949243549E-09  -4.21895170765604E-18
      4.76087821874999E-07
      0.00000000000000E+00  -5.10776137032219E-12   0.00000000000000E+00   7.27423964064104E-14   4.25585208696142E-22
      5.10773736743797E-09   5.10781010983480E-09  -9.51850754989567E-19  -1.46442801620884E-01  -1.46442801620802E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.25580204023850E-11   0.00000000000000E+00  -8.25580204023850E-11
      5.16215786569417E-18  -6.62589992239460E-01  -6.61007053791221E-01   0.00000000000000E+00   2.51629068080346E-13
     -1.50494790279815E-22  -5.02550371850033E-09  -5.02525208943241E-09  -4.21030711070461E-18
      4.76315634374999E-07
      0.00000000000000E+00  -5.45116884274113E-12   0.00000000000000E+00   7.56188383361571E-14   4.32151331312520E-22
      5.45109141297289E-09   5.45116703181165E-09  -9.44858398414867E-19  -1.49708821785798E-01  -1.49708821785714E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.46517321376464E-11   0.00000000000000E+00  -8.46517321376464E-11
      5.14287314296657E-18  -6.63490145610944E-01  -6.61799709356137E-01   0.00000000000000E+00   2.33406570423430E-13
     -1.50392249490863E-22  -5.36674870624429E-09  -5.36651529967402E-09  -4.19801474455169E-18
      4.76623181249999E-07
      0.00000000000000E+00  -5.93886439731309E-12   0.00000000000000E+00   7.94717454131783E-14   4.39931607179162E-22
      5.93878501283186E-09   5.93886448457771E-09  -9.35653683655668E-19  -1.54104216707138E-01  -1.54104216707051E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.75355785829682E-11   0.00000000000000E+00  -8.75355785829682E-11
      5.11595184932205E-18  -6.64554768092978E-01  -6.62711615642675E-01   0.00000000000000E+00   2.11255124192150E-13
     -1.50264217694644E-22  -5.85154016111878E-09  -5.85132890599473E-09  -4.18029816566638E-18
      4.77038369531249E-07
      0.00000000000000E+00  -6.64101741326464E-12   0.00000000000000E+00   8.46481846466199E-14   4.48570894575686E-22
      6.64101016003122E-09   6.64109480821632E-09  -9.23600730788706E-19  -1.60012591899140E-01  -1.60012591899049E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.14573940996379E-11   0.00000000000000E+00  -9.14573940996379E-11
      5.07797981105822E-18  -6.65700796119254E-01  -6.63637676492954E-01   0.00000000000000E+00   1.86709648245154E-13
     -1.50106749279088E-22  -6.54982412376478E-09  -6.54963741411668E-09  -4.15437908026952E-18
      4.77598873710936E-07
      0.00000000000000E+00  -7.66912740156569E-12   0.00000000000000E+00   9.16450977082027E-14   4.57265122991550E-22
      7.66899417750053E-09   7.66908582259869E-09  -9.07909809900945E-19  -1.67942204074613E-01  -1.67942204074517E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.66774926103650E-11   0.00000000000000E+00  -9.66774926103650E-11
      5.02379167236840E-18  -6.66676042677227E-01  -6.64290749892081E-01   0.00000000000000E+00   1.65481117079481E-13
     -1.49911134921752E-22  -7.57257381110526E-09  -7.57240832998833E-09  -4.11588186246746E-18
      4.78355554353514E-07
      0.00000000000000E+00  -9.20440402872671E-12   0.00000000000000E+00   1.01213819381544E-13   4.64665200242762E-22
      9.20436551631974E-09   9.20446673013959E-09  -8.87600784319604E-19  -1.78562070090546E-01  -1.78562070090443E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03391377295933E-10   0.00000000000000E+00  -1.03391377295933E-10
      4.94555741855908E-18  -6.66848326447737E-01  -6.63981502042070E-01   0.00000000000000E+00   1.65114846185227E-13
     -1.49644106755055E-22  -9.10124046768968E-09  -9.10107535284364E-09  -4.05795663423948E-18
      4.79377073220995E-07
      0.00000000000000E+00  -1.15559048354510E-11   0.00000000000000E+00   1.14598051996569E-13   4.68910096050800E-22
      1.15558059231309E-08   1.15559205211833E-08  -8.61429280206533E-19  -1.92745147605855E-01  -1.92745147605744E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11573800481079E-10   0.00000000000000E+00  -1.11573800481079E-10
      4.83158267625116E-18  -6.64736877776664E-01  -6.61131916766504E-01   0.00000000000000E+00   2.18163622767080E-13
     -1.49176242300452E-22  -1.14445648843249E-08  -1.14443467207022E-08  -3.97015339604462E-18
      4.80756123692094E-07
      0.00000000000000E+00  -1.52794741713186E-11   0.00000000000000E+00   1.34107695946945E-13   4.67647943234618E-22
      1.52793541166315E-08   1.52794882243280E-08  -8.27720689765997E-19  -2.11617119985526E-01  -2.11617119985405E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20761795539493E-10   0.00000000000000E+00  -1.20761795539493E-10
      4.66504606522170E-18  -6.56930824949774E-01  -6.52155809039323E-01   0.00000000000000E+00   4.10269307476319E-13
     -1.48056843592864E-22  -1.51591366980958E-08  -1.51587264287885E-08  -3.83732537545570E-18
      4.82617841828077E-07
      0.00000000000000E+00  -2.14566756616852E-11   0.00000000000000E+00   1.64743425727531E-13   4.57645540146066E-22
      2.14565406652988E-08   2.14567054087249E-08  -7.84034584201158E-19  -2.36605806226180E-01  -2.36605806226050E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.30051703438659E-10   0.00000000000000E+00  -1.30051703438659E-10
      4.42292645031445E-18  -6.35437890702003E-01  -6.28719870491603E-01   0.00000000000000E+00   8.72925055458656E-13
     -1.44893530245301E-22  -2.13275266303416E-08  -2.13266537052863E-08  -3.63889186611329E-18
      4.84617841828077E-07
      0.00000000000000E+00  -2.99001460426475E-11   0.00000000000000E+00   2.09487979010040E-13   4.38886190921509E-22
      2.98999701227327E-08   2.99001796107122E-08  -7.38130657730436E-19  -2.62900926445987E-01  -2.62900926445849E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.37654086510877E-10   0.00000000000000E+00  -1.37654086510877E-10
      4.14761827729269E-18  -5.96433020329817E-01  -5.87057397809241E-01   0.00000000000000E+00   1.51734285432608E-12
     -1.38621184746714E-22  -2.97640428670555E-08  -2.97625255242013E-08  -3.40948761956226E-18
      4.86617841828077E-07
      0.00000000000000E+00  -4.04475038188227E-11   0.00000000000000E+00   2.61765726567370E-13   4.08837509632787E-22
      4.04473301177085E-08   4.04475918834355E-08  -6.92630774386882E-19  -2.88656282301093E-01  -2.88656282300948E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.45147754413235E-10   0.00000000000000E+00  -1.45147754413235E-10
      3.85732276846623E-18  -5.37712692787943E-01  -5.25016373590317E-01   0.00000000000000E+00   2.05370707607025E-12
     -1.29059606461976E-22  -4.03044978360982E-08  -4.03024441290222E-08  -3.16469199407934E-18
      4.88617841828077E-07
      0.00000000000000E+00  -5.27345846071828E-11   0.00000000000000E+00   3.05284731970391E-13   3.54773873570549E-22
      5.27343211586373E-08   5.27346264433697E-08  -6.47529997779659E-19  -3.13875325944339E-01  -3.13875325944183E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.55919794598963E-10   0.00000000000000E+00  -1.55919794598963E-10
      3.54548317926830E-18  -4.56214562711462E-01  -4.39650235839555E-01   0.00000000000000E+00   2.16299106942907E-12
     -1.17504074812591E-22  -5.25808696398400E-08  -5.25787066487707E-08  -2.89795318148864E-18
      4.90617841828077E-07
      0.00000000000000E+00  -6.55569365239884E-11   0.00000000000000E+00   3.19146978555507E-13   2.77887737097550E-22
      6.55565749317168E-08   6.55568940786956E-08  -6.02948294652566E-19  -3.38563700143190E-01  -3.38563700143021E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.68950439791093E-10   0.00000000000000E+00  -1.68950439791093E-10
      3.20758229968611E-18  -3.51220939520979E-01  -3.30620445630857E-01   0.00000000000000E+00   1.91952777810887E-12
     -1.05145953385491E-22  -6.53898631666826E-08  -6.53879436389046E-08  -2.60463400503355E-18
      4.92617841828077E-07
      0.00000000000000E+00  -7.59094916125464E-11   0.00000000000000E+00   2.58224331895512E-13   2.14045521953219E-22
      7.59092154481163E-08   7.59094736724484E-08  -5.59081226369116E-19  -3.62724956601295E-01  -3.62724956601110E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.85337425428690E-10   0.00000000000000E+00  -1.85337425428690E-10
      2.83690744882873E-18  -2.28033778221655E-01  -2.04176138874713E-01   0.00000000000000E+00   1.43524087035437E-12
     -9.05425319249342E-23  -7.57255714878900E-08  -7.57241362470197E-08  -2.27782622245961E-18
      4.94617841828077E-07
      0.00000000000000E+00  -7.68385929741378E-11   0.00000000000000E+00   2.36288440838815E-14   1.05436398229697E-22
      7.68385668819721E-08   7.68385905108163E-08  -5.16230786950925E-19  -3.86352002470713E-01  -3.86352002470503E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.10498137854935E-10   0.00000000000000E+00  -2.10498137854935E-10
      2.41591117311886E-18  -1.05396855684958E-01  -8.12540051772751E-02   0.00000000000000E+00   8.56128941661201E-13
     -7.30738532387623E-23  -7.66289485019030E-08  -7.66280923729614E-08  -1.89968038616794E-18
      4.96617841828077E-07
      0.00000000000000E+00  -4.91750499719679E-11   0.00000000000000E+00  -6.87184782707794E-13   2.88028187301799E-23
      4.91757344687744E-08   4.91750472839918E-08  -4.64129707952045E-19  -4.09584873293593E-01  -4.09584873293424E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.69384041884187E-10   0.00000000000000E+00  -1.69384041884187E-10
      2.07714308935049E-18  -3.90442251379632E-02  -2.36041508473228E-02   0.00000000000000E+00   9.63887762788712E-13
     -2.73876430369304E-23  -4.90066271298704E-08  -4.90056632421076E-08  -1.61301338139845E-18
      4.98617841828077E-07
      0.00000000000000E+00  -2.68266537567349E-11   0.00000000000000E+00  -5.52759146120931E-13   1.00834572684694E-23
      2.68272300274451E-08   2.68266772682990E-08  -4.06380320245875E-19  -4.32455869788167E-01  -4.32455869788051E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15668732970364E-10   0.00000000000000E+00  -1.15668732970364E-10
      1.84580562340976E-18  -1.75090988369097E-02  -9.09332045453695E-03   0.00000000000000E+00   6.41644283463954E-13
     -1.07791869064644E-23  -2.67116501796121E-08  -2.67110085353286E-08  -1.43942530316389E-18
      5.00617841828077E-07
      0.00000000000000E+00  -1.91761708368223E-11   0.00000000000000E+00  -1.88541117761783E-13   5.58913993311532E-24
      1.91763635101900E-08   1.91761749690722E-08  -3.50690199861771E-19  -4.54895427341521E-01  -4.54895427341419E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01097177547862E-10   0.00000000000000E+00  -1.01097177547862E-10
      1.64361126831404E-18  -1.12842544955215E-02  -5.27430495401773E-03   0.00000000000000E+00   2.39606478926421E-13
     -6.21685379521762E-24  -1.90753173980033E-08  -1.90750777915244E-08  -1.29292106845226E-18
      5.02617841828077E-07
      0.00000000000000E+00  -1.70257181598453E-11   0.00000000000000E+00  -5.27048530558505E-14   4.16223632939382E-24
      1.70258040473623E-08   1.70257513425092E-08  -2.97632854157596E-19  -4.76885515341269E-01  -4.76885515341169E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00057722267024E-10   0.00000000000000E+00  -1.00057722267024E-10
      1.44349582377999E-18  -9.35712263560412E-03  -4.02437103979105E-03   0.00000000000000E+00   9.21533883173110E-14
     -4.62504887717246E-24  -1.69257857736305E-08  -1.69256936202422E-08  -1.14586296962239E-18
      5.04617841828077E-07
      0.00000000000000E+00  -1.64372689285566E-11   0.00000000000000E+00  -1.41944023894589E-14   3.51194764711616E-24
      1.64373182461199E-08   1.64373040517175E-08  -2.47112231906191E-19  -4.98428872803795E-01  -4.98428872803693E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02111620223343E-10   0.00000000000000E+00  -1.02111620223343E-10
      1.23927258333330E-18  -8.60417610933351E-03  -3.45746918920092E-03   0.00000000000000E+00   4.77699417804539E-14
     -3.84958858873986E-24  -1.63352402014359E-08  -1.63351924314941E-08  -9.92160351427111E-19
      5.06617841828077E-07
      0.00000000000000E+00  -1.62579880015276E-11   0.00000000000000E+00  -4.12911633549156E-15   3.11918716388793E-24
      1.62579637395979E-08   1.62579596104815E-08  -1.99032132252179E-19  -5.19533629548760E-01  -5.19533629548655E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04439208383693E-10   0.00000000000000E+00  -1.04439208383693E-10
      1.03039416656592E-18  -8.20861352619149E-03  -3.11914271670304E-03   0.00000000000000E+00   3.36662896547867E-14
     -3.35781959934494E-24  -1.61535540683875E-08  -1.61535204020979E-08  -8.31362034313738E-19
      5.08617841828077E-07
      0.00000000000000E+00  -1.61883696907242E-11   0.00000000000000E+00  -1.44904478303256E-15   2.84329858416401E-24
      1.61883823098703E-08   1.61883808608255E-08  -1.53269561676356E-19  -5.40208565351004E-01  -5.40208565350897E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06349185887108E-10   0.00000000000000E+00  -1.06349185887108E-10
      8.17695794791699E-19  -7.95168335519311E-03  -2.88473403446944E-03   0.00000000000000E+00   2.78640355029678E-14
     -3.00310830204114E-24  -1.60820595389739E-08  -1.60820316749384E-08  -6.64426233115343E-19
      5.10617841828077E-07
      0.00000000000000E+00  -1.61529176221621E-11   0.00000000000000E+00  -6.31226712010078E-16   2.63467380798944E-24
      1.61529062502176E-08   1.61529056189909E-08  -1.09672290654817E-19  -5.60461174734262E-01  -5.60461174734154E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07709184843743E-10   0.00000000000000E+00  -1.07709184843743E-10
      6.02277425104212E-19  -7.76535941396215E-03  -2.71001388598259E-03   0.00000000000000E+00   2.45303058524151E-14
     -2.73186978667981E-24  -1.60452209644530E-08  -1.60451964341472E-08  -4.92605134449395E-19
      5.12617841828077E-07
      0.00000000000000E+00  -1.61310585747068E-11   0.00000000000000E+00  -3.15563012058688E-16   2.47021874130754E-24
      1.61310302151344E-08   1.61310298995714E-08  -6.80874840476189E-20  -5.80291562816954E-01  -5.80291562816846E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08503146985785E-10   0.00000000000000E+00  -1.08503146985785E-10
      3.85271131132644E-19  -7.62217068840318E-03  -2.57396589994807E-03   0.00000000000000E+00   2.21471684113773E-14
     -2.51742734280184E-24  -1.60225488997540E-08  -1.60225267525856E-08  -3.17183647085024E-19
      5.14617841828077E-07
      0.00000000000000E+00  -1.61156286588559E-11   0.00000000000000E+00  -1.74247818921242E-16   2.33717600356795E-24
      1.61155951414346E-08   1.61155949671868E-08  -2.85203704426129E-20  -5.99621071824530E-01  -5.99621071824421E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08345928148375E-10   0.00000000000000E+00  -1.08345928148375E-10
      1.68579274835893E-19  -7.50787962980477E-03  -2.46448685778743E-03   0.00000000000000E+00   2.01870644295531E-14
     -2.34424457900389E-24  -1.60072692261029E-08  -1.60072490390384E-08  -1.40058904393280E-19
      5.16617841828077E-07
      0.00000000000000E+00  -1.60983618482609E-11   0.00000000000000E+00  -2.37361426108717E-16   2.23211741701675E-24
      1.60983573839485E-08   1.60983571465870E-08   8.44632290944659E-21  -6.18075138406145E-01  -6.18075138406040E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05542708561257E-10   0.00000000000000E+00  -1.05542708561257E-10
     -4.25061422866215E-20  -7.42094388532518E-03  -2.38209775072438E-03   0.00000000000000E+00   1.82768727501775E-14
     -2.20868173162685E-24  -1.59928327148985E-08  -1.59928144380258E-08   3.40598193771749E-20
      5.18617841828078E-07
      0.00000000000000E+00  -1.60716350297335E-11   0.00000000000000E+00  -4.93784625751501E-16   2.15729557248442E-24
      1.60716192238527E-08   1.60716187300681E-08   4.18164024815238E-20  -6.35044326695483E-01  -6.35044326695384E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.86245766802483E-11   0.00000000000000E+00  -9.86245766802483E-11
     -2.39755295647118E-19  -7.37178897129147E-03  -2.33918657331408E-03   0.00000000000000E+00   1.62050560205027E-14
     -2.11416196150676E-24  -1.59730103584439E-08  -1.59729941533879E-08   1.97938893165595E-19
      5.20617841828078E-07
      0.00000000000000E+00  -1.60510618085990E-11   0.00000000000000E+00  -3.70041872098352E-16   2.09896040620500E-24
      1.60510729096619E-08   1.60510725396200E-08   6.98702942401434E-20  -6.49535788317168E-01  -6.49535788317083E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.53570946258265E-11   0.00000000000000E+00  -8.53570946258265E-11
     -4.10469484898771E-19  -7.33567022232872E-03  -2.30536027318840E-03   0.00000000000000E+00   1.31281579065023E-14
     -2.04132257938863E-24  -1.59657285731521E-08  -1.59657154449942E-08   3.40599190658627E-19
      5.22617841828078E-07
      0.00000000000000E+00  -1.60224980953275E-11   0.00000000000000E+00  -6.08660844356862E-16   2.05780885104634E-24
      1.60224789416716E-08   1.60224783330108E-08   8.99936365697920E-20  -6.60051947870587E-01  -6.60051947870524E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.25483205663053E-11   0.00000000000000E+00  -6.25483205663053E-11
     -5.35566126031382E-19  -7.30957990082726E-03  -2.28109216648619E-03   0.00000000000000E+00   9.29314920658325E-15
     -1.99189045037838E-24  -1.59599393055937E-08  -1.59599300124445E-08   4.45572489461590E-19
      5.24617841828078E-07
      0.00000000000000E+00  -1.59809842741097E-11   0.00000000000000E+00  -9.81218381188010E-16   2.03699489767619E-24
      1.59810180928652E-08   1.59810171116468E-08   9.87418480125979E-20  -6.64652886453288E-01  -6.64652886453261E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.75289698517347E-11   0.00000000000000E+00  -2.75289698517347E-11
     -5.90624065734852E-19  -7.29463990342749E-03  -2.26818154498080E-03   0.00000000000000E+00   4.10353002125873E-15
     -1.97039502217370E-24  -1.59534922453251E-08  -1.59534881417950E-08   4.91882217722255E-19
      5.26617841828078E-07
      0.00000000000000E+00  -1.59242242265154E-11   0.00000000000000E+00  -1.43316828758104E-15   2.04200141672970E-24
      1.59242386151440E-08   1.59242371819757E-08   9.19893568457336E-20  -6.61094919988847E-01  -6.61094919988868E-01
      0.00000000000000E+00   0.00000000000000E+00   2.12535038360431E-11   0.00000000000000E+00   2.12535038360431E-11
     -5.48117058062766E-19  -7.29374412249500E-03  -2.26980570825772E-03   0.00000000000000E+00  -2.84281506043977E-15
     -1.98462317342186E-24  -1.59454878429967E-08  -1.59454906858118E-08   4.56127701217031E-19
      5.28617841828078E-07
      0.00000000000000E+00  -1.58498299893773E-11   0.00000000000000E+00  -2.03634261016705E-15   2.08283863638852E-24
      1.58498788818879E-08   1.58498768455453E-08   6.46926883617755E-20  -6.46834606791632E-01  -6.46834606791717E-01
      0.00000000000000E+00   0.00000000000000E+00   8.47102019835091E-11   0.00000000000000E+00   8.47102019835091E-11
     -3.78696654095747E-19  -7.31238531272836E-03  -2.29188307666290E-03   0.00000000000000E+00  -1.20812520426060E-14
     -2.04939726457495E-24  -1.59345749662767E-08  -1.59345870475288E-08   3.14003965733972E-19
      5.30617841828078E-07
      0.00000000000000E+00  -1.57549543758419E-11   0.00000000000000E+00  -2.61255968853092E-15   2.17933827994397E-24
      1.57549318457449E-08   1.57549292331852E-08   1.00476135381229E-20  -6.18863349662514E-01  -6.18863349662677E-01
      0.00000000000000E+00   0.00000000000000E+00   1.63384040436460E-10   0.00000000000000E+00   1.63384040436460E-10
     -5.19285732228274E-20  -7.36077562565834E-03  -2.34540242928592E-03   0.00000000000000E+00  -2.51211967477125E-14
     -2.19628761843972E-24  -1.59182881524249E-08  -1.59183132736216E-08   4.18809596847042E-20
      5.32617841828078E-07
      0.00000000000000E+00  -1.55922055015102E-11   0.00000000000000E+00  -4.01864533792606E-14   2.42407829887461E-24
      1.55922658625071E-08   1.55922256760537E-08  -8.19117283157820E-20  -5.73613894968248E-01  -5.73613894968503E-01
      0.00000000000000E+00   0.00000000000000E+00   2.55184811249912E-10   0.00000000000000E+00   2.55184811249912E-10
      4.58441049276997E-19  -7.54511975156166E-03  -2.55207794629186E-03   0.00000000000000E+00  -8.10929541442684E-15
     -2.57535825309606E-24  -1.58474023780082E-08  -1.58474104873036E-08  -3.76529320961215E-19
      5.34617841828078E-07
      0.00000000000000E+00  -1.53261312978200E-11   0.00000000000000E+00  -7.39785325985430E-15   3.02651932540824E-24
      1.53261624501334E-08   1.53261550522802E-08  -2.26338962021782E-19  -5.07420792222682E-01  -5.07420792223028E-01
      0.00000000000000E+00   0.00000000000000E+00   3.45908248392403E-10   0.00000000000000E+00   3.45908248392403E-10
      1.15025754606180E-18  -8.06708310283169E-03  -3.12930591463940E-03   0.00000000000000E+00  -7.60816034700962E-14
     -3.64267072944927E-24  -1.56719872190691E-08  -1.56720633006726E-08  -9.23918584040021E-19
      5.36617841828078E-07
      0.00000000000000E+00  -1.44102555783865E-11   0.00000000000000E+00  -2.41568095635244E-14   4.74589351683207E-24
      1.44102428150576E-08   1.44102186582480E-08  -4.41289863838992E-19  -4.17919899336426E-01  -4.17919899336823E-01
      0.00000000000000E+00   0.00000000000000E+00   3.96981657995371E-10   0.00000000000000E+00   3.96981657995371E-10
      1.94422086205254E-18  -1.02673537053200E-02  -5.60208357587096E-03   0.00000000000000E+00  -1.36897614700222E-13
     -9.08324517110086E-24  -1.48070634186287E-08  -1.48072003162434E-08  -1.50293099821355E-18
      5.38617841828078E-07
      0.00000000000000E+00  -8.03448576617723E-12   0.00000000000000E+00  -2.82870725494904E-13   2.67298873617515E-25
      8.03466318296025E-09   8.03438031223475E-09  -7.08052911816935E-19  -3.05771830753602E-01  -3.05771830754004E-01
      0.00000000000000E+00   0.00000000000000E+00   4.02190301417315E-10   0.00000000000000E+00   4.02190301417315E-10
      2.74860146488717E-18  -2.48697124629245E-02  -2.22116056151578E-02   0.00000000000000E+00  -1.10713314123449E-13
     -5.30447536629416E-23  -8.43645990033789E-09  -8.43657061365207E-09  -2.04054855307024E-18
      5.40617841828078E-07
      0.00000000000000E+00  -6.09206141897525E-13   0.00000000000000E+00  -1.88797463140456E-13  -3.81890925989052E-23
      6.09369524161984E-10   6.09180726698806E-10  -9.72423002400607E-19  -1.80150570101656E-01  -1.80150570102055E-01
      0.00000000000000E+00   0.00000000000000E+00   3.99512821393719E-10   0.00000000000000E+00   3.99512821393719E-10
      3.54762710767461E-18  -5.36891814127532E-02  -5.33713815499895E-02   0.00000000000000E+00  -6.62455584783492E-13
     -8.68652976449960E-23  -1.00803109250765E-09  -1.00869354809252E-09  -2.57520410527400E-18
      5.41617841828078E-07
      0.00000000000000E+00  -2.09406000833161E-14   0.00000000000000E+00  -3.69659013105662E-14  -4.38927550465659E-23
      2.09438659361376E-11   2.09069000347831E-11  -1.09727115479068E-18  -1.18147211105316E-01  -1.18147211105678E-01
      0.00000000000000E+00   0.00000000000000E+00   3.61867000327832E-10   0.00000000000000E+00   3.61867000327832E-10
      3.90949410800244E-18  -6.85690558585945E-02  -6.84484588857061E-02   0.00000000000000E+00  -1.24909893107413E-12
     -9.31425800776081E-23  -3.81524801431450E-10  -3.82773900362617E-10  -2.81222295321176E-18
      5.42967841828078E-07
      0.00000000000000E+00   7.99967661077558E-14   0.00000000000000E+00  -1.05018657039143E-14  -4.58110367425371E-23
     -7.99938482740847E-11  -8.00043501398344E-11  -1.21904859465674E-18  -5.70530942928923E-02  -5.70530942931665E-02
      0.00000000000000E+00   0.00000000000000E+00   2.74286303124051E-10   0.00000000000000E+00   2.74286303124051E-10
      4.27978061721991E-18  -8.86314900679869E-02  -8.85702794878460E-02   0.00000000000000E+00  -1.26718056829472E-12
     -1.00453597136579E-22  -1.93014772415821E-10  -1.94281952984217E-10  -3.06073202256318E-18
      5.44790341828078E-07
      0.00000000000000E+00   3.83911001527462E-14   0.00000000000000E+00  -1.21040123413056E-15  -4.63805535158741E-23
     -3.83493195682114E-11  -3.83505299694919E-11  -1.28730025515723E-18  -2.41737637264628E-02  -2.41737637266165E-02
      0.00000000000000E+00   0.00000000000000E+00   1.53721807497294E-10   0.00000000000000E+00   1.53721807497294E-10
      4.55993861138373E-18  -1.15355392022637E-01  -1.15319043412296E-01   0.00000000000000E+00  -7.67973355781003E-13
     -1.05251483277192E-22  -1.14603304171916E-10  -1.15371277527802E-10  -3.27263835622650E-18
      5.46790341828078E-07
      0.00000000000000E+00   5.05146054641397E-15   0.00000000000000E+00   7.69834336597604E-16  -4.63377076010773E-23
     -5.08497498442657E-12  -5.08420515013631E-12  -1.31216054927373E-18  -1.32979717832182E-02  -1.32979717833092E-02
      0.00000000000000E+00   0.00000000000000E+00   9.10025560031684E-11   0.00000000000000E+00   9.10025560031684E-11
      4.74194372339007E-18  -1.44139028958882E-01  -1.44111960020382E-01   0.00000000000000E+00  -4.82498198268378E-13
     -1.08169288301056E-22  -8.54358526546554E-11  -8.59183508530320E-11  -3.42978317411633E-18
      5.48790341828078E-07
      0.00000000000000E+00  -1.45114684787892E-14   0.00000000000000E+00   9.29542389751258E-16  -4.59066124146317E-23
      1.45397050900859E-11   1.45406346324297E-11  -1.31940230366006E-18  -1.00562510601579E-02  -1.00562510602214E-02
      0.00000000000000E+00   0.00000000000000E+00   6.34541928760872E-11   0.00000000000000E+00   6.34541928760872E-11
      4.86885210914224E-18  -1.72343253490173E-01  -1.72318681101761E-01   0.00000000000000E+00  -4.14945511067173E-13
     -1.10525453719395E-22  -7.75798819973396E-11  -7.79948275085173E-11  -3.54944980548218E-18
      5.50790341828078E-07
      0.00000000000000E+00  -2.82881790599182E-14   0.00000000000000E+00   7.62338973100455E-16  -4.48534774373991E-23
      2.83239419348107E-11   2.83247042737389E-11  -1.32021885041594E-18  -8.92183610235558E-03  -8.92183610240491E-03
      0.00000000000000E+00   0.00000000000000E+00   4.93321650243722E-11   0.00000000000000E+00   4.93321650243722E-11
      4.96751643919099E-18  -1.99964943269813E-01  -1.99940477540354E-01   0.00000000000000E+00  -4.19318367048319E-13
     -1.12808121628000E-22  -7.72375509309499E-11  -7.76568692981110E-11  -3.64729758877504E-18
      5.52790341828078E-07
      0.00000000000000E+00  -3.94013922620290E-14   0.00000000000000E+00   5.92132500409619E-16  -4.26973560590668E-23
      3.93751848357129E-11   3.93757769681706E-11  -1.31849074568597E-18  -8.39519702848024E-03  -8.39519702852106E-03
      0.00000000000000E+00   0.00000000000000E+00   4.08221101350670E-11   0.00000000000000E+00   4.08221101350670E-11
      5.04916065946112E-18  -2.27015147306945E-01  -2.26989881227717E-01   0.00000000000000E+00  -4.38597380613836E-13
     -1.15115506348233E-22  -7.97592897225089E-11  -8.01978871032378E-11  -3.73066991377515E-18
      5.54790341828078E-07
      0.00000000000000E+00  -4.89532449316118E-14   0.00000000000000E+00   4.69704836246118E-16  -3.88508319418355E-23
      4.89222376955732E-11   4.89227074003706E-11  -1.31574323564681E-18  -8.07963025943782E-03  -8.07963025947299E-03
      0.00000000000000E+00   0.00000000000000E+00   3.51678506343777E-11   0.00000000000000E+00   3.51678506343777E-11
      5.11949636072988E-18  -2.53508844496070E-01  -2.53482352262119E-01   0.00000000000000E+00  -4.58139706356690E-13
     -1.17455222147318E-22  -8.36324183282747E-11  -8.40905580347488E-11  -3.80375312508307E-18
      5.56790341828078E-07
      0.00000000000000E+00  -5.74948054919118E-14   0.00000000000000E+00   3.88368283454793E-16  -3.26966016650075E-23
      5.75346184540064E-11   5.75350068222572E-11  -1.31265428133340E-18  -7.86034998497771E-03  -7.86034998500892E-03
      0.00000000000000E+00   0.00000000000000E+00   3.12021933596477E-11   0.00000000000000E+00   3.12021933596477E-11
      5.18190074744917E-18  -2.79458648062410E-01  -2.79430692173895E-01   0.00000000000000E+00  -4.75899811947324E-13
     -1.19821283216801E-22  -8.82613003698370E-11  -8.87372001819042E-11  -3.86924646611577E-18
      5.58790341828078E-07
      0.00000000000000E+00  -6.54852976289666E-14   0.00000000000000E+00   3.34906766243788E-16  -2.36944011357880E-23
      6.55242852708472E-11   6.55246201775898E-11  -1.30954008808902E-18  -7.69607255101804E-03  -7.69607255104634E-03
      0.00000000000000E+00   0.00000000000000E+00   2.83036698410836E-11   0.00000000000000E+00   2.83036698410836E-11
      5.23850808713134E-18  -3.04870820420503E-01  -3.04841260892339E-01   0.00000000000000E+00  -4.92773139995173E-13
     -1.22210287786451E-22  -9.33355168785568E-11  -9.38282900186742E-11  -3.92896799904231E-18
      5.60790341828078E-07
      0.00000000000000E+00  -7.31084108171913E-14   0.00000000000000E+00   2.99574821577083E-16  -1.15546665490982E-23
      7.30942065132272E-11   7.30945060880373E-11  -1.30654270483102E-18  -7.56734012284172E-03  -7.56734012286781E-03
      0.00000000000000E+00   0.00000000000000E+00   2.60947795100655E-11   0.00000000000000E+00   2.60947795100655E-11
      5.29069764615147E-18  -3.29749270231065E-01  -3.29718022066582E-01   0.00000000000000E+00  -5.10162656585806E-13
     -1.24624368935643E-22  -9.86791229413911E-11  -9.91892855981015E-11  -3.98415494132044E-18
      5.62790341828078E-07
      0.00000000000000E+00  -8.03641450565859E-14   0.00000000000000E+00   2.75894123200455E-16   3.52914676054723E-24
      8.03836146950316E-11   8.03838905891583E-11  -1.30371649501875E-18  -7.46320210498146E-03  -7.46320210500580E-03
      0.00000000000000E+00   0.00000000000000E+00   2.43361896866446E-11   0.00000000000000E+00   2.43361896866446E-11
      5.33937002552476E-18  -3.54102223289752E-01  -3.54069233031220E-01   0.00000000000000E+00  -5.29425812237205E-13
     -1.27070549497984E-22  -1.04190654463439E-10  -1.04720080275803E-10  -4.03565353050601E-18
      5.64790341828078E-07
      0.00000000000000E+00  -8.75280345587730E-14   0.00000000000000E+00   2.62987426905730E-16   2.01964947915171E-23
      8.75475888529184E-11   8.75478518403655E-11  -1.30103201357105E-18  -7.39716796901005E-03  -7.39716796903287E-03
      0.00000000000000E+00   0.00000000000000E+00   2.28165552571905E-11   0.00000000000000E+00   2.28165552571905E-11
      5.38500313603914E-18  -3.77918096295416E-01  -3.77883328215248E-01   0.00000000000000E+00  -5.50293508306118E-13
     -1.29552964241713E-22  -1.09814113589121E-10  -1.10364407097557E-10  -4.08397112246808E-18
      5.66790341828078E-07
      0.00000000000000E+00  -9.46000793237526E-14   0.00000000000000E+00   2.52901602603808E-16   3.72013714241074E-23
      9.46097390693828E-11   9.46099919710226E-11  -1.29849649829625E-18  -7.35443868758870E-03  -7.35443868761025E-03
      0.00000000000000E+00   0.00000000000000E+00   2.15524423246822E-11   0.00000000000000E+00   2.15524423246822E-11
      5.42810802068850E-18  -4.01273188249835E-01  -4.01236593967721E-01   0.00000000000000E+00  -5.76922644233242E-13
     -1.32092064810900E-22  -1.15585511651339E-10  -1.16162434295705E-10  -4.12961152239226E-18
      5.68790341828079E-07
      0.00000000000000E+00  -1.01580279351525E-13   0.00000000000000E+00   2.45155710439688E-16   5.36145271257261E-23
      1.01607893044335E-10   1.01608138200099E-10  -1.29610780563318E-18  -7.32292821727984E-03  -7.32292821730034E-03
      0.00000000000000E+00   0.00000000000000E+00   2.05078142954816E-11   0.00000000000000E+00   2.05078142954816E-11
      5.46912364927947E-18  -4.24285734927048E-01  -4.24247265504371E-01   0.00000000000000E+00  -6.11399671843788E-13
     -1.34713061448551E-22  -1.21504552823602E-10  -1.22115952495580E-10  -4.17301584364629E-18
      5.69790341828079E-07
      0.00000000000000E+00  -1.05162224102618E-13   0.00000000000000E+00   2.42966784279715E-16   6.17901010736588E-23
      1.05123187739177E-10   1.05123430706023E-10  -1.29495086120110E-18  -7.30979777331241E-03  -7.30979777333236E-03
      0.00000000000000E+00   0.00000000000000E+00   1.99447803125521E-11   0.00000000000000E+00   1.99447803125521E-11
      5.48906842959202E-18  -4.35694731652428E-01  -4.35655332393549E-01   0.00000000000000E+00  -6.38178946346801E-13
     -1.36051654442848E-22  -1.24430032072093E-10  -1.25068211018576E-10  -4.19411756839092E-18
      5.71140341828079E-07
      0.00000000000000E+00  -1.09846305700202E-13   0.00000000000000E+00   2.37999928262121E-16   7.18769654265658E-23
      1.09819278698461E-10   1.09819516698462E-10  -1.29344975945956E-18  -7.29702707787032E-03  -7.29702707788957E-03
      0.00000000000000E+00   0.00000000000000E+00   1.92521940706998E-11   0.00000000000000E+00   1.92521940706998E-11
      5.51505889158747E-18  -4.50897657937028E-01  -4.50856997775891E-01   0.00000000000000E+00  -6.60304262181040E-13
     -1.37888465981407E-22  -1.28411406506843E-10  -1.29071710769162E-10  -4.22160913212790E-18
      5.72962841828079E-07
      0.00000000000000E+00  -1.16091747830314E-13   0.00000000000000E+00   2.32670036956870E-16   8.36444863331553E-23
      1.16085398685651E-10   1.16085631355771E-10  -1.29151786681029E-18  -7.29043603932284E-03  -7.29043603934120E-03
      0.00000000000000E+00   0.00000000000000E+00   1.83625230208105E-11   0.00000000000000E+00   1.83625230208105E-11
      5.54852458979289E-18  -4.71046811997329E-01  -4.71004458570465E-01   0.00000000000000E+00  -6.90772465241957E-13
     -1.40414627736688E-22  -1.33757381911201E-10  -1.34448154376583E-10  -4.25700672298260E-18
      5.74962841828079E-07
      0.00000000000000E+00  -1.22888258383671E-13   0.00000000000000E+00   2.28815110161854E-16   9.44733123294894E-23
      1.22916558791941E-10   1.22916787607146E-10  -1.28948946024434E-18  -7.29996286694779E-03  -7.29996286696520E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74157349948746E-11   0.00000000000000E+00   1.74157349948746E-11
      5.58335605978264E-18  -4.92709334169144E-01  -4.92665127569422E-01   0.00000000000000E+00  -7.28649969958172E-13
     -1.43236287603207E-22  -1.39603872631918E-10  -1.40332522602020E-10  -4.29386659953830E-18
      5.76962841828079E-07
      0.00000000000000E+00  -1.29776613674235E-13   0.00000000000000E+00   2.27286619202938E-16   1.03404795436632E-22
      1.29750035426221E-10   1.29750262712944E-10  -1.28752288819995E-18  -7.33418229195922E-03  -7.33418229197571E-03
      0.00000000000000E+00   0.00000000000000E+00   1.64948806716995E-11   0.00000000000000E+00   1.64948806716995E-11
      5.61634582112604E-18  -5.13930612273044E-01  -5.13884543666460E-01   0.00000000000000E+00  -7.69016305435161E-13
     -1.46092440870688E-22  -1.45476127079062E-10  -1.46245143384644E-10  -4.32882293292609E-18
      5.78962841828079E-07
      0.00000000000000E+00  -1.36848658439215E-13   0.00000000000000E+00   2.36555166762024E-16   1.10829332963699E-22
      1.36827594695817E-10   1.36827831251094E-10  -1.28550136770163E-18  -7.44150500130403E-03  -7.44150500131957E-03
      0.00000000000000E+00   0.00000000000000E+00   1.55398226432741E-11   0.00000000000000E+00   1.55398226432741E-11
      5.64742546641259E-18  -5.34719715732580E-01  -5.34671719074897E-01   0.00000000000000E+00  -8.07132969491098E-13
     -1.48955695376129E-22  -1.51560520924727E-10  -1.52367653894367E-10  -4.36192409871096E-18
      5.80962841828079E-07
      0.00000000000000E+00  -1.44930995313477E-13   0.00000000000000E+00   2.77674806308551E-16   1.17473935732275E-22
      1.44893077435147E-10   1.44893355110071E-10  -1.28309250210568E-18  -7.76778653508450E-03  -7.76778653509887E-03
      0.00000000000000E+00   0.00000000000000E+00   1.43799556738930E-11   0.00000000000000E+00   1.43799556738930E-11
      5.67618537776037E-18  -5.55084679323091E-01  -5.55034508002955E-01   0.00000000000000E+00  -8.36547171767776E-13
     -1.51781986175954E-22  -1.58436763612045E-10  -1.59273310783965E-10  -4.39309287565470E-18
      5.82962841828079E-07
      0.00000000000000E+00  -1.56962655887663E-13   0.00000000000000E+00   4.45462287207711E-16   1.25323857203327E-22
      1.56952125611123E-10   1.56952571073536E-10  -1.27906549105194E-18  -8.86724446524515E-03  -8.86724446525743E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22793245790666E-11   0.00000000000000E+00   1.22793245790666E-11
      5.70074402691851E-18  -5.75028941001932E-01  -5.74975633462461E-01   0.00000000000000E+00  -8.34741697484725E-13
     -1.54466627595725E-22  -1.68397153954963E-10  -1.69231895652602E-10  -4.42167853586657E-18
      5.84962841828079E-07
      0.00000000000000E+00  -2.02793179754219E-13   0.00000000000000E+00   1.76275958036674E-15   1.50704074019171E-22
      2.02796377547773E-10   2.02798140307504E-10  -1.26296904346326E-18  -1.54944779369538E-02  -1.54944779369554E-02
      0.00000000000000E+00   0.00000000000000E+00   1.61873577826008E-12   0.00000000000000E+00   1.61873577826008E-12
      5.70398149847502E-18  -5.94512752503686E-01  -5.94448362895403E-01   0.00000000000000E+00  -5.84598629490225E-13
     -1.56269850180966E-22  -2.03832277456117E-10  -2.04416876085764E-10  -4.44101245501176E-18
      5.86962841828079E-07
      0.00000000000000E+00  -4.39017843851978E-13   0.00000000000000E+00   7.94865629860595E-15   2.43415085204013E-22
      4.38979347305976E-10   4.38987295962518E-10  -1.20308095677844E-18  -4.11173028034040E-02  -4.11173028033682E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.56952485465183E-11   0.00000000000000E+00  -3.56952485465183E-11
      5.63259100138199E-18  -6.13228560998077E-01  -6.13101528540653E-01   0.00000000000000E+00   3.52072314171071E-13
     -1.55181745783635E-22  -4.03644119730015E-10  -4.03292047415999E-10  -4.42951004460355E-18
      5.88962841828079E-07
      0.00000000000000E+00  -9.44898656391035E-13   0.00000000000000E+00   1.45184844578332E-14   3.20644718283446E-22
      9.44865672078934E-10   9.44880190563713E-10  -1.12917591681721E-18  -7.08806039533057E-02  -7.08806039532540E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.16752815386088E-11   0.00000000000000E+00  -5.16752815386088E-11
      5.52924043830478E-18  -6.30628177261967E-01  -6.30346825321009E-01   0.00000000000000E+00   5.01449736727531E-13
     -1.53594131467667E-22  -8.93706358761677E-10  -8.93204909025103E-10  -4.40006452148756E-18
      5.90962841828079E-07
      0.00000000000000E+00  -1.91542199446297E-12   0.00000000000000E+00   2.56497647485152E-14   3.67946341519189E-22
      1.91535197970551E-09   1.91537762947062E-09  -1.05599389874015E-18  -1.00429921832192E-01  -1.00429921832130E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.14191662362283E-11   0.00000000000000E+00  -6.14191662362283E-11
      5.40640210583232E-18  -6.45825320269071E-01  -6.45241334512760E-01   0.00000000000000E+00   4.28615170730901E-13
     -1.52179750389452E-22  -1.85438707840497E-09  -1.85395846323439E-09  -4.35040820709217E-18
      5.92962841828079E-07
      0.00000000000000E+00  -3.62208090125323E-12   0.00000000000000E+00   4.35616769456646E-14   4.03529313322186E-22
      3.62199744727037E-09   3.62204100894772E-09  -9.88655789263670E-19  -1.29493884922002E-01  -1.29493884921929E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.31942680201453E-11   0.00000000000000E+00  -7.31942680201453E-11
      5.26001356979203E-18  -6.57440962569489E-01  -6.56323090342012E-01   0.00000000000000E+00   3.33038760220306E-13
     -1.51019006440370E-22  -3.54917977968764E-09  -3.54884674092757E-09  -4.27135778052836E-18
      5.94962841828079E-07
      0.00000000000000E+00  -6.32259170936614E-12   0.00000000000000E+00   6.78775363187233E-14   4.31682585190170E-22
      6.32251578459082E-09   6.32258366212757E-09  -9.28667780247313E-19  -1.57995206505109E-01  -1.57995206505021E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.79514283886005E-11   0.00000000000000E+00  -8.79514283886005E-11
      5.08411071301482E-18  -6.63625298083100E-01  -6.61661404328926E-01   0.00000000000000E+00   2.49090733182749E-13
     -1.50082158933823E-22  -6.23488132447199E-09  -6.23463223373896E-09  -4.15544293276751E-18
      5.95462841828079E-07
      0.00000000000000E+00  -7.21541439976051E-12   0.00000000000000E+00   8.92687811636695E-14   4.42421083159001E-22
      7.21529526526134E-09   7.21538453404295E-09  -9.14221361771836E-19  -1.65083914833808E-01  -1.65083914833714E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.30943968630485E-11   0.00000000000000E+00  -9.30943968630485E-11
      5.03756351458330E-18  -6.64727310118358E-01  -6.62483803561994E-01   0.00000000000000E+00   2.08360649008698E-13
     -1.49871729574090E-22  -7.12249849782876E-09  -7.12229013717990E-09  -4.12334215281147E-18
      5.96137841828079E-07
      0.00000000000000E+00  -8.54009104450467E-12   0.00000000000000E+00   9.79230851327537E-14   4.53447241920436E-22
      8.53991243014419E-09   8.54001035322978E-09  -8.95612667187467E-19  -1.74586343932473E-01  -1.74586343932374E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.93829062503028E-11   0.00000000000000E+00  -9.93829062503028E-11
      4.97048005286435E-18  -6.65331640472961E-01  -6.62672856150567E-01   0.00000000000000E+00   1.90345938273014E-13
     -1.49603337289897E-22  -8.44081779291760E-09  -8.44062744697947E-09  -4.07486738567688E-18
      5.97049091828079E-07
      0.00000000000000E+00  -1.05482762235472E-11   0.00000000000000E+00   1.09791961908412E-13   4.62047712170951E-22
      1.05481552045181E-08   1.05482649964804E-08  -8.71706526000836E-19  -1.87291933592836E-01  -1.87291933592729E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07321848320869E-10   0.00000000000000E+00  -1.07321848320869E-10
      4.87268301858195E-18  -6.64355067230534E-01  -6.61066178872983E-01   0.00000000000000E+00   2.10273047869829E-13
     -1.49200732175639E-22  -1.04411534212073E-08  -1.04409431481596E-08  -4.00097649258112E-18
      5.98279279328079E-07
      0.00000000000000E+00  -1.36812838991704E-11   0.00000000000000E+00   1.26591810669798E-13   4.65586820188928E-22
      1.36811261381753E-08   1.36812527299864E-08  -8.41012628398318E-19  -2.04223664560649E-01  -2.04223664560532E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16559577047341E-10   0.00000000000000E+00  -1.16559577047341E-10
      4.72929288389303E-18  -6.59300693660548E-01  -6.55027807753956E-01   0.00000000000000E+00   3.30363544369591E-13
     -1.48381667909064E-22  -1.35650235164833E-08  -1.35646931529391E-08  -3.88828025549471E-18
      5.99940032453079E-07
      0.00000000000000E+00  -1.87711355457371E-11   0.00000000000000E+00   1.52232851977395E-13   4.60979587971386E-22
      1.87709650059416E-08   1.87711172387941E-08  -8.01426612080834E-19  -2.26688269244296E-01  -2.26688269244170E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.26230912387705E-10   0.00000000000000E+00  -1.26230912387705E-10
      4.51965450167355E-18  -6.44383523481260E-01  -6.38510312186423E-01   0.00000000000000E+00   6.65927807311190E-13
     -1.46225924802462E-22  -1.86455522542135E-08  -1.86448863264064E-08  -3.71822788959271E-18
      6.01940032453079E-07
      0.00000000000000E+00  -2.64778274448207E-11   0.00000000000000E+00   1.91231198069350E-13   4.46209789394910E-22
      2.64776174001361E-08   2.64778086313346E-08  -7.55208176116614E-19  -2.53186812554601E-01  -2.53186812554466E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.34774958831640E-10   0.00000000000000E+00  -1.34774958831640E-10
      4.25010458401026E-18  -6.11839300451932E-01  -6.03540954594255E-01   0.00000000000000E+00   1.26691257409887E-12
     -1.41128704769661E-22  -2.63443005850769E-08  -2.63430336725029E-08  -3.49489640789365E-18
      6.03940032453079E-07
      0.00000000000000E+00  -3.62348612573251E-11   0.00000000000000E+00   2.42098029992514E-13   4.21419247164953E-22
      3.62346231588776E-08   3.62348652569081E-08  -7.09575377124035E-19  -2.79142371772594E-01  -2.79142371772452E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.42065908171387E-10   0.00000000000000E+00  -1.42065908171387E-10
      3.96597276766749E-18  -5.61000671501476E-01  -5.49630659231654E-01   0.00000000000000E+00   1.87690643926231E-12
     -1.32779845822384E-22  -3.60946762551758E-08  -3.60927993487366E-08  -3.25639739054346E-18
      6.05940032453079E-07
      0.00000000000000E+00  -4.79644444908355E-11   0.00000000000000E+00   2.91283153934739E-13   3.78318423104652E-22
      4.79641108414533E-08   4.79644021246076E-08  -6.64293119496793E-19  -3.04560780434399E-01  -3.04560780434248E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51376045751793E-10   0.00000000000000E+00  -1.51376045751793E-10
      3.66322067616390E-18  -4.88346239441047E-01  -4.73283501949421E-01   0.00000000000000E+00   2.16587887820806E-12
     -1.21762129571571E-22  -4.78151919577339E-08  -4.78130260788558E-08  -2.99892755666711E-18
      6.07940032453079E-07
      0.00000000000000E+00  -6.07620901733323E-11   0.00000000000000E+00   3.18305265432403E-13   3.05628787075022E-22
      6.07617737177214E-08   6.07620920229872E-08  -6.19521012511174E-19  -3.29445312238443E-01  -3.29445312238279E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.64118754959128E-10   0.00000000000000E+00  -1.64118754959128E-10
      3.33498316624565E-18  -3.92114502686121E-01  -3.73023340441090E-01   0.00000000000000E+00   2.01885042594325E-12
     -1.09830717059694E-22  -6.05999921184539E-08  -6.05979732680281E-08  -2.71546215373448E-18
      6.09940032453079E-07
      0.00000000000000E+00  -7.26485442179932E-11   0.00000000000000E+00   2.96243172055775E-13   2.38392389377816E-22
      7.26482465257046E-08   7.26485427688769E-08  -5.75290243992748E-19  -3.53804296587102E-01  -3.53804296586924E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.77780764404760E-10   0.00000000000000E+00  -1.77780764404760E-10
      2.97942163743613E-18  -2.74501763955461E-01  -2.51669356642170E-01   0.00000000000000E+00   1.65092806018654E-12
     -9.61155657420177E-23  -7.24724129325322E-08  -7.24707620044721E-08  -2.40413139344338E-18
      6.11940032453079E-07
      0.00000000000000E+00  -7.84556114174135E-11   0.00000000000000E+00   1.45176534330175E-13   1.51370323481903E-22
      7.84554263181519E-08   7.84555714946864E-08  -5.32260293206995E-19  -3.77626504839154E-01  -3.77626504838952E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.02310102419787E-10   0.00000000000000E+00  -2.02310102419787E-10
      2.57480143259655E-18  -1.47818089294620E-01  -1.23163322652903E-01   0.00000000000000E+00   1.02073509760853E-12
     -8.19993828784421E-23  -7.82542821273641E-08  -7.82532613922665E-08  -2.04254113938956E-18
      6.13940032453079E-07
      0.00000000000000E+00  -6.17120402902697E-11   0.00000000000000E+00  -4.16262042679962E-13   4.65861698562711E-23
      6.17124489974342E-08   6.17120327353915E-08  -4.85071300798764E-19  -4.00984746403367E-01  -4.00984746403172E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.94922312133674E-10   0.00000000000000E+00  -1.94922312133674E-10
      2.18495680832921E-18  -5.62140165436127E-02  -3.68320235791750E-02   0.00000000000000E+00   8.70364938573019E-13
     -4.20592188922113E-23  -6.15179807881964E-08  -6.15171104232579E-08  -1.69988550753044E-18
      6.15940032453079E-07
      0.00000000000000E+00  -3.28307279174653E-11   0.00000000000000E+00  -7.15537667419786E-13   1.40910363286185E-23
      3.28314036203639E-08   3.28306880826965E-08  -4.27727540003870E-19  -4.24001234707496E-01  -4.24001234707366E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.29685069533994E-10   0.00000000000000E+00  -1.29685069533994E-10
      1.92558666926122E-18  -2.26523078590949E-02  -1.23492812617050E-02   0.00000000000000E+00   8.41646285802712E-13
     -1.45528248915059E-23  -3.27018446594483E-08  -3.27010030131625E-08  -1.49785912925735E-18
      6.16940032453079E-07
      0.00000000000000E+00  -2.35962906596717E-11   0.00000000000000E+00  -4.56052419414449E-13   8.36713441079001E-24
      2.35967665857984E-08   2.35963105333790E-08  -3.98804013841863E-19  -4.35412740395335E-01  -4.35412740395226E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09357718497136E-10   0.00000000000000E+00  -1.09357718497136E-10
      1.81622895076408E-18  -1.51183857944753E-02  -7.71840192508898E-03   0.00000000000000E+00   5.25267073965464E-13
     -9.32436212383203E-24  -2.34874780819559E-08  -2.34869528148819E-08  -1.41742493692222E-18
      6.18290032453079E-07
      0.00000000000000E+00  -1.88974220593975E-11   0.00000000000000E+00  -1.71473928041824E-13   5.69352758464125E-24
      1.88976084518883E-08   1.88974369779603E-08  -3.61068354776702E-19  -4.50619376912218E-01  -4.50619376912118E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00620441900453E-10   0.00000000000000E+00  -1.00620441900453E-10
      1.68039135419847E-18  -1.12931808328826E-02  -5.37090355245982E-03   0.00000000000000E+00   2.21941643286543E-13
     -6.39863251903255E-24  -1.87970384777031E-08  -1.87968165360598E-08  -1.31932299942177E-18
      6.20112532453079E-07
      0.00000000000000E+00  -1.70357292362009E-11   0.00000000000000E+00  -5.00428512739466E-14   4.34757431812737E-24
      1.70357307805292E-08   1.70356807376779E-08  -3.12192064306981E-19  -4.70773637720375E-01  -4.70773637720275E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.93000162695391E-11   0.00000000000000E+00  -9.93000162695391E-11
      1.49941707454724E-18  -9.51843651092469E-03  -4.18231888696942E-03   0.00000000000000E+00   9.08708055482785E-14
     -4.84995301677114E-24  -1.69364715922139E-08  -1.69363807214084E-08  -1.18722501024025E-18
      6.22112532453079E-07
      0.00000000000000E+00  -1.64593116654865E-11   0.00000000000000E+00  -1.38819013354464E-14   3.64005679891110E-24
      1.64592918678721E-08   1.64592779859707E-08  -2.60998182039718E-19  -4.92441705054654E-01  -4.92441705054553E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01283817342160E-10   0.00000000000000E+00  -1.01283817342160E-10
      1.29684943986292E-18  -8.72059174783942E-03  -3.56670165990230E-03   0.00000000000000E+00   4.87213744572578E-14
     -4.00774794912330E-24  -1.63580428900030E-08  -1.63579941686286E-08  -1.03585125782320E-18
      6.24112532453079E-07
      0.00000000000000E+00  -1.62741526752761E-11   0.00000000000000E+00  -4.26272225052981E-15   3.21066617887428E-24
      1.62741514406932E-08   1.62741471779710E-08  -2.12252140094151E-19  -5.13668426125318E-01  -5.13668426125214E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03781151741341E-10   0.00000000000000E+00  -1.03781151741341E-10
      1.08928713638023E-18  -8.29184584732016E-03  -3.19706831656191E-03   0.00000000000000E+00   3.47978353267929E-14
     -3.47447586294125E-24  -1.61704008240650E-08  -1.61703660262296E-08  -8.77034996286084E-19
      6.26112532453079E-07
      0.00000000000000E+00  -1.61991155249775E-11   0.00000000000000E+00  -1.57676461060344E-15   2.91168271290056E-24
      1.61990909905068E-08   1.61990894137422E-08  -1.65856509439755E-19  -5.34462882458006E-01  -5.34462882457901E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05861158412334E-10   0.00000000000000E+00  -1.05861158412334E-10
      8.77564819555565E-19  -8.01287649698355E-03  -2.94240000943470E-03   0.00000000000000E+00   2.87940002975401E-14
     -3.09171157504092E-24  -1.60932570493301E-08  -1.60932282553299E-08  -7.11708310115809E-19
      6.28112532453080E-07
      0.00000000000000E+00  -1.61600815116643E-11   0.00000000000000E+00  -7.13199222767514E-16   2.68773583999274E-24
      1.61600406273983E-08   1.61600399141991E-08  -1.21669550311333E-19  -5.54833149055373E-01  -5.54833149055266E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07382977918002E-10   0.00000000000000E+00  -1.07382977918002E-10
      6.62798863719560E-19  -7.81188443525743E-03  -2.75418885280424E-03   0.00000000000000E+00   2.52643629173532E-14
     -2.80103657299027E-24  -1.60526822006440E-08  -1.60526569362811E-08  -5.41129313408226E-19
      6.30112532453080E-07
      0.00000000000000E+00  -1.61359263457788E-11   0.00000000000000E+00  -3.64825035866426E-16   2.51262699912067E-24
      1.61359535563010E-08   1.61359531914760E-08  -7.95345927347362E-20  -5.74782930316696E-01  -5.74782930316588E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08340869029913E-10   0.00000000000000E+00  -1.08340869029913E-10
      4.46117125659735E-19  -7.65872108818773E-03  -2.60891446588818E-03   0.00000000000000E+00   2.27375709114144E-14
     -2.57274018876098E-24  -1.60276350600170E-08  -1.60276123224461E-08  -3.66582532924998E-19
      6.32112532453080E-07
      0.00000000000000E+00  -1.61193942930814E-11   0.00000000000000E+00  -1.96918725325333E-16   2.37170738678688E-24
      1.61193991687336E-08   1.61193989718149E-08  -3.93718307702007E-20  -5.94275576413544E-01  -5.94275576413435E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08567763170350E-10   0.00000000000000E+00  -1.08567763170350E-10
      2.28981599319034E-19  -7.53743545697981E-03  -2.49291443176186E-03   0.00000000000000E+00   2.07172614531971E-14
     -2.38912578414180E-24  -1.60108519259060E-08  -1.60108312086446E-08  -1.89609768548834E-19
      6.34112532453080E-07
      0.00000000000000E+00  -1.61056175825003E-11   0.00000000000000E+00  -1.46444620829841E-16   2.25684688338087E-24
      1.61055986784249E-08   1.61055985319803E-08  -1.62604359449917E-21  -6.13011484384278E-01  -6.13011484384171E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06607151333304E-10   0.00000000000000E+00  -1.06607151333304E-10
      1.57672966524252E-20  -7.43848552531140E-03  -2.39769354248682E-03   0.00000000000000E+00   1.87589487374229E-14
     -2.24024618772916E-24  -1.59990101395957E-08  -1.59989913806470E-08  -1.41412530579267E-20
      6.36112532453080E-07
      0.00000000000000E+00  -1.60768701797543E-11   0.00000000000000E+00  -5.37433239645916E-16   2.17662470000853E-24
      1.60768292816945E-08   1.60768287442613E-08   3.28359147454309E-20  -6.30448352776149E-01  -6.30448352776048E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00903406649343E-10   0.00000000000000E+00  -1.00903406649343E-10
     -1.86039516646261E-19  -7.38381966502950E-03  -2.35029401603417E-03   0.00000000000000E+00   1.69098780270571E-14
     -2.13860360629668E-24  -1.59759422474900E-08  -1.59759253376119E-08   1.53203601900830E-19
      6.38112532453080E-07
      0.00000000000000E+00  -1.60568480270431E-11   0.00000000000000E+00  -3.47040284013338E-16   2.11394439320456E-24
      1.60568673937022E-08   1.60568670466620E-08   6.25031035333799E-20  -6.45710779638421E-01  -6.45710779638332E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.95891060364421E-11   0.00000000000000E+00  -8.95891060364421E-11
     -3.65217728719145E-19  -7.34487610221763E-03  -2.31407407984919E-03   0.00000000000000E+00   1.39785705147443E-14
     -2.05993558179752E-24  -1.59672919191960E-08  -1.59672779406255E-08   3.02714625185765E-19
      6.40112532453080E-07
      0.00000000000000E+00  -1.60310396558878E-11   0.00000000000000E+00  -5.29593854610479E-16   2.06800461083589E-24
      1.60310000032123E-08   1.60309994736184E-08   8.49990375311676E-20  -6.57432616630090E-01  -6.57432616630021E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.95491148926142E-11   0.00000000000000E+00  -6.95491148926142E-11
     -5.04315958504374E-19  -7.31610870969971E-03  -2.28714210863452E-03   0.00000000000000E+00   1.04115662436065E-14
     -2.00396210007209E-24  -1.59614607702920E-08  -1.59614503587258E-08   4.19316920973205E-19
      6.42112532453080E-07
      0.00000000000000E+00  -1.59931996241583E-11   0.00000000000000E+00  -8.75974984524971E-16   2.04144545208213E-24
      1.59931569714586E-08   1.59931560954836E-08   9.70735250857804E-20  -6.63774281990963E-01  -6.63774281990925E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.78882031525970E-11   0.00000000000000E+00  -3.78882031525970E-11
     -5.80092364809568E-19  -7.29803764007090E-03  -2.27101858667660E-03   0.00000000000000E+00   5.60712268002447E-15
     -1.97457456938056E-24  -1.59552734994537E-08  -1.59552678923311E-08   4.83018839723787E-19
      6.42612532453080E-07
      0.00000000000000E+00  -1.59810761188469E-11   0.00000000000000E+00  -1.14878555157023E-15   2.03610335494815E-24
      1.59810972986593E-08   1.59810961498738E-08   9.92470986464075E-20  -6.64919314395630E-01  -6.64919314395602E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.74459175428592E-11   0.00000000000000E+00  -2.74459175428592E-11
     -5.93815323580997E-19  -7.29419316994376E-03  -2.26768372696865E-03   0.00000000000000E+00   4.07140925390539E-15
     -1.96926450213241E-24  -1.59536543037402E-08  -1.59536502323309E-08   4.94568224934589E-19
      6.43287532453080E-07
      0.00000000000000E+00  -1.59630745503542E-11   0.00000000000000E+00  -2.57940766720317E-15   2.03167311814585E-24
      1.59630929927506E-08   1.59630904133430E-08   1.00517645105154E-19  -6.65588541093456E-01  -6.65588541093444E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19053470479020E-11   0.00000000000000E+00  -1.19053470479020E-11
     -6.01851432838331E-19  -7.29045529788527E-03  -2.26472211065544E-03   0.00000000000000E+00   3.15427041979858E-15
     -1.96585279215830E-24  -1.59511882205655E-08  -1.59511850662951E-08   5.01333787733177E-19
      6.44198782453080E-07
      0.00000000000000E+00  -1.59359803528780E-11   0.00000000000000E+00  -5.06557386871446E-15   2.03127551054604E-24
      1.59359439417656E-08   1.59359388761918E-08   9.88593842066567E-20  -6.64712315895021E-01  -6.64712315895032E-01
      0.00000000000000E+00   0.00000000000000E+00   1.14920467180520E-11   0.00000000000000E+00   1.14920467180520E-11
     -5.91379305266506E-19  -7.28842993009798E-03  -2.26387888000800E-03   0.00000000000000E+00   2.14763247618376E-15
     -1.96893731478651E-24  -1.59474330705423E-08  -1.59474309229098E-08   4.92519921059849E-19
      6.45428969953080E-07
      0.00000000000000E+00  -1.58940073079741E-11   0.00000000000000E+00  -7.41064643672241E-14   2.04261537591643E-24
      1.58939859791296E-08   1.58939118726652E-08   8.95619760460668E-20  -6.59818044311379E-01  -6.59818044311427E-01
      0.00000000000000E+00   0.00000000000000E+00   4.75388217757733E-11   0.00000000000000E+00   4.75388217757733E-11
     -5.32897640953222E-19  -7.29219459189713E-03  -2.26950632712906E-03   0.00000000000000E+00   6.57765605399193E-14
     -1.98957484233418E-24  -1.59415164710015E-08  -1.59414506944410E-08   4.43335664907155E-19
      6.47089723078080E-07
      0.00000000000000E+00  -1.58265932708638E-11   0.00000000000000E+00  -2.16617123962241E-15   2.08593688664743E-24
      1.58265919264769E-08   1.58265897603057E-08   6.14801881937033E-20  -6.45167754868519E-01  -6.45167754868624E-01
      0.00000000000000E+00   0.00000000000000E+00   1.04694138400299E-10   0.00000000000000E+00   1.04694138400299E-10
     -3.59026523435743E-19  -7.31267998226831E-03  -2.29321858244107E-03   0.00000000000000E+00  -1.51098151289454E-14
     -2.05702180226411E-24  -1.59312687888908E-08  -1.59312838987060E-08   2.97546335242039E-19
      6.49089723078080E-07
      0.00000000000000E+00  -1.57253803704611E-11   0.00000000000000E+00  -2.93962119026839E-15   2.20087709226792E-24
      1.57253886578982E-08   1.57253857182770E-08  -1.54237911796990E-21  -6.13032111407444E-01  -6.13032111407631E-01
      0.00000000000000E+00   0.00000000000000E+00   1.87096028820231E-10   0.00000000000000E+00   1.87096028820231E-10
      1.51655342047186E-20  -7.37199831787228E-03  -2.35846277255910E-03   0.00000000000000E+00  -2.89932582263740E-14
     -2.23144921131185E-24  -1.59124527538390E-08  -1.59124817470973E-08  -1.36231550867489E-20
      6.51089723078080E-07
      0.00000000000000E+00  -1.55418745855205E-11   0.00000000000000E+00  -1.37497788143203E-14   2.49784479391440E-24
      1.55418707899705E-08   1.55418570401917E-08  -1.04859577632757E-19  -5.62697524262005E-01  -5.62697524262287E-01
      0.00000000000000E+00   0.00000000000000E+00   2.81163301729401E-10   0.00000000000000E+00   2.81163301729401E-10
      5.77492137663522E-19  -7.60342570607955E-03  -2.61807797120973E-03   0.00000000000000E+00  -4.10794329586691E-14
     -2.69697759960654E-24  -1.58229792624882E-08  -1.58230203419211E-08  -4.72632560030765E-19
      6.53089723078080E-07
      0.00000000000000E+00  -1.52228978131987E-11   0.00000000000000E+00  -8.82272678172205E-15   3.24888322585672E-24
      1.52228522186794E-08   1.52228433959526E-08  -2.65105634733074E-19  -4.90618674153588E-01  -4.90618674153956E-01
      0.00000000000000E+00   0.00000000000000E+00   3.67679572785891E-10   0.00000000000000E+00   3.67679572785891E-10
      1.31285128323530E-18  -8.28320815469271E-03  -3.37112421021478E-03   0.00000000000000E+00  -8.69229514435574E-14
     -4.11252759840168E-24  -1.55904360457871E-08  -1.55905229687385E-08  -1.04774564850223E-18
      6.55089723078080E-07
      0.00000000000000E+00  -1.38304397523954E-11   0.00000000000000E+00  -3.80455951197562E-14   5.36690584102987E-24
      1.38305190826093E-08   1.38304810370142E-08  -4.98278809181411E-19  -3.94971667516760E-01  -3.94971667517163E-01
      0.00000000000000E+00   0.00000000000000E+00   4.03422668429816E-10   0.00000000000000E+00   4.03422668429816E-10
      2.11969662009493E-18  -1.15990768920815E-02  -7.11443905556846E-03   0.00000000000000E+00  -1.55358560981138E-13
     -1.29339901708253E-23  -1.42337483468830E-08  -1.42339037054440E-08  -1.62141781091352E-18
      6.57089723078080E-07
      0.00000000000000E+00  -5.38237713457269E-12   0.00000000000000E+00  -2.12082777685322E-13  -8.59769432061085E-24
      5.38253868551752E-09   5.38232660273982E-09  -7.68492737853713E-19  -2.77783103278071E-01  -2.77783103278480E-01
      0.00000000000000E+00   0.00000000000000E+00   4.09136247745192E-10   0.00000000000000E+00   4.09136247745192E-10
      2.93796911558532E-18  -3.13424497798120E-02  -2.95177677998519E-02   0.00000000000000E+00  -2.74651652364455E-13
     -6.75041617531620E-23  -5.79118819883259E-09  -5.79146285048502E-09  -2.16947637773161E-18
      6.59089723078080E-07
      0.00000000000000E+00  -2.29703687756024E-13   0.00000000000000E+00  -1.33454649818331E-13  -4.16768562809769E-23
      2.29849167860981E-10   2.29715713211121E-10  -1.03217148281003E-18  -1.51039197278746E-01  -1.51039197279137E-01
      0.00000000000000E+00   0.00000000000000E+00   3.91030140770222E-10   0.00000000000000E+00   3.91030140770222E-10
      3.72002939712577E-18  -6.07892887619091E-02  -6.05937163742563E-02   0.00000000000000E+00  -8.48404131543440E-13
     -8.96748853263603E-23  -6.19897449849709E-10  -6.20745853981343E-10  -2.68785791431574E-18
      6.60089723078080E-07
      0.00000000000000E+00   5.52905317989311E-14   0.00000000000000E+00  -2.22936289037195E-14  -4.48934690654387E-23
     -5.52465099845630E-11  -5.52688036135116E-11  -1.14928901706403E-18  -9.23226841024140E-02  -9.23226841027531E-02
      0.00000000000000E+00   0.00000000000000E+00   3.39113744845602E-10   0.00000000000000E+00   3.39113744845602E-10
      4.05914314197136E-18  -7.56944741269343E-02  -7.56050456951282E-02   0.00000000000000E+00  -1.36270407573777E-12
     -9.61471838639172E-23  -2.82482237156256E-10  -2.83844941232090E-10  -2.90985412490733E-18
      6.61439723078080E-07
      0.00000000000000E+00   7.04449134381730E-14   0.00000000000000E+00  -6.04039555093954E-15  -4.60852407521457E-23
     -7.04425855626378E-11  -7.04486259582348E-11  -1.24639485680910E-18  -4.37116883464597E-02  -4.37116883466931E-02
      0.00000000000000E+00   0.00000000000000E+00   2.33366899351077E-10   0.00000000000000E+00   2.33366899351077E-10
      4.37418845609532E-18  -9.57006217837584E-02  -9.56492927508198E-02   0.00000000000000E+00  -1.13537420378765E-12
     -1.02180898311612E-22  -1.61782899188954E-10  -1.62918273392843E-10  -3.12779359928622E-18
      6.63262223078080E-07
      0.00000000000000E+00   2.76452658994656E-14   0.00000000000000E+00  -1.93140949029277E-16  -4.64659854878841E-23
     -2.76632844893026E-11  -2.76634776302981E-11  -1.29720166420136E-18  -1.98304561348182E-02  -1.98304561349496E-02
      0.00000000000000E+00   0.00000000000000E+00   1.31349790384073E-10   0.00000000000000E+00   1.31349790384073E-10
      4.61357344907029E-18  -1.22313613321486E-01  -1.22280946270160E-01   0.00000000000000E+00  -6.55341473463004E-13
     -1.06095535443537E-22  -1.03030971280206E-10  -1.03686312753775E-10  -3.31637178486893E-18
      6.65262223078080E-07
      0.00000000000000E+00  -8.26602634867741E-16   0.00000000000000E+00   8.98014351557820E-16  -4.62722334589825E-23
      7.90419531151977E-13   7.91317545457263E-13  -1.31532565269265E-18  -1.20518961425207E-02  -1.20518961426024E-02
      0.00000000000000E+00   0.00000000000000E+00   8.16832218920067E-11   0.00000000000000E+00   8.16832218920067E-11
      4.77693989285431E-18  -1.50960356751527E-01  -1.50934372862073E-01   0.00000000000000E+00  -4.49073494236553E-13
     -1.08757439426946E-22  -8.20254659431183E-11  -8.24745394374636E-11  -3.46161424016166E-18
      6.67262223078080E-07
      0.00000000000000E+00  -1.83689474415054E-14   0.00000000000000E+00   8.98300939145729E-16  -4.57235491487692E-23
      1.83524437678189E-11   1.83533420687123E-11  -1.32017831973164E-18  -9.65949999046627E-03  -9.65949999052531E-03
      0.00000000000000E+00   0.00000000000000E+00   5.90455171187287E-11   0.00000000000000E+00   5.90455171187287E-11
      4.89503092709176E-18  -1.79024392958883E-01  -1.79000008376607E-01   0.00000000000000E+00  -4.11880291034055E-13
     -1.11070180540151E-22  -7.69869788962960E-11  -7.73988591874411E-11  -3.57485260736013E-18
      6.69262223078080E-07
      0.00000000000000E+00  -3.12272106505591E-14   0.00000000000000E+00   7.15471996726414E-16  -4.44503152352579E-23
      3.12382177134056E-11   3.12389331853578E-11  -1.32006151163343E-18  -8.75842804133918E-03  -8.75842804138600E-03
      0.00000000000000E+00   0.00000000000000E+00   4.68268864002578E-11   0.00000000000000E+00   4.68268864002578E-11
      4.98868469989228E-18  -2.06507645907636E-01  -2.06483051383479E-01   0.00000000000000E+00  -4.23500966056668E-13
     -1.13355757936635E-22  -7.76423186194456E-11  -7.80658195856156E-11  -3.66862318825885E-18
      6.71262223078080E-07
      0.00000000000000E+00  -4.17893554294247E-14   0.00000000000000E+00   5.56330552778490E-16  -4.19398476115668E-23
      4.18221208402129E-11   4.18226771707237E-11  -1.31794573667596E-18  -8.30536043767443E-03  -8.30536043771364E-03
      0.00000000000000E+00   0.00000000000000E+00   3.92100510299181E-11   0.00000000000000E+00   3.92100510299181E-11
      5.06710480195211E-18  -2.33422928938613E-01  -2.33397399894668E-01   0.00000000000000E+00  -4.43561565824682E-13
     -1.15672023926914E-22  -8.05891666347013E-11  -8.10327282006416E-11  -3.74915906527615E-18
      6.73262223078080E-07
      0.00000000000000E+00  -5.10656738873849E-14   0.00000000000000E+00   4.50473075488200E-16  -3.76119217580110E-23
      5.10898584593283E-11   5.10903089323662E-11  -1.31504682729046E-18  -8.01988023100493E-03  -8.01988023103899E-03
      0.00000000000000E+00   0.00000000000000E+00   3.40593309942292E-11   0.00000000000000E+00   3.40593309942292E-11
      5.13522346394057E-18  -2.59785142831898E-01  -2.59758316996846E-01   0.00000000000000E+00  -4.62670027337936E-13
     -1.18019724017386E-22  -8.46869698991395E-11  -8.51496399265954E-11  -3.82017663665011E-18
      6.75262223078080E-07
      0.00000000000000E+00  -5.95153897104773E-14   0.00000000000000E+00   3.72644397741382E-16  -3.07886307912411E-23
      5.95193890896032E-11   5.95197617339701E-11  -1.31191748283402E-18  -7.81657147595179E-03  -7.81657147598220E-03
      0.00000000000000E+00   0.00000000000000E+00   3.04062298511703E-11   0.00000000000000E+00   3.04062298511703E-11
      5.19603592364292E-18  -2.85605632108978E-01  -2.85577301762215E-01   0.00000000000000E+00  -4.80069174624048E-13
     -1.20391404281615E-22  -8.94459224103967E-11  -8.99259915851411E-11  -3.88411844080890E-18
      6.77262223078080E-07
      0.00000000000000E+00  -6.74140371103246E-14   0.00000000000000E+00   3.24590978715613E-16  -2.10395049952127E-23
      6.73859467748617E-11   6.73862713658193E-11  -1.30881504418895E-18  -7.66225661731655E-03  -7.66225661734426E-03
      0.00000000000000E+00   0.00000000000000E+00   2.77080690734360E-11   0.00000000000000E+00   2.77080690734360E-11
      5.25145206178979E-18  -3.10889139385619E-01  -3.10859181067730E-01   0.00000000000000E+00  -4.96905300964719E-13
     -1.22786326858685E-22  -9.45974351381671E-11  -9.50943404392547E-11  -3.94263701760084E-18
      6.79262223078080E-07
      0.00000000000000E+00  -7.48534608241343E-14   0.00000000000000E+00   2.92738195446932E-16  -8.14446819567931E-24
      7.48736651166955E-11   7.48739578548828E-11  -1.30585184652597E-18  -7.54025569112826E-03  -7.54025569115389E-03
      0.00000000000000E+00   0.00000000000000E+00   2.56301881513450E-11   0.00000000000000E+00   2.56301881513450E-11
      5.30271243809247E-18  -3.35641040350212E-01  -3.35609378027331E-01   0.00000000000000E+00  -5.14628661261987E-13
     -1.25207611303220E-22  -9.99895173448409E-11  -1.00504146006228E-10  -3.99686059156651E-18
      6.81262223078080E-07
      0.00000000000000E+00  -8.21091950635289E-14   0.00000000000000E+00   2.71213170538774E-16   7.48035086059996E-24
      8.21069627490835E-11   8.21072339622616E-11  -1.30306774884004E-18  -7.44082742589869E-03  -7.44082742592265E-03
      0.00000000000000E+00   0.00000000000000E+00   2.39545662096864E-11   0.00000000000000E+00   2.39545662096864E-11
      5.35062157051185E-18  -3.59866729641584E-01  -3.59833316771829E-01   0.00000000000000E+00  -5.34403316583059E-13
     -1.27662719936081E-22  -1.05527396855238E-10  -1.06061800171948E-10  -4.04755382167181E-18
      6.83262223078081E-07
      0.00000000000000E+00  -8.92730845657160E-14   0.00000000000000E+00   2.60897512302435E-16   2.43204575107994E-23
      8.92557654348111E-11   8.92560263323477E-11  -1.30041166119545E-18  -7.38508601724327E-03  -7.38508601726575E-03
      0.00000000000000E+00   0.00000000000000E+00   2.24758405216264E-11   0.00000000000000E+00   2.24758405216264E-11
      5.39557325155510E-18  -3.83555439283391E-01  -3.83520240492928E-01   0.00000000000000E+00  -5.55748286869243E-13
     -1.30155160180404E-22  -1.11176118566975E-10  -1.11731866853974E-10  -4.09516159035965E-18
      6.85262223078081E-07
      0.00000000000000E+00  -9.62532845934880E-14   0.00000000000000E+00   2.50780997113369E-16   4.12631102786755E-23
      9.62975831459502E-11   9.62978339269886E-11  -1.29791092028561E-18  -7.34577730655412E-03  -7.34577730657541E-03
      0.00000000000000E+00   0.00000000000000E+00   2.12895052775543E-11   0.00000000000000E+00   2.12895052775543E-11
      5.43815226211021E-18  -4.06828966007181E-01  -4.06791922927656E-01   0.00000000000000E+00  -5.84863531065348E-13
     -1.32713505860945E-22  -1.17002475673344E-10  -1.17587339204542E-10  -4.14024134182460E-18
      6.87262223078081E-07
      0.00000000000000E+00  -1.03325329358468E-13   0.00000000000000E+00   2.43453676774290E-16   5.74042093708740E-23
      1.03280159625827E-10   1.03280403079561E-10  -1.29555556218411E-18  -7.31674427819662E-03  -7.31674427821688E-03
      0.00000000000000E+00   0.00000000000000E+00   2.02598464043591E-11   0.00000000000000E+00   2.02598464043591E-11
      5.47867195491893E-18  -4.29748606282653E-01  -4.29709688266918E-01   0.00000000000000E+00  -6.19884666587765E-13
     -1.35353192440344E-22  -1.22920364817198E-10  -1.23540249483921E-10  -4.18311639273482E-18
      6.89262223078081E-07
      0.00000000000000E+00  -1.10213684649032E-13   0.00000000000000E+00   2.37243400750877E-16   7.20248906292631E-23
      1.10202685866975E-10   1.10202923110448E-10  -1.29333211016626E-18  -7.29838294143030E-03  -7.29838294144954E-03
      0.00000000000000E+00   0.00000000000000E+00   1.92433433437859E-11   0.00000000000000E+00   1.92433433437859E-11
      5.51715864160650E-18  -4.52241490807284E-01  -4.52200712684591E-01   0.00000000000000E+00  -6.55911823274057E-13
     -1.38064366434722E-22  -1.28790354630822E-10  -1.29446266454234E-10  -4.22382653144024E-18
      6.89762223078081E-07
      0.00000000000000E+00  -1.11958734655975E-13   0.00000000000000E+00   2.37630759649230E-16   7.56921539247676E-23
      1.11951746854961E-10   1.11951984485797E-10  -1.29278538242730E-18  -7.29446416198788E-03  -7.29446416200682E-03
      0.00000000000000E+00   0.00000000000000E+00   1.89333269473577E-11   0.00000000000000E+00   1.89333269473577E-11
      5.52662530508018E-18  -4.57836077292020E-01  -4.57794845944786E-01   0.00000000000000E+00  -6.78336198067149E-13
     -1.38750592662987E-22  -1.30206975234945E-10  -1.30885311433151E-10  -4.23383992265288E-18
      6.90437223078081E-07
      0.00000000000000E+00  -1.14346697823371E-13   0.00000000000000E+00   2.35436322105048E-16   8.03699492745131E-23
      1.14301656411423E-10   1.14301891847826E-10  -1.29206140328392E-18  -7.29061806409093E-03  -7.29061806410951E-03
      0.00000000000000E+00   0.00000000000000E+00   1.85828234562198E-11   0.00000000000000E+00   1.85828234562198E-11
      5.53916871091313E-18  -4.65337519420120E-01  -4.65295658376941E-01   0.00000000000000E+00  -6.90519477923267E-13
     -1.39684868414329E-22  -1.32194195825982E-10  -1.32884715304045E-10  -4.24710730762921E-18
      6.91348473078081E-07
      0.00000000000000E+00  -1.17469418888427E-13   0.00000000000000E+00   2.32717680848470E-16   8.61578164038462E-23
      1.17452931371356E-10   1.17453164089123E-10  -1.29110719000399E-18  -7.28842615364401E-03  -7.28842615366213E-03
      0.00000000000000E+00   0.00000000000000E+00   1.81249355257321E-11   0.00000000000000E+00   1.81249355257321E-11
      5.55568505841095E-18  -4.75370471666123E-01  -4.75327762375395E-01   0.00000000000000E+00  -7.07099327843219E-13
     -1.40958307519283E-22  -1.34871000286872E-10  -1.35578099614856E-10  -4.26457786840696E-18
      6.92578660578081E-07
      0.00000000000000E+00  -1.21694276799973E-13   0.00000000000000E+00   2.29826822794693E-16   9.30636554478969E-23
      1.21677393108209E-10   1.21677622935125E-10  -1.28985491335310E-18  -7.29191373235040E-03  -7.29191373236793E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75330685797539E-11   0.00000000000000E+00   1.75330685797539E-11
      5.57725402021441E-18  -4.88744671453004E-01  -4.88700818144804E-01   0.00000000000000E+00  -7.29443275715683E-13
     -1.42695958339156E-22  -1.38481248239019E-10  -1.39210691514877E-10  -4.28739910686131E-18
      6.94239413703081E-07
      0.00000000000000E+00  -1.27388650506840E-13   0.00000000000000E+00   2.27403459445148E-16   1.00927378431108E-22
      1.27350141325172E-10   1.27350368728732E-10  -1.28821301429219E-18  -7.31187259371653E-03  -7.31187259373330E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67724717919763E-11   0.00000000000000E+00   1.67724717919763E-11
      5.60510895515691E-18  -5.06494186272475E-01  -5.06448786013719E-01   0.00000000000000E+00  -7.59368564268027E-13
     -1.45066403995727E-22  -1.43363471956296E-10  -1.44122840520709E-10  -4.31689594086471E-18
      6.96239413703081E-07
      0.00000000000000E+00  -1.34185161060197E-13   0.00000000000000E+00   2.27537967647518E-16   1.08655695042251E-22
      1.34206907543701E-10   1.34207135081777E-10  -1.28626985003457E-18  -7.36858918259840E-03  -7.36858918261428E-03
      0.00000000000000E+00   0.00000000000000E+00   1.58895734748832E-11   0.00000000000000E+00   1.58895734748832E-11
      5.63688810210667E-18  -5.27434896167209E-01  -5.27387614655912E-01   0.00000000000000E+00  -7.96151718609273E-13
     -1.47938889764583E-22  -1.49300556837904E-10  -1.50096708556662E-10  -4.35061825207211E-18
      6.98239413703081E-07
      0.00000000000000E+00  -1.41808274248421E-13   0.00000000000000E+00   2.58426294842395E-16   1.15395472005488E-22
      1.41811049445437E-10   1.41811307871848E-10  -1.28405479519387E-18  -7.59499126139061E-03  -7.59499126140542E-03
      0.00000000000000E+00   0.00000000000000E+00   1.48081342685740E-11   0.00000000000000E+00   1.48081342685740E-11
      5.66650437064382E-18  -5.47948828361947E-01  -5.47899492780598E-01   0.00000000000000E+00  -8.28492127880135E-13
     -1.50787613221699E-22  -1.55790950012389E-10  -1.56619442140420E-10  -4.38244957544994E-18
      7.00239413703081E-07
      0.00000000000000E+00  -1.51543816392419E-13   0.00000000000000E+00   3.46211111107083E-16   1.22191739577704E-22
      1.51524085777638E-10   1.51524431988872E-10  -1.28096770108059E-18  -8.25454564957836E-03  -8.25454564959167E-03
      0.00000000000000E+00   0.00000000000000E+00   1.33028534691936E-11   0.00000000000000E+00   1.33028534691936E-11
      5.69311007758221E-18  -5.68042172148191E-01  -5.67990251779148E-01   0.00000000000000E+00  -8.44927048711471E-13
     -1.53552281352166E-22  -1.63982358409201E-10  -1.64827285458066E-10  -4.41214237650162E-18
      7.02239413703081E-07
      0.00000000000000E+00  -1.75423448066376E-13   0.00000000000000E+00   9.17833663751012E-16   1.36076934976281E-22
      1.75414279653697E-10   1.75415197487496E-10  -1.27246470495905E-18  -1.14207325395303E-02  -1.14207325395384E-02
      0.00000000000000E+00   0.00000000000000E+00   8.11948854281033E-12   0.00000000000000E+00   8.11948854281033E-12
      5.70934905466783E-18  -5.87703784892881E-01  -5.87645972613957E-01   0.00000000000000E+00  -7.51407896463710E-13
     -1.55899217968715E-22  -1.82783278133687E-10  -1.83534686030306E-10  -4.43688434970877E-18
      7.04239413703081E-07
      0.00000000000000E+00  -3.26416196035550E-13   0.00000000000000E+00   5.41267803486818E-15   2.06587869713945E-22
      3.26396336412545E-10   3.26401749090786E-10  -1.22798799069736E-18  -3.06397097708945E-02  -3.06397097708721E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.23871981737409E-11   0.00000000000000E+00  -2.23871981737409E-11
      5.66457465832034E-18  -6.06745629922749E-01  -6.06649868764072E-01   0.00000000000000E+00   3.94943402959556E-14
     -1.55771513073199E-22  -3.04054045257186E-10  -3.04014550917046E-10  -4.43658666762299E-18
      7.06239413703081E-07
      0.00000000000000E+00  -7.20246429181425E-13   0.00000000000000E+00   1.18762809004486E-14   2.96903981684551E-22
      7.20200142220428E-10   7.20212018501625E-10  -1.15633642491371E-18  -6.00419829856810E-02  -6.00419829856334E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.76298648089538E-11   0.00000000000000E+00  -4.76298648089538E-11
      5.56931492870244E-18  -6.24699782780425E-01  -6.24487925877554E-01   0.00000000000000E+00   5.06626425014684E-13
     -1.54187384036574E-22  -6.73088780117534E-10  -6.72582153692673E-10  -4.41297850378873E-18
      7.07239413703081E-07
      0.00000000000000E+00  -1.04932612259599E-12   0.00000000000000E+00   1.81590392679940E-14   3.36986681606701E-22
      1.04929144555578E-09   1.04930960459539E-09  -1.11888361675646E-18  -7.49470757634865E-02  -7.49470757634327E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.37814339914414E-11   0.00000000000000E+00  -5.37814339914414E-11
      5.51553349471100E-18  -6.33271677579328E-01  -6.32958094335086E-01   0.00000000000000E+00   4.83782265802554E-13
     -1.53410402160902E-22  -9.96011952869595E-10  -9.95528170603946E-10  -4.39664987795454E-18
      7.08589413703081E-07
      0.00000000000000E+00  -1.69830103570438E-12   0.00000000000000E+00   2.54389579547370E-14   3.73250600162159E-22
      1.69829055962678E-09   1.69831599858510E-09  -1.06891088969893E-18  -9.49596786098693E-02  -9.49596786098088E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.04514194075149E-11   0.00000000000000E+00  -6.04514194075149E-11
      5.43392407851085E-18  -6.43844485097894E-01  -6.43328568358482E-01   0.00000000000000E+00   4.31245451373101E-13
     -1.52450813697424E-22  -1.63829582462881E-09  -1.63786457917759E-09  -4.36501318881192E-18
      7.10411913703081E-07
      0.00000000000000E+00  -3.08175831226135E-12   0.00000000000000E+00   3.89619462665620E-14   4.02975782020452E-22
      3.08175833479799E-09   3.08179729674466E-09  -1.00600157266200E-18  -1.21584618536339E-01  -1.21584618536269E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.03906311507038E-11   0.00000000000000E+00  -7.03906311507038E-11
      5.30563715323870E-18  -6.55433600828394E-01  -6.54485021709938E-01   0.00000000000000E+00   3.48765619667266E-13
     -1.51358184814772E-22  -3.01175543121347E-09  -3.01140666559395E-09  -4.29963558057669E-18
      7.12411913703081E-07
      0.00000000000000E+00  -5.48919256394504E-12   0.00000000000000E+00   6.06936346313087E-14   4.28524239727797E-22
      5.48913635258475E-09   5.48919704621981E-09  -9.44199926805041E-19  -1.50245841368319E-01  -1.50245841368234E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.41545267258864E-11   0.00000000000000E+00  -8.41545267258864E-11
      5.13732809978692E-18  -6.63264742455323E-01  -6.61562170330556E-01   0.00000000000000E+00   2.59548388605586E-13
     -1.50402405247623E-22  -5.40530206788238E-09  -5.40504251949393E-09  -4.19312817298188E-18
      7.14411913703081E-07
      0.00000000000000E+00  -9.03109300961610E-12   0.00000000000000E+00   8.84383140423909E-14   4.47650832041385E-22
      9.03099480831890E-09   9.03108324663339E-09  -8.89063448692954E-19  -1.78324607672757E-01  -1.78324607672657E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.99302685313241E-11   0.00000000000000E+00  -9.99302685313241E-11
      4.93746756272428E-18  -6.64110070135863E-01  -6.61296768965461E-01   0.00000000000000E+00   2.38848611617301E-13
     -1.49460748224513E-22  -8.93139182671354E-09  -8.93115297810207E-09  -4.04840411403133E-18
      7.16411913703081E-07
      0.00000000000000E+00  -1.38690145420226E-11   0.00000000000000E+00   1.20382099330372E-13   4.56384931780442E-22
      1.38688806547399E-08   1.38690010368397E-08  -8.38710274870799E-19  -2.05822368199802E-01  -2.05822368199687E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14881444824686E-10   0.00000000000000E+00  -1.14881444824686E-10
      4.70770467307490E-18  -6.55591618831865E-01  -6.51259054510060E-01   0.00000000000000E+00   3.96316470215572E-13
     -1.47906146236818E-22  -1.37545159084851E-08  -1.37541195920150E-08  -3.86899439820410E-18
      7.18411913703081E-07
      0.00000000000000E+00  -2.02152103488511E-11   0.00000000000000E+00   1.57581629697072E-13   4.53460586567858E-22
      2.02150298499174E-08   2.02151874315476E-08  -7.91186739672186E-19  -2.32751779213741E-01  -2.32751779213614E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.26835759898684E-10   0.00000000000000E+00  -1.26835759898684E-10
      4.45403315327754E-18  -6.34959245029678E-01  -6.28631295691070E-01   0.00000000000000E+00   8.01461965068185E-13
     -1.44767369320518E-22  -2.00891531336138E-08  -2.00883516716489E-08  -3.66284641360535E-18
      7.20411913703081E-07
      0.00000000000000E+00  -2.83747886471049E-11   0.00000000000000E+00   2.02449065073501E-13   4.39215989517126E-22
      2.83746269834405E-08   2.83748294325060E-08  -7.45031760573142E-19  -2.59127766508175E-01  -2.59127766508040E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.35692659373442E-10   0.00000000000000E+00  -1.35692659373442E-10
      4.18264783453065E-18  -5.98917760838995E-01  -5.90022043194375E-01   0.00000000000000E+00   1.39709092322253E-12
     -1.38987221529948E-22  -2.82405338640557E-08  -2.82391367731326E-08  -3.43761607395751E-18
      7.22411913703081E-07
      0.00000000000000E+00  -3.86008735325282E-11   0.00000000000000E+00   2.53762070238119E-13   4.12380940882284E-22
      3.86006677104021E-08   3.86009214724728E-08  -6.99426298248785E-19  -2.84961818107963E-01  -2.84961818107820E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.43556334888347E-10   0.00000000000000E+00  -1.43556334888347E-10
      3.89553516475396E-18  -5.43732252819733E-01  -5.31617225660320E-01   0.00000000000000E+00   1.94770994373812E-12
     -1.29995833611673E-22  -3.84593128475280E-08  -3.84573651375844E-08  -3.19610886650517E-18
      7.24411913703081E-07
      0.00000000000000E+00  -5.06518215015278E-11   0.00000000000000E+00   2.99349076798046E-13   3.62664564731976E-22
      5.06515775903102E-08   5.06518769393873E-08  -6.54228138043365E-19  -3.10258824328861E-01  -3.10258824328707E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53948198005926E-10   0.00000000000000E+00  -1.53948198005926E-10
      3.58763876874210E-18  -4.66171520518355E-01  -4.50262789246456E-01   0.00000000000000E+00   2.12452451106121E-12
     -1.18797191390778E-22  -5.05000532658924E-08  -5.04979287413814E-08  -2.93341063069874E-18
      7.26411913703081E-07
      0.00000000000000E+00  -6.34681116656777E-11   0.00000000000000E+00   3.18895810334802E-13   2.86983588046572E-22
      6.34678373187592E-08   6.34681562145698E-08  -6.09542556931441E-19  -3.35023984275895E-01  -3.35023984275728E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.66814747856062E-10   0.00000000000000E+00  -1.66814747856062E-10
      3.25400927302998E-18  -3.65065032587171E-01  -3.45122011052028E-01   0.00000000000000E+00   1.93043735408215E-12
     -1.06749015343229E-22  -6.33032719040678E-08  -6.33013414667138E-08  -2.64446671609854E-18
      7.28411913703081E-07
      0.00000000000000E+00  -7.44900311990041E-11   0.00000000000000E+00   2.74830586799231E-13   2.23633647966108E-22
      7.44897222767804E-08   7.44899971073674E-08  -5.65487625655748E-19  -3.59263103482891E-01  -3.59263103482709E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.81888766982400E-10   0.00000000000000E+00  -1.81888766982400E-10
      2.89023173906518E-18  -2.44379145220328E-01  -2.20967716091952E-01   0.00000000000000E+00   1.50408372018224E-12
     -9.24930502371658E-23  -7.43096124241051E-08  -7.43081083403850E-08  -2.32474411340943E-18
      7.30411913703081E-07
      0.00000000000000E+00  -7.76497656931547E-11   0.00000000000000E+00   7.92161594181380E-14   1.22435671837191E-22
      7.76497108036743E-08   7.76497900198339E-08  -5.22649430063945E-19  -3.82964921085342E-01  -3.82964921085135E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.07854127299207E-10   0.00000000000000E+00  -2.07854127299207E-10
      2.47452348446676E-18  -1.19845303604382E-01  -9.54460773729760E-02   0.00000000000000E+00   8.97046615949394E-13
     -7.73874697540178E-23  -7.74428329391504E-08  -7.74419358925345E-08  -1.95187405440282E-18
      7.32411913703081E-07
      0.00000000000000E+00  -5.36193249607029E-11   0.00000000000000E+00  -5.97149731124876E-13   3.43333218536606E-23
      5.36199018971638E-08   5.36193047474327E-08  -4.72381910265961E-19  -4.06246741161868E-01  -4.06246741161689E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.79185188215866E-10   0.00000000000000E+00  -1.79185188215866E-10
      2.11615310803503E-18  -4.45530602901073E-02  -2.77158423006383E-02   0.00000000000000E+00   9.30202987857329E-13
     -3.20453983220408E-23  -5.34410497622046E-08  -5.34401195592168E-08  -1.64377119776907E-18
      7.34411913703081E-07
      0.00000000000000E+00  -2.87592507170556E-11   0.00000000000000E+00  -6.15239853794759E-13   1.13394152444621E-23
      2.87598968617109E-08   2.87592816218571E-08  -4.14631961568529E-19  -4.29176369415662E-01  -4.29176369415542E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20031330605286E-10   0.00000000000000E+00  -1.20031330605286E-10
      1.87609044682446E-18  -1.91469077411579E-02  -1.01236043995363E-02   0.00000000000000E+00   7.15384022154283E-13
     -1.19781546190794E-23  -2.86399656752740E-08  -2.86392502912519E-08  -1.46145848525593E-18
      7.36411913703081E-07
      0.00000000000000E+00  -1.97536905443832E-11   0.00000000000000E+00  -2.22037059453435E-13   5.93479708363020E-24
      1.97539541153875E-08   1.97537320783280E-08  -3.58569834767690E-19  -4.51680440825188E-01  -4.51680440825086E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01861967374730E-10   0.00000000000000E+00  -1.01861967374730E-10
      1.67236651207500E-18  -1.17664896215990E-02  -5.57481207170664E-03   0.00000000000000E+00   2.75878683660716E-13
     -6.58788949154665E-24  -1.96521459896369E-08  -1.96518701109533E-08  -1.31379667730731E-18
      7.36911913703082E-07
      0.00000000000000E+00  -1.82794906674652E-11   0.00000000000000E+00  -1.45172140570602E-13   5.16844241326917E-24
      1.82796158033888E-08   1.82794706312482E-08  -3.44816837597148E-19  -4.57277866104773E-01  -4.57277866104672E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01633657981599E-10   0.00000000000000E+00  -1.01633657981599E-10
      1.62154968308420E-18  -1.06593718801665E-02  -4.93211370596780E-03   0.00000000000000E+00   1.90499330128003E-13
     -5.86453606340388E-24  -1.81780274725967E-08  -1.81778369732666E-08  -1.27673284548705E-18
      7.37586913703081E-07
      0.00000000000000E+00  -1.72889451766820E-11   0.00000000000000E+00  -7.23892438826621E-14   4.59625208319357E-24
      1.72890458676865E-08   1.72889734784426E-08  -3.26586055729241E-19  -4.64783162249094E-01  -4.64783162248994E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00474398772138E-10   0.00000000000000E+00  -1.00474398772138E-10
      1.55372946391301E-18  -9.83255370432790E-03  -4.41700266121546E-03   0.00000000000000E+00   1.13697089049627E-13
     -5.19713001711614E-24  -1.71886127767596E-08  -1.71884990796705E-08  -1.22714340818377E-18
      7.38498163703082E-07
      0.00000000000000E+00  -1.67176709112512E-11   0.00000000000000E+00  -3.07581791021966E-14   4.12959794901574E-24
      1.67177658597294E-08   1.67177351015503E-08  -3.02504936861652E-19  -4.74821303642089E-01  -4.74821303641988E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00563670637936E-10   0.00000000000000E+00  -1.00563670637936E-10
      1.46209081904419E-18  -9.23546538736698E-03  -3.99991967647510E-03   0.00000000000000E+00   6.87925477697270E-14
     -4.63332830072308E-24  -1.66172402234601E-08  -1.66171714309124E-08  -1.15958588218254E-18
      7.39728351203081E-07
      0.00000000000000E+00  -1.64281762995731E-11   0.00000000000000E+00  -1.30068355412863E-14   3.72049560712044E-24
      1.64282518118642E-08   1.64282388050286E-08  -2.70890759040610E-19  -4.88202438205572E-01  -4.88202438205471E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01599714485812E-10   0.00000000000000E+00  -1.01599714485812E-10
      1.33710412028017E-18  -8.78361572344705E-03  -3.63960477132997E-03   0.00000000000000E+00   4.79084988001806E-14
     -4.12653634420685E-24  -1.63266869990416E-08  -1.63266390905428E-08  -1.06621336123956E-18
      7.41389104328081E-07
      0.00000000000000E+00  -1.62868272490107E-11   0.00000000000000E+00  -3.88758033137654E-15   3.33883710166086E-24
      1.62867976914864E-08   1.62867938039061E-08  -2.29784957023033E-19  -5.05961156957757E-01  -5.05961156957653E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03242157127040E-10   0.00000000000000E+00  -1.03242157127040E-10
      1.16564438519970E-18  -8.40653338869267E-03  -3.30760259297680E-03   0.00000000000000E+00   3.55077313557230E-14
     -3.64200683295909E-24  -1.61835871545104E-08  -1.61835516467790E-08  -9.35859428176668E-19
      7.43389104328082E-07
      0.00000000000000E+00  -1.62127085460842E-11   0.00000000000000E+00  -1.54230513536268E-15   3.00884035925103E-24
      1.62127121647736E-08   1.62127106224684E-08  -1.82547600590405E-19  -5.26912716624832E-01  -5.26912716624727E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05148427078460E-10   0.00000000000000E+00  -1.05148427078460E-10
      9.55347531042781E-19  -8.09957706222981E-03  -3.02458528488044E-03   0.00000000000000E+00   2.98668524630045E-14
     -3.21724406780420E-24  -1.61075920622424E-08  -1.61075621953900E-08  -7.72799930452377E-19
      7.45389104328082E-07
      0.00000000000000E+00  -1.61701844327572E-11   0.00000000000000E+00  -7.90384670271784E-16   2.76257442505524E-24
      1.61701857006429E-08   1.61701849102582E-08  -1.37572056777334E-19  -5.47437296938740E-01  -5.47437296938633E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06889828427102E-10   0.00000000000000E+00  -1.06889828427102E-10
      7.41567874188578E-19  -7.87778266956250E-03  -2.81673603029067E-03   0.00000000000000E+00   2.62515952397892E-14
     -2.89848976771997E-24  -1.60633213334264E-08  -1.60632950818311E-08  -6.03995817411244E-19
      7.47389104328082E-07
      0.00000000000000E+00  -1.61430902352809E-11   0.00000000000000E+00  -4.31414879976037E-16   2.57196793440381E-24
      1.61431092039064E-08   1.61431087724916E-08  -9.47042864106248E-20  -5.67541201013946E-01  -5.67541201013838E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08056896769994E-10   0.00000000000000E+00  -1.08056896769994E-10
      5.25454080648590E-19  -7.71009600743740E-03  -2.65794605243945E-03   0.00000000000000E+00   2.35516216129334E-14
     -2.65015676175650E-24  -1.60350754273432E-08  -1.60350518757216E-08  -4.30749794237965E-19
      7.49389104328082E-07
      0.00000000000000E+00  -1.61246294431022E-11   0.00000000000000E+00  -2.37124947182589E-16   2.41984022476433E-24
      1.61246698233545E-08   1.61246695862295E-08  -5.38113477368947E-20  -5.87214331639186E-01  -5.87214331639077E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08617254091169E-10   0.00000000000000E+00  -1.08617254091169E-10
      3.08219572466253E-19  -7.57865877598386E-03  -2.53249328793428E-03   0.00000000000000E+00   2.14139948321754E-14
     -2.45179006341954E-24  -1.60160737461332E-08  -1.60160523321384E-08  -2.54408224729358E-19
      7.51389104328082E-07
      0.00000000000000E+00  -1.61103935088351E-11   0.00000000000000E+00  -1.52017554411473E-16   2.29615779759023E-24
      1.61103833204456E-08   1.61103831684281E-08  -1.51025016829701E-20  -6.06276491558924E-01  -6.06276491558816E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07664936566194E-10   0.00000000000000E+00  -1.07664936566194E-10
      9.28896993338657E-20  -7.47252306485081E-03  -2.43055732654468E-03   0.00000000000000E+00   1.94844728788281E-14
     -2.29108983158656E-24  -1.60027377163348E-08  -1.60027182318619E-08  -7.77871976508959E-20
      7.53389104328082E-07
      0.00000000000000E+00  -1.60875241692704E-11   0.00000000000000E+00  -3.83361077961244E-16   2.20391112691321E-24
      1.60875308914507E-08   1.60875305080896E-08   2.06869864856444E-20  -6.24265032679234E-01  -6.24265032679130E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03498933173609E-10   0.00000000000000E+00  -1.03498933173609E-10
     -1.14108167013352E-19  -7.40216187098246E-03  -2.36608256835907E-03   0.00000000000000E+00   1.76170088945021E-14
     -2.17302625146491E-24  -1.59840491919249E-08  -1.59840315749160E-08   9.34211805277074E-20
      7.55389104328082E-07
      0.00000000000000E+00  -1.60646548297057E-11   0.00000000000000E+00  -4.09060819926226E-16   2.13506971170499E-24
      1.60646210483702E-08   1.60646206393093E-08   5.23238112895616E-20  -6.40448406700661E-01  -6.40448406700566E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.45376370451719E-11   0.00000000000000E+00  -9.45376370451719E-11
     -3.03183441103696E-19  -7.35803572573184E-03  -2.32635022213317E-03   0.00000000000000E+00   1.51309387355789E-14
     -2.08628446022399E-24  -1.59700981332029E-08  -1.59700830022642E-08   2.50859629814133E-19
      7.57389104328082E-07
      0.00000000000000E+00  -1.60416018006666E-11   0.00000000000000E+00  -4.44401001035838E-16   2.08279673585531E-24
      1.60416057278821E-08   1.60416052834811E-08   7.77593815353807E-20  -6.53646671814080E-01  -6.53646671814002E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.80352127856471E-11   0.00000000000000E+00  -7.80352127856471E-11
     -4.59253866674990E-19  -7.32550961150555E-03  -2.29587536931878E-03   0.00000000000000E+00   1.18328823783718E-14
     -2.02168884497761E-24  -1.59635819035778E-08  -1.59635700706954E-08   3.81494485139610E-19
      7.59389104328082E-07
      0.00000000000000E+00  -1.60084458505347E-11   0.00000000000000E+00  -7.42890695135049E-16   2.04875642660067E-24
      1.60084782176666E-08   1.60084774747759E-08   9.40416026967362E-20  -6.62178886194118E-01  -6.62178886194067E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.08688092428760E-11   0.00000000000000E+00  -5.08688092428760E-11
     -5.60991485160742E-19  -7.30332694390036E-03  -2.27557047363487E-03   0.00000000000000E+00   7.52816170355843E-15
     -1.98202650633495E-24  -1.59576161936947E-08  -1.59576086655330E-08   4.66949882464006E-19
      7.61389104328082E-07
      0.00000000000000E+00  -1.59614213450845E-11   0.00000000000000E+00  -1.14395473283921E-15   2.03685299717304E-24
      1.59614530916673E-08   1.59614519477126E-08   9.74616155453486E-20  -6.63976977220906E-01  -6.63976977220896E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07789257805679E-11   0.00000000000000E+00  -1.07789257805679E-11
     -5.82549336721877E-19  -7.29323031734168E-03  -2.26765895209212E-03   0.00000000000000E+00   1.71289334670405E-15
     -1.97283365658309E-24  -1.59506747348254E-08  -1.59506730219320E-08   4.85087721176529E-19
      7.63389104328082E-07
      0.00000000000000E+00  -1.58983240106229E-11   0.00000000000000E+00  -1.62031442033105E-15   2.05389142050497E-24
      1.58983309444411E-08   1.58983293241267E-08   8.36047710576367E-20  -6.56694894292434E-01  -6.56694894292478E-01
      0.00000000000000E+00   0.00000000000000E+00   4.34470665720568E-11   0.00000000000000E+00   4.34470665720568E-11
     -4.95655203577764E-19  -7.29888855629628E-03  -2.27612064698160E-03   0.00000000000000E+00  -6.04209140277205E-15
     -2.00390069666138E-24  -1.59417703486073E-08  -1.59417763906988E-08   4.12050432520128E-19
      7.65389104328082E-07
      0.00000000000000E+00  -1.58164903497710E-11   0.00000000000000E+00  -1.54832050677925E-15   2.11280452445717E-24
      1.58165180566490E-08   1.58165165083285E-08   4.68910989675858E-20  -6.37636555272596E-01  -6.37636555272709E-01
      0.00000000000000E+00   0.00000000000000E+00   1.12634188642544E-10   0.00000000000000E+00   1.12634188642544E-10
     -2.70386826292675E-19  -7.32737016642972E-03  -2.30858151583868E-03   0.00000000000000E+00  -1.71785067043134E-14
     -2.09482583055084E-24  -1.59291335184643E-08  -1.59291506969711E-08   2.23495727325089E-19
      7.67389104328082E-07
      0.00000000000000E+00  -1.57033376335313E-11   0.00000000000000E+00  -3.12985610129787E-15   2.24969094485560E-24
      1.57033611213899E-08   1.57033579915338E-08  -2.04871234289820E-20  -6.03576775842806E-01  -6.03576775843003E-01
      0.00000000000000E+00   0.00000000000000E+00   1.96824314698258E-10   0.00000000000000E+00   1.96824314698258E-10
      1.23261803103841E-19  -7.41026154145516E-03  -2.40060186299521E-03   0.00000000000000E+00  -3.13289590434988E-14
     -2.30316810236657E-24  -1.59001509772730E-08  -1.59001823062321E-08  -1.02774679674859E-19
      7.69389104328082E-07
      0.00000000000000E+00  -1.55112902880304E-11   0.00000000000000E+00  -6.38452780215965E-15   2.59138242143996E-24
      1.55112694025836E-08   1.55112630180558E-08  -1.30230073137819E-19  -5.50807583990518E-01  -5.50807583990809E-01
      0.00000000000000E+00   0.00000000000000E+00   2.90933805007372E-10   0.00000000000000E+00   2.90933805007372E-10
      7.05129413118586E-19  -7.68146611033861E-03  -2.70268270468733E-03   0.00000000000000E+00  -5.28253097301391E-14
     -2.84872820680665E-24  -1.58021439977535E-08  -1.58021968230632E-08  -5.74899339980767E-19
      7.71389104328082E-07
      0.00000000000000E+00  -1.51336247286330E-11   0.00000000000000E+00  -1.09604458577338E-14   3.48131315828599E-24
      1.51336452765932E-08   1.51336343161474E-08  -2.99614715797141E-19  -4.75962536691975E-01  -4.75962536692347E-01
      0.00000000000000E+00   0.00000000000000E+00   3.72317245313591E-10   0.00000000000000E+00   3.72317245313591E-10
      1.44976390374577E-18  -8.52479413666686E-03  -3.63935812681036E-03   0.00000000000000E+00  -9.40260957550987E-14
     -4.64401204561171E-24  -1.55058575353652E-08  -1.55059515614610E-08  -1.15014918794863E-18
      7.73389104328082E-07
      0.00000000000000E+00  -1.32133349630980E-11   0.00000000000000E+00  -5.63137058377808E-14   5.70182191185941E-24
      1.32134239091662E-08   1.32133675954604E-08  -5.41178128396327E-19  -3.77560256588198E-01  -3.77560256588597E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98608093640955E-10   0.00000000000000E+00   3.98608093640955E-10
      2.24698009102768E-18  -1.30509203361996E-02  -8.76223482324284E-03   0.00000000000000E+00  -1.63820499705224E-13
     -1.74364084696381E-23  -1.36118118686016E-08  -1.36119756891014E-08  -1.70580196263135E-18
      7.75389104328082E-07
      0.00000000000000E+00  -3.82946631786783E-12   0.00000000000000E+00  -2.36097086868866E-13  -1.60364043026001E-23
      3.82965081491961E-09   3.82941471783272E-09  -8.09076774954865E-19  -2.58617311475779E-01  -2.58617311476187E-01
      0.00000000000000E+00   0.00000000000000E+00   4.08256850306763E-10   0.00000000000000E+00   4.08256850306763E-10
      3.06349379164120E-18  -3.58005529573842E-02  -3.44654174565584E-02   0.00000000000000E+00  -3.15563375517199E-13
     -7.45465651782248E-23  -4.23735600476389E-09  -4.23767156813949E-09  -2.25441701668634E-18
      7.77389104328082E-07
      0.00000000000000E+00  -9.40490109005074E-14   0.00000000000000E+00  -9.85851080677637E-14  -4.30441875821170E-23
      9.41085396142808E-11   9.40099545061700E-11  -1.06881091416170E-18  -1.32991918539768E-01  -1.32991918540149E-01
      0.00000000000000E+00   0.00000000000000E+00   3.81139102922306E-10   0.00000000000000E+00   3.81139102922306E-10
      3.82577199748582E-18  -6.54419586632851E-02  -6.52922582177323E-02   0.00000000000000E+00  -9.64507777929702E-13
     -9.25920599028937E-23  -4.74184549650453E-10  -4.75149057428475E-10  -2.75696108332412E-18
      7.79389104328082E-07
      0.00000000000000E+00   7.66903555682848E-14   0.00000000000000E+00  -1.03155158083862E-14  -4.59360608078214E-23
     -7.66888719076007E-11  -7.66991874234550E-11  -1.23491890696603E-18  -4.98597165062997E-02  -4.98597165065571E-02
      0.00000000000000E+00   0.00000000000000E+00   2.57313432599414E-10   0.00000000000000E+00   2.57313432599414E-10
      4.34039886268464E-18  -9.50604263906285E-02  -9.50035220712827E-02   0.00000000000000E+00  -1.17517517685945E-12
     -1.01605486421738E-22  -1.79439069998998E-10  -1.80614245175959E-10  -3.10547995571862E-18
      7.81389104328082E-07
      0.00000000000000E+00   2.93903159064086E-14   0.00000000000000E+00  -5.59940587473003E-16  -4.63879877741895E-23
     -2.93815477660004E-11  -2.93821077066342E-11  -1.29564046797845E-18  -2.07359126305422E-02  -2.07359126306785E-02
      0.00000000000000E+00   0.00000000000000E+00   1.36321975795055E-10   0.00000000000000E+00   1.36321975795055E-10
      4.61304281427475E-18  -1.24220526236351E-01  -1.24186834100026E-01   0.00000000000000E+00  -6.95840143818838E-13
     -1.06200973733137E-22  -1.06244027944495E-10  -1.06939868088420E-10  -3.31740234629630E-18
      7.83389104328082E-07
      0.00000000000000E+00  -4.59223686037634E-16   0.00000000000000E+00   8.48766023991099E-16  -4.62642380833530E-23
      4.23484053673536E-13   4.24332819651263E-13  -1.31496616212836E-18  -1.22266791912348E-02  -1.22266791913177E-02
      0.00000000000000E+00   0.00000000000000E+00   8.29686767031786E-11   0.00000000000000E+00   8.29686767031786E-11
      4.77898016768111E-18  -1.52827038566124E-01  -1.52800765313693E-01   0.00000000000000E+00  -4.61268439225809E-13
     -1.08927936167829E-22  -8.29317410834957E-11  -8.33930095228304E-11  -3.46401400555275E-18
      7.85389104328082E-07
      0.00000000000000E+00  -1.83689474415054E-14   0.00000000000000E+00   8.86690348922856E-16  -4.57193163052129E-23
      1.83852149962243E-11   1.83861016865275E-11  -1.32006517263670E-18  -9.67648591870813E-03  -9.67648591876750E-03
      0.00000000000000E+00   0.00000000000000E+00   5.93652720331534E-11   0.00000000000000E+00   5.93652720331534E-11
      4.89771071174742E-18  -1.80852341790761E-01  -1.80827846157504E-01   0.00000000000000E+00  -4.14576601418015E-13
     -1.11247509731964E-22  -7.73367971181517E-11  -7.77513737196809E-11  -3.57764553911071E-18
      7.87389104328082E-07
      0.00000000000000E+00  -3.14109001249742E-14   0.00000000000000E+00   7.16112515415967E-16  -4.44472400321969E-23
      3.14039700726809E-11   3.14046861851519E-11  -1.31997981382782E-18  -8.74764561144846E-03  -8.74764561149537E-03
      0.00000000000000E+00   0.00000000000000E+00   4.69084820877979E-11   0.00000000000000E+00   4.69084820877979E-11
      4.99152767592301E-18  -2.08297870674669E-01  -2.08273198236351E-01   0.00000000000000E+00  -4.24078767495181E-13
     -1.13529706702290E-22  -7.78890895053407E-11  -7.83131682729494E-11  -3.67154786209519E-18
      7.89389104328083E-07
      0.00000000000000E+00  -4.20648896410473E-14   0.00000000000000E+00   5.69276025543742E-16  -4.19331121404224E-23
      4.20571061827156E-11   4.20576754586992E-11  -1.31785411910127E-18  -8.29287453677536E-03  -8.29287453681459E-03
      0.00000000000000E+00   0.00000000000000E+00   3.92308808738391E-11   0.00000000000000E+00   3.92308808738391E-11
      5.06998943767069E-18  -2.35176428322277E-01  -2.35150818698355E-01   0.00000000000000E+00  -4.43801125713727E-13
     -1.15841968889621E-22  -8.08447552067093E-11  -8.12885563325388E-11  -3.75213531856942E-18
      7.91389104328083E-07
      0.00000000000000E+00  -5.13412080990075E-14   0.00000000000000E+00   4.47332264831593E-16  -3.75754110786680E-23
      5.13728669566683E-11   5.13733142888955E-11  -1.31494122531751E-18  -8.00971392773593E-03  -8.00971392776999E-03
      0.00000000000000E+00   0.00000000000000E+00   3.40602225214829E-11   0.00000000000000E+00   3.40602225214829E-11
      5.13810988271366E-18  -2.61502777996456E-01  -2.61475862735575E-01   0.00000000000000E+00  -4.62939759707344E-13
     -1.18186110153430E-22  -8.49705970505527E-11  -8.54335368103782E-11  -3.82316865739615E-18
      7.93389104328083E-07
      0.00000000000000E+00  -5.98827686593074E-14   0.00000000000000E+00   3.76929072825546E-16  -3.07630921227545E-23
      5.98379623309069E-11   5.98383392599489E-11  -1.31180086109663E-18  -7.80865777368047E-03  -7.80865777371087E-03
      0.00000000000000E+00   0.00000000000000E+00   3.03962210377330E-11   0.00000000000000E+00   3.03962210377330E-11
      5.19890232478912E-18  -2.87287882223433E-01  -2.87259454682695E-01   0.00000000000000E+00  -4.80495796560886E-13
     -1.20556298662659E-22  -8.97540645010005E-11  -9.02345602976820E-11  -3.88710146369249E-18
      7.95389104328083E-07
      0.00000000000000E+00  -6.76895713219472E-14   0.00000000000000E+00   3.25382781137550E-16  -2.09986520589544E-23
      6.77317629501229E-11   6.77320883328830E-11  -1.30869107965905E-18  -7.65601880160081E-03  -7.65601880162850E-03
      0.00000000000000E+00   0.00000000000000E+00   2.76893127787590E-11   0.00000000000000E+00   2.76893127787590E-11
      5.25428095034664E-18  -3.12536161440415E-01  -3.12506100103925E-01   0.00000000000000E+00  -4.97525641481395E-13
     -1.22950341168245E-22  -9.49238754700378E-11  -9.54214011116421E-11  -3.94558987068759E-18
      7.97389104328083E-07
      0.00000000000000E+00  -7.52208397729644E-14   0.00000000000000E+00   2.93296505857056E-16  -8.08513685702636E-24
      7.52409919581202E-11   7.52412852546180E-11  -1.30572364856066E-18  -7.53522805660635E-03  -7.53522805663195E-03
      0.00000000000000E+00   0.00000000000000E+00   2.56041020746090E-11   0.00000000000000E+00   2.56041020746090E-11
      5.30548915449586E-18  -3.37253538754560E-01  -3.37221768947815E-01   0.00000000000000E+00  -5.15499288953146E-13
     -1.25371931755381E-22  -1.00329888040148E-10  -1.00845387329227E-10  -3.99976550593520E-18
      7.99389104328083E-07
      0.00000000000000E+00  -8.24765740123590E-14   0.00000000000000E+00   2.71582557171791E-16   7.55707549232512E-24
      8.24908698530726E-11   8.24911414356373E-11  -1.30293789726332E-18  -7.43668054129250E-03  -7.43668054131643E-03
      0.00000000000000E+00   0.00000000000000E+00   2.39210098432141E-11   0.00000000000000E+00   2.39210098432141E-11
      5.35333117418229E-18  -3.61444126485853E-01  -3.61410603264729E-01   0.00000000000000E+00  -5.35515492865305E-13
     -1.27828344985453E-22  -1.05876635785858E-10  -1.06412151278851E-10  -4.05039327691896E-18
      8.01389104328083E-07
      0.00000000000000E+00  -8.96404635145461E-14   0.00000000000000E+00   2.61369507459881E-16   2.44136854782450E-23
      8.96571872965137E-11   8.96574486660456E-11  -1.30027931355793E-18  -7.38289033387454E-03  -7.38289033389697E-03
      0.00000000000000E+00   0.00000000000000E+00   2.24347830375236E-11   0.00000000000000E+00   2.24347830375236E-11
      5.39820074025733E-18  -3.85099092251407E-01  -3.85063779957570E-01   0.00000000000000E+00  -5.57128603676494E-13
     -1.30323040437137E-22  -1.11535103099763E-10  -1.12092231703569E-10  -4.09792142669941E-18
      8.03389104328083E-07
      0.00000000000000E+00  -9.67125082795257E-14   0.00000000000000E+00   2.51018789246775E-16   4.13704036326188E-23
      9.67114312846746E-11   9.67116823035053E-11  -1.29777881884784E-18  -7.34430793067771E-03  -7.34430793069897E-03
      0.00000000000000E+00   0.00000000000000E+00   2.12541855630979E-11   0.00000000000000E+00   2.12541855630979E-11
      5.44070911138353E-18  -4.08351388038967E-01  -4.08314225736686E-01   0.00000000000000E+00  -5.86975796694628E-13
     -1.32886364261330E-22  -1.17378892069776E-10  -1.17965867866604E-10  -4.14293029253569E-18
      8.05389104328083E-07
      0.00000000000000E+00  -1.03692708307298E-13   0.00000000000000E+00   2.43552580442511E-16   5.75216906241447E-23
      1.03702454044407E-10   1.03702697597045E-10  -1.29542524297381E-18  -7.31587184051800E-03  -7.31587184053822E-03
      0.00000000000000E+00   0.00000000000000E+00   2.02168488226521E-11   0.00000000000000E+00   2.02168488226521E-11
      5.48114280902884E-18  -4.31244776788710E-01  -4.31205739311802E-01   0.00000000000000E+00  -6.22115805235309E-13
     -1.35530716596391E-22  -1.23297430614326E-10  -1.23919546419697E-10  -4.18571756605502E-18
      8.07389104328083E-07
      0.00000000000000E+00  -1.10672908335070E-13   0.00000000000000E+00   2.37260490505488E-16   7.21488282883272E-23
      1.10630516019387E-10   1.10630753279950E-10  -1.29320427868352E-18  -7.29821833080063E-03  -7.29821833081982E-03
      0.00000000000000E+00   0.00000000000000E+00   1.91946540611034E-11   0.00000000000000E+00   1.91946540611034E-11
      5.51953211715104E-18  -4.53708375973687E-01  -4.53667478442791E-01   0.00000000000000E+00  -6.58277072446531E-13
     -1.38246082560898E-22  -1.29167130268469E-10  -1.29825407341053E-10  -4.22632783846752E-18
      8.09389104328083E-07
      0.00000000000000E+00  -1.17469418888427E-13   0.00000000000000E+00   2.32255119851552E-16   8.48457628809319E-23
      1.17505022009487E-10   1.17505254264691E-10  -1.29109641901535E-18  -7.29386684247728E-03  -7.29386684249548E-03
      0.00000000000000E+00   0.00000000000000E+00   1.82018452602793E-11   0.00000000000000E+00   1.82018452602793E-11
      5.55593580767160E-18  -4.75722566557981E-01  -4.75679816646349E-01   0.00000000000000E+00  -6.96524300298135E-13
     -1.41023860139056E-22  -1.35010575224532E-10  -1.35707099524971E-10  -4.26483938865625E-18
      8.11389104328083E-07
      0.00000000000000E+00  -1.24357774178991E-13   0.00000000000000E+00   2.28803409829345E-16   9.55184477256912E-23
      1.24346377771772E-10   1.24346606575278E-10  -1.28907737717777E-18  -7.30759053776733E-03  -7.30759053778458E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72445945012670E-11   0.00000000000000E+00   1.72445945012670E-11
      5.59042499667413E-18  -4.97289631963399E-01  -4.97245028975555E-01   0.00000000000000E+00  -7.36569589268400E-13
     -1.43851468717928E-22  -1.40854631487132E-10  -1.41591201076544E-10  -4.30134761949636E-18
      8.13389104328083E-07
      0.00000000000000E+00  -1.31154284732348E-13   0.00000000000000E+00   2.27718831595309E-16   1.04312931968080E-22
      1.31198426807932E-10   1.31198654526868E-10  -1.28711395487679E-18  -7.34850946319552E-03  -7.34850946321184E-03
      0.00000000000000E+00   0.00000000000000E+00   1.63212754329283E-11   0.00000000000000E+00   1.63212754329283E-11
      5.62306754753999E-18  -5.18417595898579E-01  -5.18371125844216E-01   0.00000000000000E+00  -7.77165495328753E-13
     -1.46710324939547E-22  -1.46742764464321E-10  -1.47519929959796E-10  -4.33595359266320E-18
      8.15389104328083E-07
      0.00000000000000E+00  -1.38410018971743E-13   0.00000000000000E+00   2.43320230453814E-16   1.11711449023192E-22
      1.38441215935045E-10   1.38441459255387E-10  -1.28503132123255E-18  -7.49187145361258E-03  -7.49187145362790E-03
      0.00000000000000E+00   0.00000000000000E+00   1.53202795836970E-11   0.00000000000000E+00   1.53202795836970E-11
      5.65370810670738E-18  -5.39115246476843E-01  -5.39066810808572E-01   0.00000000000000E+00  -8.13851440263860E-13
     -1.49567764947666E-22  -1.52947887398671E-10  -1.53761738839084E-10  -4.36867678547483E-18
      8.17389104328083E-07
      0.00000000000000E+00  -1.46951579532043E-13   0.00000000000000E+00   3.17228933666971E-16   1.18485497722143E-22
      1.46914396011337E-10   1.46914713240390E-10  -1.28245163570702E-18  -7.90234047525768E-03  -7.90234047527176E-03
      0.00000000000000E+00   0.00000000000000E+00   1.40809054442219E-11   0.00000000000000E+00   1.40809054442219E-11
      5.68186991759583E-18  -5.59390152419117E-01  -5.59339438724177E-01   0.00000000000000E+00  -8.40382907265700E-13
     -1.52376840351550E-22  -1.60155235777194E-10  -1.60995618684612E-10  -4.39941828188881E-18
      8.19389104328083E-07
      0.00000000000000E+00  -1.61371203273625E-13   0.00000000000000E+00   5.40669792278841E-16   1.27608697412243E-22
      1.61364537156326E-10   1.61365077826246E-10  -1.27748762215751E-18  -9.43592990690558E-03  -9.43592990691694E-03
      0.00000000000000E+00   0.00000000000000E+00   1.13605178232205E-11   0.00000000000000E+00   1.13605178232205E-11
      5.70459095324227E-18  -5.79242897198193E-01  -5.79188489330489E-01   0.00000000000000E+00  -8.19922894964972E-13
     -1.54987281439631E-22  -1.71905672754345E-10  -1.72725595649465E-10  -4.42710333108476E-18
      8.21389104328083E-07
      0.00000000000000E+00  -2.31724271974590E-13   0.00000000000000E+00   2.64107971202408E-15   1.65034135950611E-22
      2.31678627856934E-10   2.31681268936811E-10  -1.25374259900108E-18  -1.95119114089491E-02  -1.95119114089443E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.84439582529828E-12   0.00000000000000E+00  -4.84439582529828E-12
      5.69490216159167E-18  -5.98600466473543E-01  -5.98529015031121E-01   0.00000000000000E+00  -4.14109993854353E-13
     -1.56256834288652E-22  -2.26422763117503E-10  -2.26836873111513E-10  -4.44115956259059E-18
      8.23389104328083E-07
      0.00000000000000E+00  -5.16442957317923E-13   0.00000000000000E+00   9.23327610448113E-15   2.62169298235652E-22
      5.16426148147425E-10   5.16435381423792E-10  -1.18830083830987E-18  -4.71710943432563E-02  -4.71710943432155E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.07990774607374E-11   0.00000000000000E+00  -4.07990774607374E-11
      5.61330400667020E-18  -6.17095919003339E-01  -6.16946098739188E-01   0.00000000000000E+00   4.45349039668979E-13
     -1.54878562076414E-22  -4.76081653002570E-10  -4.75636303963056E-10  -4.42500316836033E-18
      8.25389104328083E-07
      0.00000000000000E+00  -1.09754460962994E-12   0.00000000000000E+00   1.63199434404189E-14   3.31908650852775E-22
      1.09748687727260E-09   1.09750319721637E-09  -1.11390798790641E-18  -7.69580292431110E-02  -7.69580292430573E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.36696248376797E-11   0.00000000000000E+00  -5.36696248376797E-11
      5.50596475699484E-18  -6.34127883943872E-01  -6.33799084716947E-01   0.00000000000000E+00   4.90439599325394E-13
     -1.53314640625262E-22  -1.04432401197787E-09  -1.04383357237869E-09  -4.39205676908842E-18
      8.27389104328083E-07
      0.00000000000000E+00  -2.19609951136917E-12   0.00000000000000E+00   2.87529114170487E-14   3.75840725592107E-22
      2.19602860055664E-09   2.19605735346843E-09  -1.04162943103403E-18  -1.06420548884869E-01  -1.06420548884805E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.35955032637367E-11   0.00000000000000E+00  -6.35955032637367E-11
      5.37877375046736E-18  -6.48716879840607E-01  -6.48045166353966E-01   0.00000000000000E+00   4.10718648615284E-13
     -1.51946681763936E-22  -2.13287256885316E-09  -2.13246185020470E-09  -4.33714431943333E-18
      8.29389104328083E-07
      0.00000000000000E+00  -4.08745818468377E-12   0.00000000000000E+00   4.80751959347210E-14   4.09964815568007E-22
      4.08744504660832E-09   4.08749312180466E-09  -9.75779586741280E-19  -1.35373475841651E-01  -1.35373475841575E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.59987192414979E-11   0.00000000000000E+00  -7.59987192414979E-11
      5.22677631198437E-18  -6.59379531731031E-01  -6.58115926154455E-01   0.00000000000000E+00   3.13065811660211E-13
     -1.50840933170258E-22  -4.01180746837468E-09  -4.01149440256317E-09  -4.25099672524309E-18
      8.31389104328083E-07
      0.00000000000000E+00  -7.01721345686667E-12   0.00000000000000E+00   7.34947735076916E-14   4.36347681995291E-22
      7.01712970096994E-09   7.01720319574388E-09  -9.17220297092737E-19  -1.63756168615082E-01  -1.63756168614991E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.12264198625777E-11   0.00000000000000E+00  -9.12264198625777E-11
      5.04432347225921E-18  -6.64186354558192E-01  -6.62004686968625E-01   0.00000000000000E+00   2.40456128448273E-13
     -1.49922325695762E-22  -6.92621723200961E-09  -6.92597677588131E-09  -4.12710317516648E-18
      8.33389104328084E-07
      0.00000000000000E+00  -1.11603295522982E-11   0.00000000000000E+00   1.03286701074743E-13   4.52238310523831E-22
      1.11602008360778E-08   1.11603041227793E-08  -8.64564577314409E-19  -1.91555794723069E-01  -1.91555794722961E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07124890821065E-10   0.00000000000000E+00  -1.07124890821065E-10
      4.83007369061708E-18  -6.60901206797400E-01  -6.57419457681280E-01   0.00000000000000E+00   2.88701238437640E-13
     -1.48778883056654E-22  -1.10534679331966E-08  -1.10531792319583E-08  -3.96550911330267E-18
      8.35389104328084E-07
      0.00000000000000E+00  -1.66887398190309E-11   0.00000000000000E+00   1.37398480092525E-13   4.55997857770518E-22
      1.66885725601352E-08   1.66887099586157E-08  -8.15754210861395E-19  -2.18779836609114E-01  -2.18779836608993E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20908739492785E-10   0.00000000000000E+00  -1.20908739492785E-10
      4.58825621163152E-18  -6.46991040775586E-01  -6.41772130225493E-01   0.00000000000000E+00   5.59429806238115E-13
     -1.46596473346862E-22  -1.65683606489290E-08  -1.65678012191229E-08  -3.77250200077012E-18
      8.37389104328084E-07
      0.00000000000000E+00  -2.38614464159899E-11   0.00000000000000E+00   1.78012679407851E-13   4.47839214882758E-22
      2.38612281185634E-08   2.38614061312433E-08  -7.69017720107263E-19  -2.45442754889621E-01  -2.45442754889490E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.31318386170283E-10   0.00000000000000E+00  -1.31318386170283E-10
      4.32561943929095E-18  -6.19463291732421E-01  -6.11988092626571E-01   0.00000000000000E+00   1.07102840531083E-12
     -1.42317093307035E-22  -2.37311587734782E-08  -2.37300877450730E-08  -3.55660171918368E-18
      8.39389104328084E-07
      0.00000000000000E+00  -3.29929257233738E-11   0.00000000000000E+00   2.26555998436276E-13   4.28141069114538E-22
      3.29927427727062E-08   3.29929693287051E-08  -7.23180999064754E-19  -2.71558413847330E-01  -2.71558413847190E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.39348464523970E-10   0.00000000000000E+00  -1.39348464523970E-10
      4.04692251024301E-18  -5.74765376749606E-01  -5.64415867013336E-01   0.00000000000000E+00   1.68351138685572E-12
     -1.35009515967399E-22  -3.28553043755678E-08  -3.28536208641811E-08  -3.32374151117825E-18
      8.41389104328084E-07
      0.00000000000000E+00  -4.41709813099530E-11   0.00000000000000E+00   2.77490390251062E-13   3.92387032428538E-22
      4.41706853137515E-08   4.41709628041422E-08  -6.77751323584676E-19  -2.97135237833380E-01  -2.97135237833232E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.48023820057880E-10   0.00000000000000E+00  -1.48023820057880E-10
      3.75087487012725E-18  -5.09221765988846E-01  -4.95353180517021E-01   0.00000000000000E+00   2.08804142074698E-12
     -1.24734050913381E-22  -4.40250270255049E-08  -4.40229389840843E-08  -3.07312354654257E-18
      8.43389104328084E-07
      0.00000000000000E+00  -5.67569248731865E-11   0.00000000000000E+00   3.12869110388180E-13   3.27411825894896E-22
      5.67566248536971E-08   5.67569377228078E-08  -6.32802209497675E-19  -3.22176519649938E-01  -3.22176519649778E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.60091428739798E-10   0.00000000000000E+00  -1.60091428739798E-10
      3.43069201264765E-18  -4.20411890221272E-01  -4.02581447902549E-01   0.00000000000000E+00   2.05385317218898E-12
     -1.13142385418394E-22  -5.65989001472402E-08  -5.65968462940681E-08  -2.79788980314997E-18
      8.45389104328084E-07
      0.00000000000000E+00  -6.92588305018750E-11   0.00000000000000E+00   3.11371805046841E-13   2.54925633220436E-22
      6.92585001004379E-08   6.92588114722432E-08  -5.88348031166584E-19  -3.46690743371643E-01  -3.46690743371470E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.72988557059928E-10   0.00000000000000E+00  -1.72988557059928E-10
      3.08471489852780E-18  -3.08865711428758E-01  -2.87099940805787E-01   0.00000000000000E+00   1.76707189969304E-12
     -1.00242953222337E-22  -6.90875899870829E-08  -6.90858229151833E-08  -2.49636686736121E-18
      8.47389104328084E-07
      0.00000000000000E+00  -7.74648822371559E-11   0.00000000000000E+00   2.04886132235559E-13   1.82690281626892E-22
      7.74646593185500E-08   7.74648642046824E-08  -5.44883617685964E-19  -3.70672448094862E-01  -3.70672448094668E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.93817090431497E-10   0.00000000000000E+00  -1.93817090431497E-10
      2.69708071766480E-18  -1.83454975622225E-01  -1.59109787064169E-01   0.00000000000000E+00   1.19052973059061E-12
     -8.56616457035621E-23  -7.72722376439814E-08  -7.72710471142509E-08  -2.15219709997883E-18
      8.49389104328084E-07
      0.00000000000000E+00  -7.01603784423041E-11   0.00000000000000E+00  -1.81454675617504E-13   6.81471908718330E-23
      7.01606354910724E-08   7.01604540363969E-08  -5.00548574097533E-19  -3.94146437261784E-01  -3.94146437261576E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.07198997692865E-10   0.00000000000000E+00  -2.07198997692865E-10
      2.28268272227907E-18  -7.46958330639688E-02  -5.26559273725675E-02   0.00000000000000E+00   8.12905080085649E-13
     -5.69624085221471E-23  -6.99540679437840E-08  -6.99532550387040E-08  -1.78213414818154E-18
      8.51389104328084E-07
      0.00000000000000E+00  -3.91191533845902E-11   0.00000000000000E+00  -7.70032457668523E-13   1.90823263201037E-23
      3.91199197387532E-08   3.91191497062955E-08  -4.44759270920345E-19  -4.17270191608854E-01  -4.17270191608709E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.45142386229436E-10   0.00000000000000E+00  -1.45142386229436E-10
      1.99239794982020E-18  -2.85275287251099E-02  -1.62480887781912E-02   0.00000000000000E+00   9.45438742005217E-13
     -1.90111696535121E-23  -3.89749527588081E-08  -3.89740073200661E-08  -1.54763867889985E-18
      8.53389104328084E-07
      0.00000000000000E+00  -2.30898587787094E-11   0.00000000000000E+00  -3.95926696526808E-13   7.86373102276884E-24
      2.30902402992159E-08   2.30898443725194E-08  -3.87469551193203E-19  -4.40002263529461E-01  -4.40002263529353E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07728857925470E-10   0.00000000000000E+00  -1.07728857925470E-10
      1.77694023396926E-18  -1.44724834690395E-02  -7.23155596396189E-03   0.00000000000000E+00   4.65595032751961E-13
     -8.58775042594810E-24  -2.29825811096266E-08  -2.29821155145939E-08  -1.38947068277605E-18
      8.55389104328084E-07
      0.00000000000000E+00  -1.81070062509895E-11   0.00000000000000E+00  -1.22627612708085E-13   4.94647268583383E-24
      1.81070947689371E-08   1.81069721413244E-08  -3.32672979438636E-19  -4.62292268539891E-01  -4.62292268539791E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.99695285813448E-11   0.00000000000000E+00  -9.99695285813448E-11
      1.57700117680657E-18  -1.03848978879781E-02  -4.71146306390937E-03   0.00000000000000E+00   1.68529849469597E-13
     -5.51319106541838E-24  -1.80071711425925E-08  -1.80070026127431E-08  -1.24432819736793E-18
      8.57389104328084E-07
      0.00000000000000E+00  -1.67369583060648E-11   0.00000000000000E+00  -3.34542360002024E-14   3.89720737884019E-24
      1.67369655665778E-08   1.67369321123418E-08  -2.80475703012194E-19  -4.84132445336221E-01  -4.84132445336120E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00603396681731E-10   0.00000000000000E+00  -1.00603396681731E-10
      1.37579438344311E-18  -9.03406961742939E-03  -3.79248646880430E-03   0.00000000000000E+00   7.06040887821871E-14
     -4.31444111493426E-24  -1.66363993197489E-08  -1.66363287156601E-08  -1.09531868043091E-18
      8.59389104328084E-07
      0.00000000000000E+00  -1.63535983729606E-11   0.00000000000000E+00  -9.14195121924755E-15   3.36205476166080E-24
      1.63535582677870E-08   1.63535491258358E-08  -2.30782406940800E-19  -5.05528302404406E-01  -5.05528302404303E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02910673398982E-10   0.00000000000000E+00  -1.02910673398982E-10
      1.16997303664514E-18  -8.44788135153485E-03  -3.32781367136627E-03   0.00000000000000E+00   4.12308978681362E-14
     -3.66406749530691E-24  -1.62506796833347E-08  -1.62506384524368E-08  -9.39190629704341E-19
      8.61389104328084E-07
      0.00000000000000E+00  -1.62279547724607E-11   0.00000000000000E+00  -2.81288915015397E-15   3.01729066300716E-24
      1.62279564072460E-08   1.62279535943569E-08  -1.83492026323927E-19  -5.26488563334272E-01  -5.26488563334167E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05135258634320E-10   0.00000000000000E+00  -1.05135258634320E-10
      9.59702519376502E-19  -8.11196932143428E-03  -3.03217086743462E-03   0.00000000000000E+00   3.12264665121215E-14
     -3.22754097676045E-24  -1.61228495621891E-08  -1.61228183357225E-08  -7.76210493052575E-19
      8.63389104328084E-07
      0.00000000000000E+00  -1.61741337564571E-11   0.00000000000000E+00  -1.06840161795578E-15   2.76754287871145E-24
      1.61741434556878E-08   1.61741423872862E-08  -1.38470762897380E-19  -5.47021681512628E-01  -5.47021681512521E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06865457697735E-10   0.00000000000000E+00  -1.06865457697735E-10
      7.45971603981033E-19  -7.88330646296585E-03  -2.82100530609531E-03   0.00000000000000E+00   2.65847156160384E-14
     -2.90481586780843E-24  -1.60673035143041E-08  -1.60672769295885E-08  -6.07500841083651E-19
      8.65389104328084E-07
      0.00000000000000E+00  -1.61444679063391E-11   0.00000000000000E+00  -4.94304541415636E-16   2.57558836893130E-24
      1.61444980019075E-08   1.61444975076030E-08  -9.55616456965590E-20  -5.67133952293214E-01  -5.67133952293106E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08038726614441E-10   0.00000000000000E+00  -1.08038726614441E-10
      5.29894150752151E-19  -7.71356863135275E-03  -2.66097544056751E-03   0.00000000000000E+00   2.36579908010071E-14
     -2.65484011660503E-24  -1.60364824389794E-08  -1.60364587809886E-08  -4.34332505055592E-19
      8.67389104328084E-07
      0.00000000000000E+00  -1.61253642009999E-11   0.00000000000000E+00  -2.53787045949002E-16   2.42270753943034E-24
      1.61253690943610E-08   1.61253688405740E-08  -5.46302805022809E-20  -5.86815656067448E-01  -5.86815656067339E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08609814588811E-10   0.00000000000000E+00  -1.08609814588811E-10
      3.12674521574529E-19  -7.58125311481939E-03  -2.53486500292755E-03   0.00000000000000E+00   2.14668758939594E-14
     -2.45551089373897E-24  -1.60167804928610E-08  -1.60167590259851E-08  -2.58044241072249E-19
      8.69389104328084E-07
      0.00000000000000E+00  -1.61108527325211E-11   0.00000000000000E+00  -1.56496321231318E-16   2.29849757503812E-24
      1.61108555342155E-08   1.61108553777191E-08  -1.58764103651623E-20  -6.05891266709369E-01  -6.05891266709262E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07694641371974E-10   0.00000000000000E+00  -1.07694641371974E-10
      9.72852388305817E-20  -7.47461313871124E-03  -2.43250800840436E-03   0.00000000000000E+00   1.95251409555279E-14
     -2.29411601866673E-24  -1.60031802614881E-08  -1.60031607363472E-08  -8.14088284654190E-20
      8.71389104328084E-07
      0.00000000000000E+00  -1.60882589271680E-11   0.00000000000000E+00  -3.77232673846309E-16   2.20555371063913E-24
      1.60882364536588E-08   1.60882360764261E-08   1.99698640946640E-20  -6.23901283092146E-01  -6.23901283092042E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03587118507372E-10   0.00000000000000E+00  -1.03587118507372E-10
     -1.09888998184162E-19  -7.40330767979149E-03  -2.36703388086672E-03   0.00000000000000E+00   1.76510388710932E-14
     -2.17510637632777E-24  -1.59846666089576E-08  -1.59846489579187E-08   8.99191340894993E-20
      8.73389104328084E-07
      0.00000000000000E+00  -1.60650222086545E-11   0.00000000000000E+00  -4.15589084184155E-16   2.13640446524034E-24
      1.60650437857028E-08   1.60650433701138E-08   5.16847633007288E-20  -6.40118920874678E-01  -6.40118920874583E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.47095744610972E-11   0.00000000000000E+00  -9.47095744610972E-11
     -2.99308147106357E-19  -7.35889246699141E-03  -2.32712796545174E-03   0.00000000000000E+00   1.51831386877986E-14
     -2.08797061669624E-24  -1.59703489787913E-08  -1.59703337956527E-08   2.47623383805628E-19
      8.75389104328084E-07
      0.00000000000000E+00  -1.60420610243527E-11   0.00000000000000E+00  -4.42558803061016E-16   2.08384706351972E-24
      1.60420799939027E-08   1.60420795513439E-08   7.72316856491297E-20  -6.53371204901856E-01  -6.53371204901778E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.83360831566009E-11   0.00000000000000E+00  -7.83360831566009E-11
     -4.55980313419559E-19  -7.32618166765757E-03  -2.29649280891197E-03   0.00000000000000E+00   1.18901784510838E-14
     -2.02299428180816E-24  -1.59637553583657E-08  -1.59637434681873E-08   3.78748627770429E-19
      8.76389104328084E-07
      0.00000000000000E+00  -1.60268147979762E-11   0.00000000000000E+00  -6.51158551104946E-16   2.06221099835244E-24
      1.60268168801066E-08   1.60268162289481E-08   8.78478769216846E-20  -6.58925933166612E-01  -6.58925933166546E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.61439460153366E-11   0.00000000000000E+00  -6.61439460153366E-11
     -5.22124259434895E-19  -7.31246766470291E-03  -2.28374612710611E-03   0.00000000000000E+00   9.79089540117657E-15
     -1.99714769968446E-24  -1.59606820738281E-08  -1.59606722829327E-08   4.34276382513211E-19
      8.77739104328084E-07
      0.00000000000000E+00  -1.60010982715581E-11   0.00000000000000E+00  -8.72175699583963E-16   2.04178790509396E-24
      1.60011011715651E-08   1.60011002993894E-08   9.74274032044241E-20  -6.63961185275982E-01  -6.63961185275938E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.45909607534902E-11   0.00000000000000E+00  -4.45909607534902E-11
     -5.82322056452107E-19  -7.29881482810197E-03  -2.27140462351226E-03   0.00000000000000E+00   6.55697278200424E-15
     -1.97398872700024E-24  -1.59565158956087E-08  -1.59565093386359E-08   4.84894653247683E-19
      8.79561604328084E-07
      0.00000000000000E+00  -1.59563698845380E-11   0.00000000000000E+00  -1.20274848103191E-15   2.03307740225837E-24
      1.59563294984582E-08   1.59563282957097E-08   9.92479549073110E-20  -6.64918369243832E-01  -6.64918369243825E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.31321227277525E-12   0.00000000000000E+00  -6.31321227277525E-12
     -5.93827885819240E-19  -7.29073117763390E-03  -2.26536705605869E-03   0.00000000000000E+00   1.07579018531931E-15
     -1.96856847819322E-24  -1.59500161592271E-08  -1.59500150834369E-08   4.94579930911928E-19
      8.81561604328084E-07
      0.00000000000000E+00  -1.58919867237556E-11   0.00000000000000E+00  -1.66417668531985E-15   2.05304212461120E-24
      1.58919437872027E-08   1.58919421230260E-08   8.36379663643405E-20  -6.56711914499122E-01  -6.56711914499171E-01
      0.00000000000000E+00   0.00000000000000E+00   4.89819135511684E-11   0.00000000000000E+00   4.89819135511684E-11
     -4.95864058716903E-19  -7.29798902271212E-03  -2.27548966098998E-03   0.00000000000000E+00  -6.82116511285065E-15
     -2.00364737291174E-24  -1.59409172154121E-08  -1.59409240365772E-08   4.12226092352562E-19
      8.83561604328085E-07
      0.00000000000000E+00  -1.58086835471083E-11   0.00000000000000E+00  -2.26502138396654E-15   2.11606776338388E-24
      1.58086360070015E-08   1.58086337419802E-08   4.47083060507794E-20  -6.36514111380958E-01  -6.36514111381078E-01
      0.00000000000000E+00   0.00000000000000E+00   1.19317638399177E-10   0.00000000000000E+00   1.19317638399177E-10
     -2.57228781918549E-19  -7.32872370140109E-03  -2.31031277336732E-03   0.00000000000000E+00  -1.75298918460102E-14
     -2.10045342293555E-24  -1.59279338504875E-08  -1.59279513803793E-08   2.12520475867770E-19
      8.85561604328085E-07
      0.00000000000000E+00  -1.56912141282199E-11   0.00000000000000E+00  -3.58350800159288E-15   2.26245789209501E-24
      1.56912078077263E-08   1.56912042242183E-08  -2.55955191956057E-20  -6.01043948412084E-01  -6.01043948412289E-01
      0.00000000000000E+00   0.00000000000000E+00   2.04631133888586E-10   0.00000000000000E+00   2.04631133888586E-10
      1.52033485858622E-19  -7.41998279222545E-03  -2.41169277976340E-03   0.00000000000000E+00  -3.24077503095982E-14
     -2.32325604592953E-24  -1.58958029503566E-08  -1.58958353581069E-08  -1.26437966663015E-19
      8.87561604328085E-07
      0.00000000000000E+00  -1.54931050300633E-11   0.00000000000000E+00  -6.04961515947403E-15   2.62604574552592E-24
      1.54931287065312E-08   1.54931226569160E-08  -1.39380518106093E-19  -5.46564473617508E-01  -5.46564473617807E-01
      0.00000000000000E+00   0.00000000000000E+00   2.99046074386198E-10   0.00000000000000E+00   2.99046074386198E-10
      7.50125634631018E-19  -7.71050052490409E-03  -2.73487720245163E-03   0.00000000000000E+00  -5.56562932069527E-14
     -2.90804252470040E-24  -1.57921130750090E-08  -1.57921687313022E-08  -6.10745116524925E-19
      8.89561604328085E-07
      0.00000000000000E+00  -1.50829264336945E-11   0.00000000000000E+00  -1.13378392316881E-14   3.58746055458894E-24
      1.50828899670599E-08   1.50828786292206E-08  -3.14326268790833E-19  -4.69791859369779E-01  -4.69791859370156E-01
      0.00000000000000E+00   0.00000000000000E+00   3.77923739504862E-10   0.00000000000000E+00   3.77923739504862E-10
      1.50597311364074E-18  -8.64139455766542E-03  -3.77018481589617E-03   0.00000000000000E+00  -9.87902329283270E-14
     -4.91257046748514E-24  -1.54607035784925E-08  -1.54608023687255E-08  -1.19164684484991E-18
      8.91561604328085E-07
      0.00000000000000E+00  -1.28445783432098E-11   0.00000000000000E+00  -5.74037437009999E-14   5.79483992980757E-24
      1.28445935044114E-08   1.28445361006677E-08  -5.60925257075384E-19  -3.69456188817678E-01  -3.69456188818077E-01
      0.00000000000000E+00   0.00000000000000E+00   3.99469480153437E-10   0.00000000000000E+00   3.99469480153437E-10
      2.30491207394762E-18  -1.38841294443247E-02  -9.71138362573780E-03   0.00000000000000E+00  -1.77855642892555E-13
     -2.00889779852073E-23  -1.32438277251782E-08  -1.32440055808211E-08  -1.74398681687223E-18
      8.93561604328085E-07
      0.00000000000000E+00  -3.18003218107341E-12   0.00000000000000E+00  -2.42567528432904E-13  -1.97407308472880E-23
      3.18029398919042E-09   3.18005142166197E-09  -8.28884735732025E-19  -2.49208499115750E-01  -2.49208499116160E-01
      0.00000000000000E+00   0.00000000000000E+00   4.09259017310737E-10   0.00000000000000E+00   4.09259017310737E-10
      3.12343010856909E-18  -3.78835950464029E-02  -3.67527358025279E-02   0.00000000000000E+00  -3.43196263971972E-13
     -7.71331385142248E-23  -3.58896724270866E-09  -3.58931043897271E-09  -2.29454537283707E-18
      8.95561604328085E-07
      0.00000000000000E+00  -4.48202317572731E-14   0.00000000000000E+00  -8.43045858237825E-14  -4.35717302549946E-23
      4.49195259551891E-11   4.48352213693218E-11  -1.08674506608597E-18  -1.24137985592048E-01  -1.24137985592425E-01
      0.00000000000000E+00   0.00000000000000E+00   3.76404766226504E-10   0.00000000000000E+00   3.76404766226504E-10
      3.87623964102210E-18  -6.75883122675292E-02  -6.74555963223775E-02   0.00000000000000E+00  -1.02034528663371E-12
     -9.25353542873653E-23  -4.20219642309099E-10  -4.21239987595826E-10  -2.78949457493613E-18
      8.97561604328085E-07
      0.00000000000000E+00   7.35676345032289E-14   0.00000000000000E+00  -8.68195685370708E-15  -4.60083896096289E-23
     -7.35350983402155E-11  -7.35437802971152E-11  -1.24232195895246E-18  -4.62337919631918E-02  -4.62337919634372E-02
      0.00000000000000E+00   0.00000000000000E+00   2.45417074321277E-10   0.00000000000000E+00   2.45417074321277E-10
      4.36707378966465E-18  -9.71804086003823E-02  -9.71262582294587E-02   0.00000000000000E+00  -1.14336986280557E-12
     -1.02085829900785E-22  -1.70729924161254E-10  -1.71873294024162E-10  -3.12475183071219E-18
      8.99561604328085E-07
      0.00000000000000E+00   2.64512843157677E-14   0.00000000000000E+00  -3.30546613206804E-16  -4.63932666831629E-23
     -2.64623959602042E-11  -2.64627265068638E-11  -1.29810861848903E-18  -1.96449318989166E-02  -1.96449318990470E-02
      0.00000000000000E+00   0.00000000000000E+00   1.30434607841580E-10   0.00000000000000E+00   1.30434607841580E-10
      4.62794300534781E-18  -1.26302946912516E-01  -1.26270189889974E-01   0.00000000000000E+00  -6.66764077678460E-13
     -1.06435983786850E-22  -1.03305117256931E-10  -1.03971881334716E-10  -3.32983438685879E-18
      9.01561604328085E-07
      0.00000000000000E+00  -2.02058421856559E-15   0.00000000000000E+00   8.73743596942298E-16  -4.62405842677916E-23
      2.05252003129331E-12   2.05339377484401E-12  -1.31572455162164E-18  -1.19100127066099E-02  -1.19100127066904E-02
      0.00000000000000E+00   0.00000000000000E+00   8.05007483800729E-11   0.00000000000000E+00   8.05007483800729E-11
      4.78894450210796E-18  -1.54868076738679E-01  -1.54842067791723E-01   0.00000000000000E+00  -4.53211521578955E-13
     -1.09101660614098E-22  -8.21009306332292E-11  -8.25541421549173E-11  -3.47321995048632E-18
      9.02561604328085E-07
      0.00000000000000E+00  -1.25827289974312E-14   0.00000000000000E+00   9.82811015491034E-16  -4.60022867142461E-23
      1.26120057318871E-11   1.26129885428566E-11  -1.31961001603444E-18  -1.02000006061229E-02  -1.02000006061884E-02
      0.00000000000000E+00   0.00000000000000E+00   6.55154579897607E-11   0.00000000000000E+00   6.55154579897607E-11
      4.85445996009772E-18  -1.69004510791644E-01  -1.68979896285179E-01   0.00000000000000E+00  -4.16332295453447E-13
     -1.10276287252324E-22  -7.77121142370512E-11  -7.81284465326149E-11  -3.53484994406328E-18
      9.03911604328085E-07
      0.00000000000000E+00  -2.30530290390892E-14   0.00000000000000E+00   8.59884318518502E-16  -4.54255860642253E-23
      2.30733801930886E-11   2.30742400773617E-11  -1.32099194958549E-18  -9.22385525974267E-03  -9.22385525979661E-03
      0.00000000000000E+00   0.00000000000000E+00   5.39350076235416E-11   0.00000000000000E+00   5.39350076235416E-11
      4.92727222038950E-18  -1.87820939006056E-01  -1.87796677231308E-01   0.00000000000000E+00  -4.11279315168948E-13
     -1.11803747389499E-22  -7.65979683856232E-11  -7.70092477009039E-11  -3.60628027080402E-18
      9.05734104328085E-07
      0.00000000000000E+00  -3.40743975039924E-14   0.00000000000000E+00   6.71570087723012E-16  -4.39944463230304E-23
      3.40518702073136E-11   3.40525417773573E-11  -1.31999555467792E-18  -8.61391802267852E-03  -8.61391802272302E-03
      0.00000000000000E+00   0.00000000000000E+00   4.45064338125335E-11   0.00000000000000E+00   4.45064338125335E-11
      5.00838519601284E-18  -2.12743043246785E-01  -2.12718293399224E-01   0.00000000000000E+00  -4.27198857124212E-13
     -1.13884379733095E-22  -7.81317767326525E-11  -7.85589755898905E-11  -3.68838964133492E-18
      9.07734104328085E-07
      0.00000000000000E+00  -4.41773185968204E-14   0.00000000000000E+00   5.21559386139973E-16  -4.11103441792476E-23
      4.41746961260263E-11   4.41752176853714E-11  -1.31747477026700E-18  -8.22882923825409E-03  -8.22882923829182E-03
      0.00000000000000E+00   0.00000000000000E+00   3.77363907277244E-11   0.00000000000000E+00   3.77363907277244E-11
      5.08385797746829E-18  -2.39528822558570E-01  -2.39503016675813E-01   0.00000000000000E+00  -4.47829534757769E-13
     -1.16206600233633E-22  -8.14637788782221E-11  -8.19116084130961E-11  -3.76638320720129E-18
      9.09734104328085E-07
      0.00000000000000E+00  -5.31781028431580E-14   0.00000000000000E+00   4.22440878101266E-16  -3.62446606581061E-23
      5.31688777078151E-11   5.31693001486570E-11  -1.31441337934189E-18  -7.96942655689715E-03  -7.96942655693020E-03
      0.00000000000000E+00   0.00000000000000E+00   3.30487419953708E-11   0.00000000000000E+00   3.30487419953708E-11
      5.14995546145903E-18  -2.65765221701001E-01  -2.65738059325368E-01   0.00000000000000E+00  -4.66832624372406E-13
     -1.18560231666153E-22  -8.57512095195363E-11  -8.62180421440273E-11  -3.83554208211714E-18
      9.11734104328085E-07
      0.00000000000000E+00  -6.14441291918354E-14   0.00000000000000E+00   3.57484003813073E-16  -2.87981227444469E-23
      6.14202345190806E-11   6.14205920030557E-11  -1.31123507786525E-18  -7.77949503125679E-03  -7.77949503128647E-03
      0.00000000000000E+00   0.00000000000000E+00   2.96797177657411E-11   0.00000000000000E+00   2.96797177657411E-11
      5.20931489699051E-18  -2.91461906689628E-01  -2.91433206443723E-01   0.00000000000000E+00  -4.84031082336194E-13
     -1.20938117815023E-22  -9.06162786863402E-11  -9.11003097687973E-11  -3.89807981912527E-18
      9.13734104328085E-07
      0.00000000000000E+00  -6.91590871172676E-14   0.00000000000000E+00   3.14706435727042E-16  -1.83238488704898E-23
      6.91680719008900E-11   6.91683866073074E-11  -1.30813745849683E-18  -7.63344170710654E-03  -7.63344170713371E-03
      0.00000000000000E+00   0.00000000000000E+00   2.71623771724081E-11   0.00000000000000E+00   2.71623771724081E-11
      5.26363965133533E-18  -3.16622327900359E-01  -3.16591980125606E-01   0.00000000000000E+00  -5.00919946123980E-13
     -1.23338960055947E-22  -9.58298438334687E-11  -9.63307637797160E-11  -3.95550219283850E-18
      9.15734104328085E-07
      0.00000000000000E+00  -7.65985108310773E-14   0.00000000000000E+00   2.86227631582855E-16  -4.72294016532830E-24
      7.65772467278405E-11   7.65775329554674E-11  -1.30520274210994E-18  -7.51705899349003E-03  -7.51705899351523E-03
      0.00000000000000E+00   0.00000000000000E+00   2.52021669282021E-11   0.00000000000000E+00   2.52021669282021E-11
      5.31404398519173E-18  -3.41253450239632E-01  -3.41221386140339E-01   0.00000000000000E+00  -5.19030836119290E-13
     -1.25767618546761E-22  -1.01260669047424E-10  -1.01779699883669E-10  -4.00884124308180E-18
      9.17734104328085E-07
      0.00000000000000E+00  -8.37624003332644E-14   0.00000000000000E+00   2.67490027987604E-16   1.13236662467679E-23
      8.37706277022398E-11   8.37708951922791E-11  -1.30244747819822E-18  -7.42574573908678E-03  -7.42574573911038E-03
      0.00000000000000E+00   0.00000000000000E+00   2.35913308041524E-11   0.00000000000000E+00   2.35913308041524E-11
      5.36122664680004E-18  -3.65355862581493E-01  -3.65322040108618E-01   0.00000000000000E+00  -5.39165707297124E-13
     -1.28231064788556E-22  -1.06823060289006E-10  -1.07362225996431E-10  -4.05877916860183E-18
      9.19734104328085E-07
      0.00000000000000E+00  -9.09262898354515E-14   0.00000000000000E+00   2.58142324877365E-16   2.82713291657278E-23
      9.08890529785852E-11   9.08893111209383E-11  -1.29982403872695E-18  -7.37545339156606E-03  -7.37545339158823E-03
      0.00000000000000E+00   0.00000000000000E+00   2.21688661465878E-11   0.00000000000000E+00   2.21688661465878E-11
      5.40556437909322E-18  -3.88929716451888E-01  -3.88894099913060E-01   0.00000000000000E+00  -5.61480499718684E-13
     -1.30735090225226E-22  -1.12496696767677E-10  -1.13058177267526E-10  -4.10574034036627E-18
      9.21734104328085E-07
      0.00000000000000E+00  -9.79064898632235E-14   0.00000000000000E+00   2.48774388787813E-16   4.51043577291358E-23
      9.79135085727844E-11   9.79137573472183E-11  -1.29735653634796E-18  -7.33859682563277E-03  -7.33859682565382E-03
      0.00000000000000E+00   0.00000000000000E+00   2.10458878158363E-11   0.00000000000000E+00   2.10458878158363E-11
      5.44765615472489E-18  -4.12128125877552E-01  -4.12090650569681E-01   0.00000000000000E+00  -5.92798227488767E-13
     -1.33312742204127E-22  -1.18366846935433E-10  -1.18959645163055E-10  -4.15029961837692E-18
      9.22734104328085E-07
      0.00000000000000E+00  -1.01488434614317E-13   0.00000000000000E+00   2.46498166877541E-16   5.36633860204674E-23
      1.01445756248278E-10   1.01446002746499E-10  -1.29616178850990E-18  -7.32286900741904E-03  -7.32286900743952E-03
      0.00000000000000E+00   0.00000000000000E+00   2.04852531033378E-11   0.00000000000000E+00   2.04852531033378E-11
      5.46814140782823E-18  -4.23646182297742E-01  -4.23607771042190E-01   0.00000000000000E+00  -6.19535236844439E-13
     -1.34632372470487E-22  -1.21311720612857E-10  -1.21931255849836E-10  -4.17197961931833E-18
      9.24084104328085E-07
      0.00000000000000E+00  -1.06172516211901E-13   0.00000000000000E+00   2.41064081669052E-16   6.43924972885549E-23
      1.06162586955852E-10   1.06162828019998E-10  -1.29461414762446E-18  -7.30617295893058E-03  -7.30617295895037E-03
      0.00000000000000E+00   0.00000000000000E+00   1.97874578987315E-11   0.00000000000000E+00   1.97874578987315E-11
      5.49485447599152E-18  -4.39008434747946E-01  -4.38968757677251E-01   0.00000000000000E+00  -6.41088639351624E-13
     -1.36445181236908E-22  -1.25309197279242E-10  -1.25950285918730E-10  -4.20024032836706E-18
      9.25906604328085E-07
      0.00000000000000E+00  -1.12417958342013E-13   0.00000000000000E+00   2.35038868241864E-16   7.71219389465481E-23
      1.12451147459529E-10   1.12451382498475E-10  -1.29262890077150E-18  -7.29297254608968E-03  -7.29297254610856E-03
      0.00000000000000E+00   0.00000000000000E+00   1.88835961061847E-11   0.00000000000000E+00   1.88835961061847E-11
      5.52926982989503E-18  -4.59376435473654E-01  -4.59335062509795E-01   0.00000000000000E+00  -6.70426133327254E-13
     -1.38941449106884E-22  -1.30664552471192E-10  -1.31334978604659E-10  -4.23664092912354E-18
      9.27906604328085E-07
      0.00000000000000E+00  -1.19306313632577E-13   0.00000000000000E+00   2.30462255492181E-16   8.90135050653292E-23
      1.19296284894717E-10   1.19296515357062E-10  -1.29055513723022E-18  -7.29260868680098E-03  -7.29260868681890E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79193772296066E-11   0.00000000000000E+00   1.79193772296066E-11
      5.56510858435425E-18  -4.81276423754170E-01  -4.81233198671882E-01   0.00000000000000E+00  -7.07338443204257E-13
     -1.41736560151334E-22  -1.36508554143322E-10  -1.37215892586668E-10  -4.27455344712403E-18
      9.29906604328085E-07
      0.00000000000000E+00  -1.26102824185934E-13   0.00000000000000E+00   2.27668840733261E-16   9.89144837360751E-23
      1.26120170236515E-10   1.26120397905455E-10  -1.28856121042079E-18  -7.31188137202220E-03  -7.31188137203918E-03
      0.00000000000000E+00   0.00000000000000E+00   1.69819925672677E-11   0.00000000000000E+00   1.69819925672677E-11
      5.59907256948879E-18  -5.02730561631554E-01  -5.02685482735363E-01   0.00000000000000E+00  -7.47436396498040E-13
     -1.44576176800122E-22  -1.42354954076080E-10  -1.43102390472722E-10  -4.31051135906799E-18
      9.31906604328085E-07
      0.00000000000000E+00  -1.32991179476499E-13   0.00000000000000E+00   2.27466665650265E-16   1.07037587223367E-22
      1.32972608774924E-10   1.32972836241696E-10  -1.28661179348179E-18  -7.36114121048151E-03  -7.36114121049759E-03
      0.00000000000000E+00   0.00000000000000E+00   1.60746949908311E-11   0.00000000000000E+00   1.60746949908311E-11
      5.63122195947044E-18  -5.23747806846531E-01  -5.23700855732078E-01   0.00000000000000E+00  -7.87783051419597E-13
     -1.47440853684173E-22  -1.48259748180961E-10  -1.49047531232528E-10  -4.34461016598865E-18
      9.33906604328085E-07
      0.00000000000000E+00  -1.40430603190308E-13   0.00000000000000E+00   2.51261158602656E-16   1.13998147470928E-22
      1.40408116066376E-10   1.40408367327649E-10  -1.28446021379118E-18  -7.54931807571678E-03  -7.54931807573181E-03
      0.00000000000000E+00   0.00000000000000E+00   1.50292180592090E-11   0.00000000000000E+00   1.50292180592090E-11
      5.66128039558887E-18  -5.44336862321438E-01  -5.44287898915963E-01   0.00000000000000E+00  -8.22285815477059E-13
     -1.50292399081673E-22  -1.54615299571230E-10  -1.55437585386858E-10  -4.37682018179769E-18
      9.35906604328085E-07
      0.00000000000000E+00  -1.49523232173854E-13   0.00000000000000E+00   3.19913071248874E-16   1.20681687345721E-22
      1.49488732271871E-10   1.49489052185063E-10  -1.28163158803984E-18  -8.08369872179517E-03  -8.08369872180884E-03
      0.00000000000000E+00   0.00000000000000E+00   1.36652039736309E-11   0.00000000000000E+00   1.36652039736309E-11
      5.68861080353613E-18  -5.64504629616300E-01  -5.64453236122618E-01   0.00000000000000E+00  -8.43972146886979E-13
     -1.53077972769438E-22  -1.62310284011652E-10  -1.63154256158692E-10  -4.40697921549629E-18
      9.37906604328085E-07
      0.00000000000000E+00  -1.68167713826981E-13   0.00000000000000E+00   7.11715388528699E-16   1.31866404841508E-22
      1.68193639956528E-10   1.68194351672048E-10  -1.27504790096138E-18  -1.03667546753784E-02  -1.03667546753883E-02
      0.00000000000000E+00   0.00000000000000E+00   9.83584560002401E-12   0.00000000000000E+00   9.83584560002401E-12
      5.70828249473618E-18  -5.84246475400143E-01  -5.84190396831411E-01   0.00000000000000E+00  -7.90327975105034E-13
     -1.55564966129709E-22  -1.77239869296813E-10  -1.78030197272073E-10  -4.43323459377479E-18
      9.39906604328086E-07
      0.00000000000000E+00  -2.79483535322504E-13   0.00000000000000E+00   4.08835518187176E-15   1.87270393770058E-22
      2.79481019179242E-10   2.79485107534612E-10  -1.24001685499024E-18  -2.54626774377533E-02  -2.54626774377389E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.43827433234214E-11   0.00000000000000E+00  -1.43827433234214E-11
      5.67951700808933E-18  -6.03431615848369E-01  -6.03348111462265E-01   0.00000000000000E+00  -1.64711003614098E-13
     -1.56064149009459E-22  -2.64937653207420E-10  -2.65102364211191E-10  -4.43950015309909E-18
      9.41906604328086E-07
      0.00000000000000E+00  -6.23166541953069E-13   0.00000000000000E+00   1.06829396508944E-14   2.82483678561869E-22
      6.23125803444617E-10   6.23136486384550E-10  -1.17047625834747E-18  -5.43655358671211E-02  -5.43655358670760E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.50323652591973E-11   0.00000000000000E+00  -4.50323652591973E-11
      5.58945227757094E-18  -6.21633802884069E-01  -6.21451706015784E-01   0.00000000000000E+00   4.94218482162337E-13
     -1.54527872125262E-22  -5.78598339607360E-10  -5.78104121125353E-10  -4.41897601922347E-18
      9.43906604328086E-07
      0.00000000000000E+00  -1.30557293940499E-12   0.00000000000000E+00   1.87153036920918E-14   3.43997330648586E-22
      1.30554560092838E-09   1.30556431623241E-09  -1.09602063563393E-18  -8.41074981938529E-02  -8.41074981937970E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.59524946180385E-11   0.00000000000000E+00  -5.59524946180385E-11
      5.47754728833486E-18  -6.38178134825932E-01  -6.37784516377891E-01   0.00000000000000E+00   4.74000571707094E-13
     -1.53003043885314E-22  -1.25008582218593E-09  -1.24961182161438E-09  -4.38152665270093E-18
      9.45906604328086E-07
      0.00000000000000E+00  -2.57036681548984E-12   0.00000000000000E+00   3.27930621361537E-14   3.84761663995365E-22
      2.57037813443931E-09   2.57041092750183E-09  -1.02504852420416E-18  -1.13456534586731E-01  -1.13456534586665E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.63060947064101E-11   0.00000000000000E+00  -6.63060947064101E-11
      5.34493509892204E-18  -6.51967760872077E-01  -6.51178980872756E-01   0.00000000000000E+00   3.88337891803051E-13
     -1.51694562917610E-22  -2.50449317068708E-09  -2.50410483279542E-09  -4.31988657471788E-18
      9.47906604328086E-07
      0.00000000000000E+00  -4.69326607130462E-12   0.00000000000000E+00   5.37365001848891E-14   4.17184702406570E-22
      4.69320081276825E-09   4.69325454926885E-09  -9.60996217860726E-19  -1.42274805488843E-01  -1.42274805488764E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.94724802636927E-11   0.00000000000000E+00  -7.94724802636927E-11
      5.18599013839465E-18  -6.61399838165317E-01  -6.59946512709880E-01   0.00000000000000E+00   2.90540008741834E-13
     -1.50650850237330E-22  -4.61407260901375E-09  -4.61378206900516E-09  -4.22499392053393E-18
      9.48906604328086E-07
      0.00000000000000E+00  -6.19253956148028E-12   0.00000000000000E+00   7.52092480941519E-14   4.37211215513981E-22
      6.19250120781191E-09   6.19257641706044E-09  -9.31100460963370E-19  -1.56540733628178E-01  -1.56540733628090E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.82456085094243E-11   0.00000000000000E+00  -8.82456085094243E-11
      5.09774452988523E-18  -6.64610961396274E-01  -6.62688113505403E-01   0.00000000000000E+00   2.24565153295029E-13
     -1.50216723695101E-22  -6.10455537370416E-09  -6.10433080855102E-09  -4.16664406892186E-18
      9.50256604328086E-07
      0.00000000000000E+00  -8.67455173977649E-12   0.00000000000000E+00   9.18230447322683E-14   4.53085399946957E-22
      8.67449814493583E-09   8.67458996798101E-09  -8.93903167563513E-19  -1.75532329405557E-01  -1.75532329405457E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.96679018426742E-11   0.00000000000000E+00  -9.96679018426742E-11
      4.96319286239762E-18  -6.65636406224967E-01  -6.62935319951325E-01   0.00000000000000E+00   2.02625189394326E-13
     -1.49660533073169E-22  -8.57512469132759E-09  -8.57492206613834E-09  -4.06928969483411E-18
      9.52079104328086E-07
      0.00000000000000E+00  -1.29130026724294E-11   0.00000000000000E+00   1.15764673925055E-13   4.60150142572776E-22
      1.29128105222502E-08   1.29129262869246E-08  -8.47652233693669E-19  -2.00686871645914E-01  -2.00686871645800E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13368369056373E-10   0.00000000000000E+00  -1.13368369056373E-10
      4.75657900979238E-18  -6.59522481177451E-01  -6.55490615893153E-01   0.00000000000000E+00   3.27649824413912E-13
     -1.48475337860628E-22  -1.27998855676925E-08  -1.27995579178683E-08  -3.90892677609871E-18
      9.54079104328086E-07
      0.00000000000000E+00  -1.89444465648477E-11   0.00000000000000E+00   1.49800980328889E-13   4.56982686106940E-22
      1.89442289043662E-08   1.89443787053470E-08  -7.99859177027846E-19  -2.27720960275729E-01  -2.27720960275603E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25472757078578E-10   0.00000000000000E+00  -1.25472757078578E-10
      4.50563349563522E-18  -6.41275377153166E-01  -6.35347336831231E-01   0.00000000000000E+00   7.01454017136492E-13
     -1.45746878794228E-22  -1.88196074022855E-08  -1.88189059482685E-08  -3.70577431860738E-18
      9.56079104328086E-07
      0.00000000000000E+00  -2.67329721247832E-11   0.00000000000000E+00   1.93251033547383E-13   4.43712517417723E-22
      2.67327483298636E-08   2.67329415808976E-08  -7.53583715801557E-19  -2.54199533173271E-01  -2.54199533173136E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.34501001779349E-10   0.00000000000000E+00  -1.34501001779349E-10
      4.23663149207653E-18  -6.08295188437736E-01  -5.99916366401183E-01   0.00000000000000E+00   1.28407128957965E-12
     -1.40533483754140E-22  -2.65997246504077E-08  -2.65984405791183E-08  -3.48304777627497E-18
      9.58079104328085E-07
      0.00000000000000E+00  -3.65686250323372E-11   0.00000000000000E+00   2.44019952565794E-13   4.19230981365938E-22
      3.65683741236462E-08   3.65686181435992E-08  -7.07926368616446E-19  -2.80134841369987E-01  -2.80134841369845E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.42116862553146E-10   0.00000000000000E+00  -1.42116862553146E-10
      3.95239776697023E-18  -5.56875494748105E-01  -5.45400330511562E-01   0.00000000000000E+00   1.87639112252293E-12
     -1.32102745749970E-22  -3.64283776721685E-08  -3.64265012810461E-08  -3.24447139835379E-18
      9.60079104328085E-07
      0.00000000000000E+00  -4.83456919949840E-11   0.00000000000000E+00   2.92475296294602E-13   3.75124285615543E-22
      4.83454183458903E-08   4.83457108211869E-08  -6.62646034562873E-19  -3.05532771171125E-01  -3.05532771170973E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51729380933373E-10   0.00000000000000E+00  -1.51729380933373E-10
      3.64893900510349E-18  -4.83555573848762E-01  -4.68372789472279E-01   0.00000000000000E+00   2.14310513203790E-12
     -1.21108225520890E-22  -4.81961245453854E-08  -4.81939814402535E-08  -2.98629297054062E-18
      9.62079104328085E-07
      0.00000000000000E+00  -6.11414089379994E-11   0.00000000000000E+00   3.18272732476560E-13   3.01805924289955E-22
      6.11410551003379E-08   6.11413733730707E-08  -6.17878768518935E-19  -3.30397145325749E-01  -3.30397145325585E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.64499780788884E-10   0.00000000000000E+00  -1.64499780788884E-10
      3.31993944352572E-18  -3.86669928578327E-01  -3.67459361499177E-01   0.00000000000000E+00   1.99163569099938E-12
     -1.09213857467254E-22  -6.09788652279727E-08  -6.09768735922818E-08  -2.70206067500678E-18
      9.64079104328085E-07
      0.00000000000000E+00  -7.28934022873885E-11   0.00000000000000E+00   2.91987281993132E-13   2.35725749035217E-22
      7.28931167623716E-08   7.28934087496538E-08  -5.73662338667380E-19  -3.54736033263977E-01  -3.54736033263799E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.78322268509150E-10   0.00000000000000E+00  -1.78322268509150E-10
      2.96329490650742E-18  -2.68683250081127E-01  -2.45773836423120E-01   0.00000000000000E+00   1.62015212975856E-12
     -9.52816833017035E-23  -7.27167066332743E-08  -7.27150864811446E-08  -2.38963256784004E-18
      9.66079104328085E-07
      0.00000000000000E+00  -7.83005775010072E-11   0.00000000000000E+00   1.35222124545513E-13   1.46465176006509E-22
      7.83003913548204E-08   7.83005265769451E-08  -5.30669782067212E-19  -3.78537659675381E-01  -3.78537659675178E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.03291467654319E-10   0.00000000000000E+00  -2.03291467654319E-10
      2.55671197119878E-18  -1.42413344116124E-01  -1.17807719827510E-01   0.00000000000000E+00   9.92452439803865E-13
     -8.13238162433314E-23  -7.80982275617305E-08  -7.80972351092908E-08  -2.02604218913157E-18
      9.68079104328085E-07
      0.00000000000000E+00  -6.02029394132129E-11   0.00000000000000E+00  -4.49895075728227E-13   4.40535321679762E-23
      6.02033976858071E-08   6.02029477907314E-08  -4.82945155798333E-19  -4.01882942818331E-01  -4.01882942818139E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.92207747727715E-10   0.00000000000000E+00  -1.92207747727715E-10
      2.17229647574335E-18  -5.38547017878070E-02  -3.49473124181220E-02   0.00000000000000E+00   8.79465899717314E-13
     -4.00117922848946E-23  -6.00116195089034E-08  -6.00107400430037E-08  -1.68935131994502E-18
      9.70079104328085E-07
      0.00000000000000E+00  -3.20084419852463E-11   0.00000000000000E+00  -6.98375511973862E-13   1.35262809496979E-23
      3.20091859096215E-08   3.20084875341095E-08  -4.25482371566160E-19  -4.24885293419962E-01  -4.24885293419835E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27697287409961E-10   0.00000000000000E+00  -1.27697287409961E-10
      1.91690190092343E-18  -2.19399724710685E-02  -1.18953676235670E-02   0.00000000000000E+00   8.19002660885108E-13
     -1.40286174679561E-23  -3.18816092493604E-08  -3.18807902466996E-08  -1.49141952935727E-18
      9.72079104328085E-07
      0.00000000000000E+00  -2.07477261351803E-11   0.00000000000000E+00  -2.77830324504651E-13   6.50230889458429E-24
      2.07479849344214E-08   2.07477071040969E-08  -3.68937141376834E-19  -4.47472587026499E-01  -4.47472587026395E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03438076887945E-10   0.00000000000000E+00  -1.03438076887945E-10
      1.71002574714754E-18  -1.25714104787607E-02  -6.06706095622961E-03   0.00000000000000E+00   3.36269187340544E-13
     -7.18892675892059E-24  -2.06446052963963E-08  -2.06442690272089E-08  -1.34108860577070E-18
      9.74079104328085E-07
      0.00000000000000E+00  -1.74546330826044E-11   0.00000000000000E+00  -8.09189565518147E-14   4.49904652077143E-24
      1.74546787654238E-08   1.74545978464673E-08  -3.15014157919753E-19  -4.69612631253311E-01  -4.69612631253211E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.97790140341357E-11   0.00000000000000E+00  -9.97790140341357E-11
      1.51046771907927E-18  -9.78740775423284E-03  -4.31945378736749E-03   0.00000000000000E+00   1.23183151966293E-13
     -5.01145020520150E-24  -1.73549420155851E-08  -1.73548188324331E-08  -1.19545356115951E-18
      9.76079104328085E-07
      0.00000000000000E+00  -1.65575855342985E-11   0.00000000000000E+00  -2.17915909773353E-14   3.68699571353876E-24
      1.65576514756847E-08   1.65576296840937E-08  -2.63659564372415E-19  -4.91303998004397E-01  -4.91303998004296E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01325969492662E-10   0.00000000000000E+00  -1.01325969492662E-10
      1.30781578009394E-18  -8.79427245299901E-03  -3.60940830772649E-03   0.00000000000000E+00   5.70313252197174E-14
     -4.06289798303816E-24  -1.64563607459263E-08  -1.64563037146011E-08  -1.04415621572153E-18
      9.78079104328085E-07
      0.00000000000000E+00  -1.62978486174756E-11   0.00000000000000E+00  -6.10251189093141E-15   3.23299987798679E-24
      1.62978846372114E-08   1.62978785346995E-08  -2.14778773518730E-19  -5.12553814341803E-01  -5.12553814341699E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03694394613603E-10   0.00000000000000E+00  -1.03694394613603E-10
      1.10042699086674E-18  -8.31899094767698E-03  -3.21670923820369E-03   0.00000000000000E+00   3.68576832534683E-14
     -3.50214181667075E-24  -1.61942209977691E-08  -1.61941841400859E-08  -8.85648217348006E-19
      9.80079104328085E-07
      0.00000000000000E+00  -1.62057283460565E-11   0.00000000000000E+00  -1.99626494071495E-15   2.92604949574283E-24
      1.62057638263438E-08   1.62057618300789E-08  -1.68260317710477E-19  -5.33370936129054E-01  -5.33370936128949E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05772276238938E-10   0.00000000000000E+00  -1.05772276238938E-10
      8.88882438388859E-19  -8.02728387576871E-03  -2.95467722675165E-03   0.00000000000000E+00   2.93746342778733E-14
     -3.11011580507316E-24  -1.61000189284742E-08  -1.60999895538400E-08  -7.20622120678381E-19
      9.82079104328085E-07
      0.00000000000000E+00  -1.61625613195689E-11   0.00000000000000E+00  -8.13908401572533E-16   2.69837740284244E-24
      1.61625833295585E-08   1.61625825156501E-08  -1.23960042117800E-19  -5.53763453686797E-01  -5.53763453686690E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07317693193337E-10   0.00000000000000E+00  -1.07317693193337E-10
      6.74247052002185E-19  -7.82161909874243E-03  -2.76310196359170E-03   0.00000000000000E+00   2.54939778041671E-14
     -2.81485492286049E-24  -1.60552903164345E-08  -1.60552648224567E-08  -5.50287009884384E-19
      9.84079104328085E-07
      0.00000000000000E+00  -1.61373040168369E-11   0.00000000000000E+00  -3.93547078875167E-16   2.52100521588893E-24
      1.61372926116010E-08   1.61372922180539E-08  -8.17203326086047E-20  -5.73735414275821E-01  -5.73735414275712E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08303528863740E-10   0.00000000000000E+00  -1.08303528863740E-10
      4.57639994274703E-19  -7.66607972866638E-03  -2.61583954726272E-03   0.00000000000000E+00   2.28709287068320E-14
     -2.58365543016921E-24  -1.60290115601189E-08  -1.60289886891902E-08  -3.75919661666100E-19
      9.86079104328085E-07
      0.00000000000000E+00  -1.61203127404535E-11   0.00000000000000E+00  -2.07272295545747E-16   2.37850732775499E-24
      1.61202850241258E-08   1.61202848168535E-08  -4.14529201557211E-20  -5.93254231160734E-01  -5.93254231160625E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08578923091340E-10   0.00000000000000E+00  -1.08578923091340E-10
      2.40482148092024E-19  -7.54330968170368E-03  -2.49851313907961E-03   0.00000000000000E+00   2.08207582427450E-14
     -2.39796846898841E-24  -1.60117267145204E-08  -1.60117058937621E-08  -1.99029227936302E-19
      9.88079104328085E-07
      0.00000000000000E+00  -1.61063523403979E-11   0.00000000000000E+00  -1.50380902023080E-16   2.26243514032935E-24
      1.61063112134619E-08   1.61063110630810E-08  -3.57864935010704E-21  -6.12032527629002E-01  -6.12032527628895E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06736259071158E-10   0.00000000000000E+00  -1.06736259071158E-10
      2.70096299497085E-20  -7.44338347130291E-03  -2.40240773575648E-03   0.00000000000000E+00   1.88597411403356E-14
     -2.24747542300434E-24  -1.59995936637510E-08  -1.59995748040099E-08  -2.34309805996021E-20
      9.90079104328085E-07
      0.00000000000000E+00  -1.60783396955496E-11   0.00000000000000E+00  -5.17161805006007E-16   2.18058006973920E-24
      1.60783321269033E-08   1.60783316097415E-08   3.10495472436301E-20  -6.29536696680001E-01  -6.29536696679900E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01209484694315E-10   0.00000000000000E+00  -1.01209484694315E-10
     -1.75409339438922E-19  -7.38650010282174E-03  -2.35259743757264E-03   0.00000000000000E+00   1.69993257254789E-14
     -2.14360981523225E-24  -1.59771391243729E-08  -1.59771221250472E-08   1.44359792195291E-19
      9.92079104328084E-07
      0.00000000000000E+00  -1.60578583191524E-11   0.00000000000000E+00  -3.58352235448693E-16   2.11710305005869E-24
      1.60578590832926E-08   1.60578587249404E-08   6.09521776912733E-20  -6.44907282474378E-01  -6.44907282474288E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.01599683447214E-11   0.00000000000000E+00  -9.01599683447214E-11
     -3.55729276128364E-19  -7.34684600513156E-03  -2.31591144323560E-03   0.00000000000000E+00   1.41219863768254E-14
     -2.06390887963510E-24  -1.59677128785820E-08  -1.59676987565957E-08   2.94777098437091E-19
      9.94079104328084E-07
      0.00000000000000E+00  -1.60322336374715E-11   0.00000000000000E+00  -5.21452989303307E-16   2.07039689561539E-24
      1.60322522949238E-08   1.60322517734708E-08   8.37858534057012E-20  -6.56797258017008E-01  -6.56797258016937E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.05080716861823E-11   0.00000000000000E+00  -7.05080716861823E-11
     -4.96745419500729E-19  -7.31760634119558E-03  -2.28854735261231E-03   0.00000000000000E+00   1.05777182054676E-14
     -2.00690235289113E-24  -1.59617542795028E-08  -1.59617437017846E-08   4.12959566095028E-19
      9.94329104328084E-07
      0.00000000000000E+00  -1.60282843137715E-11   0.00000000000000E+00  -6.76035218240486E-16   2.06485456416073E-24
      1.60283027626237E-08   1.60283020865885E-08   8.64835465098284E-20  -6.58210495661156E-01  -6.58210495661088E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.73804564493652E-11   0.00000000000000E+00  -6.73804564493652E-11
     -5.13590533613070E-19  -7.31411848843826E-03  -2.28531842943095E-03   0.00000000000000E+00   9.94484326072695E-15
     -2.00048089723033E-24  -1.59609315749824E-08  -1.59609216301391E-08   4.27106987103242E-19
      9.94666604328084E-07
      0.00000000000000E+00  -1.60223144058530E-11   0.00000000000000E+00  -7.73326332505371E-16   2.05798442098660E-24
      1.60223599366313E-08   1.60223591633049E-08   8.98507757082880E-20  -6.59976921607458E-01  -6.59976921607395E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.24593004507551E-11   0.00000000000000E+00  -6.24593004507551E-11
     -5.34670547515201E-19  -7.30970728735810E-03  -2.28122905631828E-03   0.00000000000000E+00   9.17794201367935E-15
     -1.99232836570440E-24  -1.59599090407962E-08  -1.59598998628542E-08   4.44819771806913E-19
      9.95122229328084E-07
      0.00000000000000E+00  -1.60137728452927E-11   0.00000000000000E+00  -8.51910422716004E-16   2.04969490213011E-24
      1.60137443242139E-08   1.60137434723035E-08   9.38585083388479E-20  -6.62082857252975E-01  -6.62082857252920E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.52377747149318E-11   0.00000000000000E+00  -5.52377747149318E-11
     -5.59838258619691E-19  -7.30429882861729E-03  -2.27625973709041E-03   0.00000000000000E+00   8.09662233752118E-15
     -1.98267221684088E-24  -1.59585137942109E-08  -1.59585056975886E-08   4.65979750280843E-19
      9.95737323078084E-07
      0.00000000000000E+00  -1.60010064268209E-11   0.00000000000000E+00  -9.98974218762947E-16   2.04039800493274E-24
      1.60009780299815E-08   1.60009770310072E-08   9.81948591431452E-20  -6.64365647756642E-01  -6.64365647756597E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.44267020091455E-11   0.00000000000000E+00  -4.44267020091455E-11
     -5.87164845358629E-19  -7.29803630185177E-03  -2.27061314678908E-03   0.00000000000000E+00   6.54952620319840E-15
     -1.97223902536360E-24  -1.59565568785243E-08  -1.59565503289981E-08   4.88969986215484E-19
      9.96567699640584E-07
      0.00000000000000E+00  -1.59816271872701E-11   0.00000000000000E+00  -1.77377390108083E-15   2.03158220941035E-24
      1.59816075039483E-08   1.59816057301744E-08   1.01856129378554E-19  -6.66296084192918E-01  -6.66296084192890E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.78796545251900E-11   0.00000000000000E+00  -2.78796545251900E-11
     -6.10315457046944E-19  -7.29162216477745E-03  -2.26508854071079E-03   0.00000000000000E+00   4.79557338727376E-15
     -1.96327934235042E-24  -1.59537308712226E-08  -1.59537260756492E-08   5.08459327668389E-19
      9.97688707999959E-07
      0.00000000000000E+00  -1.59515021134660E-11   0.00000000000000E+00  -1.33870197264885E-14   2.02731274683020E-24
      1.59514451023833E-08   1.59514317153635E-08   1.02200328831177E-19  -6.66476132349017E-01  -6.66476132349015E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.95191656597822E-12   0.00000000000000E+00  -1.95191656597822E-12
     -6.12503571834208E-19  -7.28713434462319E-03  -2.26193498805439E-03   0.00000000000000E+00   1.25257976552675E-14
     -1.96166070285833E-24  -1.59494923245952E-08  -1.59494797987975E-08   5.10303243003030E-19
      9.99202069285116E-07
      0.00000000000000E+00  -1.59030080922205E-11   0.00000000000000E+00  -2.81116592155857E-13   2.03819577253450E-24
      1.59029856140786E-08   1.59027044974864E-08   9.26661699699865E-20  -6.61449527413212E-01  -6.61449527413252E-01
      0.00000000000000E+00   0.00000000000000E+00   3.97319736835049E-11   0.00000000000000E+00   3.97319736835049E-11
     -5.52374741078745E-19  -7.29019503687038E-03  -2.26713083540711E-03   0.00000000000000E+00   2.74029898682308E-13
     -1.98246882732872E-24  -1.59427105010686E-08  -1.59424364711699E-08   4.59708571108759E-19
      1.00000000000000E-06
      0.00000000000000E+00  -1.58728830184164E-11   0.00000000000000E+00  -5.97254070366026E-15   2.04945043322897E-24
      1.58729252324269E-08   1.58729192598862E-08   8.43021640609531E-20  -6.57058658952794E-01  -6.57058658952859E-01
      0.00000000000000E+00   0.00000000000000E+00   6.56224220731062E-11   0.00000000000000E+00   6.56224220731062E-11
     -5.00012594921509E-19  -7.29477595915954E-03  -2.27302591842540E-03   0.00000000000000E+00  -5.20910361391385E-15
     -2.00161186145412E-24  -1.59385364728556E-08  -1.59385416819593E-08   4.15710430860557E-19
}
